/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), storageWrapper::getInventoryHandler, storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public ItemStack pickup(Level world, ItemStack stack, boolean simulate) {
        if (!this.shouldPickupItems() || !this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        return this.storageWrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        int cooldown;
        if (this.isInCooldown(world)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, world, pos) : 40;
        if (this.shouldPickupXp() && this.canFillStorageWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, world, pos));
        }
        this.setCooldown(world, cooldown);
    }

    private boolean canFillStorageWithXp() {
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> fluidHandler.fill(ModFluids.EXPERIENCE_TAG, 1, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
    }

    private int pickupXpOrbs(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        List xpEntities = world.m_6443_(ExperienceOrb.class, new AABB(pos).m_82400_((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        for (ExperienceOrb xpOrb : xpEntities) {
            if (!xpOrb.m_6084_() || this.canNotPickup((Entity)xpOrb, entity) || this.tryToFillTank(xpOrb, entity, world)) continue;
            cooldown = 40;
            break;
        }
        return cooldown;
    }

    private boolean tryToFillTank(ExperienceOrb xpOrb, @Nullable LivingEntity entity, Level world) {
        int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.m_20801_());
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> {
            int amountAdded = fluidHandler.fill(ModFluids.EXPERIENCE_TAG, amountToTransfer, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE);
            if (amountAdded > 0) {
                Vec3 pos = xpOrb.m_20182_();
                xpOrb.f_20770_ = 0;
                xpOrb.m_146870_();
                Player player = (Player)entity;
                if (player != null) {
                    MagnetUpgradeWrapper.playXpPickupSound(world, player);
                }
                if (amountToTransfer > amountAdded) {
                    world.m_7967_((Entity)new ExperienceOrb(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (int)XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        List itemEntities = world.m_142425_((EntityTypeTest)EntityType.f_20461_, new AABB(pos).m_82400_((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        Player player = (Player)entity;
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.m_6084_() || !this.filterLogic.matchesFilter(itemEntity.m_32055_()) || this.canNotPickup((Entity)itemEntity, entity)) continue;
            if (this.tryToInsertItem(itemEntity)) {
                if (player == null) continue;
                MagnetUpgradeWrapper.playItemPickupSound(world, player);
                continue;
            }
            cooldown = 40;
        }
        return cooldown;
    }

    private static void playItemPickupSound(Level world, @Nonnull Player player) {
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 1.4f + 2.0f);
    }

    private static void playXpPickupSound(Level world, @Nonnull Player player) {
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.35f + 0.9f);
    }

    private boolean isBlockedBySomething(Entity entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(Entity entity, @Nullable LivingEntity player) {
        if (this.isBlockedBySomething(entity)) {
            return true;
        }
        CompoundTag data = entity.getPersistentData();
        return player != null ? data.m_128441_(PREVENT_REMOTE_MOVEMENT) : data.m_128441_(PREVENT_REMOTE_MOVEMENT) && !data.m_128441_(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        IItemHandlerSimpleInserter inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        ItemStack remaining = inventory.insertItem(stack, true);
        boolean insertedSomething = false;
        if (remaining.m_41613_() != stack.m_41613_()) {
            insertedSomething = true;
            remaining = inventory.insertItem(stack, false);
            itemEntity.m_32045_(remaining);
        }
        return insertedSomething;
    }

    public void setPickupItems(boolean pickupItems) {
        NBTHelper.setBoolean(this.upgrade, "pickupItems", pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return NBTHelper.getBoolean(this.upgrade, "pickupItems").orElse(true);
    }

    public void setPickupXp(boolean pickupXp) {
        NBTHelper.setBoolean(this.upgrade, "pickupXp", pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return NBTHelper.getBoolean(this.upgrade, "pickupXp").orElse(true);
    }
}

