/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.ConfigValues;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetworkRegistry.LoginPayload.class}, priority=1001)
public class NetworkRegistryMixin {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(FriendlyByteBuf buffer, ResourceLocation channelName, String messageContext, CallbackInfo ci) {
        double percent = (double)buffer.writerIndex() / 1048576.0 * 100.0;
        if (percent > 20.0) {
            if (percent < 100.0) {
                Connectivity.LOGGER.warn("Login payload for " + messageContext + " is using " + ConfigValues.PERCENT_FORMAT.format(percent) + "% of max allowed vanilla size");
            } else {
                Connectivity.LOGGER.warn("Login payload for " + messageContext + " is using " + ConfigValues.PERCENT_FORMAT.format(percent) + "% of max allowed vanilla size and will cause errors during login if connectivity is not present on client side.");
            }
        }
    }
}

