/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.event.ConfigReloadedEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.network.SyncConfigMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractBalmConfig
implements BalmConfig {
    private final Map<Class<?>, BalmConfigData> activeConfigs = new HashMap();
    private final Map<Class<?>, Function<?, ?>> syncMessageFactories = new HashMap();

    public void initialize() {
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> {
            for (BalmConfigData config : this.activeConfigs.values()) {
                SyncConfigMessage<?> message = this.getConfigSyncMessage(config.getClass());
                if (message == null) continue;
                Balm.getNetworking().sendTo((Player)event.getPlayer(), message);
            }
        });
        Balm.getEvents().onEvent(ConfigReloadedEvent.class, event -> {
            MinecraftServer server = Balm.getHooks().getServer();
            if (server != null) {
                for (BalmConfigData config : this.activeConfigs.values()) {
                    SyncConfigMessage<?> message = this.getConfigSyncMessage(config.getClass());
                    if (message == null) continue;
                    Balm.getNetworking().sendToAll(server, message);
                }
            }
        });
    }

    @Override
    public <T extends BalmConfigData> T getActive(Class<T> clazz) {
        return (T)this.activeConfigs.get(clazz);
    }

    public <T extends BalmConfigData> SyncConfigMessage<T> getConfigSyncMessage(Class<T> clazz) {
        Function<BalmConfigData, SyncConfigMessage<BalmConfigData>> factory = this.getConfigSyncMessageFactory(clazz);
        return factory != null ? factory.apply((BalmConfigData)this.getBackingConfig(clazz)) : null;
    }

    public <T extends BalmConfigData> Function<BalmConfigData, SyncConfigMessage<BalmConfigData>> getConfigSyncMessageFactory(Class<T> clazz) {
        return this.syncMessageFactories.get(clazz);
    }

    public <T extends BalmConfigData> void setActiveConfig(Class<T> clazz, T config) {
        this.activeConfigs.put(clazz, config);
    }

    @Override
    public <T extends BalmConfigData> void handleSync(Player player, SyncConfigMessage<T> message) {
        BalmConfigData data = (BalmConfigData)message.getData();
        this.setActiveConfig(data.getClass(), data);
    }

    @Override
    public <T extends BalmConfigData> void registerConfig(Class<T> clazz, Function<T, SyncConfigMessage<T>> syncMessageFactory) {
        this.setActiveConfig(clazz, Balm.getConfig().initializeBackingConfig(clazz));
        if (syncMessageFactory != null) {
            this.registerSyncMessageFactory(clazz, syncMessageFactory);
        }
    }

    private <T> void registerSyncMessageFactory(Class<T> clazz, Function<T, SyncConfigMessage<T>> syncMessageFactory) {
        this.syncMessageFactories.put(clazz, syncMessageFactory);
    }

    @Override
    public <T extends BalmConfigData> void updateConfig(Class<T> clazz, Consumer<T> consumer) {
        T backingConfig = this.getBackingConfig(clazz);
        consumer.accept(backingConfig);
        Balm.getConfig().saveBackingConfig(clazz);
        T activeConfig = this.getActive(clazz);
        if (activeConfig != backingConfig) {
            consumer.accept(this.getActive(clazz));
        }
    }

    @Override
    public <T extends BalmConfigData> void resetToBackingConfig(Class<T> clazz) {
        this.setActiveConfig(clazz, this.getBackingConfig(clazz));
    }

    @Override
    public void resetToBackingConfigs() {
        for (Class<?> clazz : this.activeConfigs.keySet()) {
            this.resetToBackingConfig(clazz);
        }
    }
}

