/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.light;

import com.jozufozu.flywheel.util.WeakHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakContainmentMultiMap<T>
extends AbstractCollection<T> {
    private final Long2ObjectMap<WeakHashSet<T>> forward = new Long2ObjectOpenHashMap();
    private final WeakHashMap<T, LongSet> reverse = new WeakHashMap();

    public LongSet getAndResetContainment(T listener) {
        LongSet containmentSet = this.reverse.computeIfAbsent(listener, $ -> new LongRBTreeSet());
        containmentSet.forEach(l -> {
            WeakHashSet listeners = (WeakHashSet)this.forward.get(l);
            if (listeners != null) {
                listeners.remove(listener);
            }
        });
        containmentSet.clear();
        return containmentSet;
    }

    public Set<T> get(long l) {
        return (Set)this.forward.get(l);
    }

    public void put(long sectionPos, T listener) {
        ((WeakHashSet)this.forward.computeIfAbsent(sectionPos, $ -> new WeakHashSet())).add(listener);
    }

    @Override
    public boolean remove(Object o) {
        LongSet containmentSet = this.reverse.remove(o);
        if (containmentSet != null) {
            containmentSet.forEach(l -> {
                WeakHashSet listeners = (WeakHashSet)this.forward.get(l);
                if (listeners != null) {
                    listeners.remove(o);
                }
            });
            containmentSet.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.reverse.keySet().iterator();
    }

    @Override
    public int size() {
        return this.reverse.size();
    }
}

