/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import net.minecraft.util.Unit;

public class WeakHashSet<T>
extends AbstractSet<T> {
    WeakHashMap<T, Unit> map;

    public WeakHashSet() {
        this.map = new WeakHashMap();
    }

    public WeakHashSet(Collection<? extends T> c) {
        this.map = new WeakHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll((Collection<? extends T>)c);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this.map = new WeakHashMap(initialCapacity);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(T t) {
        return this.map.put(t, Unit.INSTANCE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.stream().allMatch(this.map::containsKey);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean out = false;
        for (T t : c) {
            out |= this.add(t);
        }
        return out;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

