/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util.box;

import com.jozufozu.flywheel.util.RenderMath;
import com.jozufozu.flywheel.util.box.CoordinateConsumer;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;

public class GridAlignedBB
implements ImmutableBox {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public GridAlignedBB() {
    }

    public GridAlignedBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public static GridAlignedBB ofRadius(int radius) {
        return new GridAlignedBB(-radius, -radius, -radius, radius + 1, radius + 1, radius + 1);
    }

    public static GridAlignedBB from(AABB aabb) {
        int minX = (int)Math.floor(aabb.f_82288_);
        int minY = (int)Math.floor(aabb.f_82289_);
        int minZ = (int)Math.floor(aabb.f_82290_);
        int maxX = (int)Math.ceil(aabb.f_82291_);
        int maxY = (int)Math.ceil(aabb.f_82292_);
        int maxZ = (int)Math.ceil(aabb.f_82293_);
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static GridAlignedBB from(SectionPos pos) {
        return new GridAlignedBB(pos.m_123229_(), pos.m_123234_(), pos.m_123239_(), pos.m_123244_() + 1, pos.m_123247_() + 1, pos.m_123248_() + 1);
    }

    public static GridAlignedBB from(BlockPos start, BlockPos end) {
        return new GridAlignedBB(start.m_123341_(), start.m_123342_(), start.m_123343_(), end.m_123341_() + 1, end.m_123342_() + 1, end.m_123343_() + 1);
    }

    public static GridAlignedBB from(BlockPos pos) {
        return new GridAlignedBB(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1);
    }

    public static GridAlignedBB from(int sectionX, int sectionZ) {
        int startX = sectionX << 4;
        int startZ = sectionZ << 4;
        return new GridAlignedBB(startX, 0, startZ, startX + 16, 256, startZ + 16);
    }

    public static ImmutableBox containingAll(Collection<BlockPos> positions) {
        if (positions.isEmpty()) {
            return new GridAlignedBB();
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : positions) {
            minX = Math.min(minX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxX = Math.max(maxX, pos.m_123341_());
            maxY = Math.max(maxY, pos.m_123342_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void fixMinMax() {
        int minX = Math.min(this.minX, this.maxX);
        int minY = Math.min(this.minY, this.maxY);
        int minZ = Math.min(this.minZ, this.maxZ);
        int maxX = Math.max(this.minX, this.maxX);
        int maxY = Math.max(this.minY, this.maxY);
        int maxZ = Math.max(this.minZ, this.maxZ);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void translate(Vec3i by) {
        this.translate(by.m_123341_(), by.m_123342_(), by.m_123343_());
    }

    public void translate(int x, int y, int z) {
        this.minX += x;
        this.maxX += x;
        this.minY += y;
        this.maxY += y;
        this.minZ += z;
        this.maxZ += z;
    }

    public void mirrorAbout(Direction.Axis axis) {
        Vec3i axisVec = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_();
        int flipX = axisVec.m_123341_() - 1;
        int flipY = axisVec.m_123342_() - 1;
        int flipZ = axisVec.m_123343_() - 1;
        int maxX = this.maxX * flipX;
        int maxY = this.maxY * flipY;
        int maxZ = this.maxZ * flipZ;
        this.maxX = this.minX * flipX;
        this.maxY = this.minY * flipY;
        this.maxZ = this.minZ * flipZ;
        this.minX = maxX;
        this.minY = maxY;
        this.minZ = maxZ;
    }

    public void nextPowerOf2Centered() {
        int sizeX = this.sizeX();
        int sizeY = this.sizeY();
        int sizeZ = this.sizeZ();
        int newSizeX = RenderMath.nextPowerOf2(sizeX);
        int newSizeY = RenderMath.nextPowerOf2(sizeY);
        int newSizeZ = RenderMath.nextPowerOf2(sizeZ);
        int diffX = newSizeX - sizeX;
        int diffY = newSizeY - sizeY;
        int diffZ = newSizeZ - sizeZ;
        this.minX -= diffX / 2;
        this.minY -= diffY / 2;
        this.minZ -= diffZ / 2;
        this.maxX += (diffX + 1) / 2;
        this.maxY += (diffY + 1) / 2;
        this.maxZ += (diffZ + 1) / 2;
    }

    public void nextPowerOf2() {
        int sizeX = RenderMath.nextPowerOf2(this.sizeX());
        int sizeY = RenderMath.nextPowerOf2(this.sizeY());
        int sizeZ = RenderMath.nextPowerOf2(this.sizeZ());
        this.maxX = this.minX + sizeX;
        this.maxY = this.minY + sizeY;
        this.maxZ = this.minZ + sizeZ;
    }

    public void grow(int s) {
        this.grow(s, s, s);
    }

    public void grow(int x, int y, int z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public void intersectAssign(ImmutableBox other) {
        this.minX = Math.max(this.minX, other.getMinX());
        this.minY = Math.max(this.minY, other.getMinY());
        this.minZ = Math.max(this.minZ, other.getMinZ());
        this.maxX = Math.min(this.maxX, other.getMaxX());
        this.maxY = Math.min(this.maxY, other.getMaxY());
        this.maxZ = Math.min(this.maxZ, other.getMaxZ());
    }

    public void unionAssign(ImmutableBox other) {
        this.minX = Math.min(this.minX, other.getMinX());
        this.minY = Math.min(this.minY, other.getMinY());
        this.minZ = Math.min(this.minZ, other.getMinZ());
        this.maxX = Math.max(this.maxX, other.getMaxX());
        this.maxY = Math.max(this.maxY, other.getMaxY());
        this.maxZ = Math.max(this.maxZ, other.getMaxZ());
    }

    public void unionAssign(AABB other) {
        this.minX = Math.min(this.minX, (int)Math.floor(other.f_82288_));
        this.minY = Math.min(this.minY, (int)Math.floor(other.f_82289_));
        this.minZ = Math.min(this.minZ, (int)Math.floor(other.f_82290_));
        this.maxX = Math.max(this.maxX, (int)Math.ceil(other.f_82291_));
        this.maxY = Math.max(this.maxY, (int)Math.ceil(other.f_82292_));
        this.maxZ = Math.max(this.maxZ, (int)Math.ceil(other.f_82293_));
    }

    public void assign(AABB other) {
        this.minX = (int)Math.floor(other.f_82288_);
        this.minY = (int)Math.floor(other.f_82289_);
        this.minZ = (int)Math.floor(other.f_82290_);
        this.maxX = (int)Math.ceil(other.f_82291_);
        this.maxY = (int)Math.ceil(other.f_82292_);
        this.maxZ = (int)Math.ceil(other.f_82293_);
    }

    public void assign(ImmutableBox other) {
        this.minX = other.getMinX();
        this.minY = other.getMinY();
        this.minZ = other.getMinZ();
        this.maxX = other.getMaxX();
        this.maxY = other.getMaxY();
        this.maxZ = other.getMaxZ();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableBox that = (ImmutableBox)o;
        return this.sameAs(that);
    }

    public int hashCode() {
        int result = this.getMinX();
        result = 31 * result + this.getMinY();
        result = 31 * result + this.getMinZ();
        result = 31 * result + this.getMaxX();
        result = 31 * result + this.getMaxY();
        result = 31 * result + this.getMaxZ();
        return result;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMinZ() {
        return this.minZ;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMaxZ() {
        return this.maxZ;
    }

    public GridAlignedBB setMinX(int minX) {
        this.minX = minX;
        return this;
    }

    public GridAlignedBB setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public GridAlignedBB setMinZ(int minZ) {
        this.minZ = minZ;
        return this;
    }

    public GridAlignedBB setMaxX(int maxX) {
        this.maxX = maxX;
        return this;
    }

    public GridAlignedBB setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public GridAlignedBB setMaxZ(int maxZ) {
        this.maxZ = maxZ;
        return this;
    }

    public GridAlignedBB assign(BlockPos start, BlockPos end) {
        this.minX = start.m_123341_();
        this.minY = start.m_123342_();
        this.minZ = start.m_123343_();
        this.maxX = end.m_123341_() + 1;
        this.maxY = end.m_123342_() + 1;
        this.maxZ = end.m_123343_() + 1;
        return this;
    }

    public GridAlignedBB setMax(Vec3i v) {
        return this.setMax(v.m_123341_(), v.m_123342_(), v.m_123343_());
    }

    public GridAlignedBB setMin(Vec3i v) {
        return this.setMin(v.m_123341_(), v.m_123342_(), v.m_123343_());
    }

    public GridAlignedBB setMax(int x, int y, int z) {
        this.maxX = x;
        this.maxY = y;
        this.maxZ = z;
        return this;
    }

    public GridAlignedBB setMin(int x, int y, int z) {
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        return this;
    }

    @Override
    public int sizeX() {
        return this.maxX - this.minX;
    }

    @Override
    public int sizeY() {
        return this.maxY - this.minY;
    }

    @Override
    public int sizeZ() {
        return this.maxZ - this.minZ;
    }

    @Override
    public boolean empty() {
        return this.minX == this.maxX || this.minY == this.maxY || this.minZ == this.maxZ;
    }

    @Override
    public boolean sameAs(ImmutableBox other) {
        return this.minX == other.getMinX() && this.minY == other.getMinY() && this.minZ == other.getMinZ() && this.maxX == other.getMaxX() && this.maxY == other.getMaxY() && this.maxZ == other.getMaxZ();
    }

    @Override
    public boolean sameAs(AABB other) {
        return (double)this.minX == Math.floor(other.f_82288_) && (double)this.minY == Math.floor(other.f_82289_) && (double)this.minZ == Math.floor(other.f_82290_) && (double)this.maxX == Math.ceil(other.f_82291_) && (double)this.maxY == Math.ceil(other.f_82292_) && (double)this.maxZ == Math.ceil(other.f_82293_);
    }

    @Override
    public GridAlignedBB intersect(ImmutableBox other) {
        int minX = Math.max(this.minX, other.getMinX());
        int minY = Math.max(this.minY, other.getMinY());
        int minZ = Math.max(this.minZ, other.getMinZ());
        int maxX = Math.min(this.maxX, other.getMaxX());
        int maxY = Math.min(this.maxY, other.getMaxY());
        int maxZ = Math.min(this.maxZ, other.getMaxZ());
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public ImmutableBox union(ImmutableBox other) {
        int minX = Math.min(this.minX, other.getMinX());
        int minY = Math.min(this.minY, other.getMinY());
        int minZ = Math.min(this.minZ, other.getMinZ());
        int maxX = Math.max(this.maxX, other.getMaxX());
        int maxY = Math.max(this.maxY, other.getMaxY());
        int maxZ = Math.max(this.maxZ, other.getMaxZ());
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public boolean contains(ImmutableBox other) {
        return other.getMinX() >= this.minX && other.getMaxX() <= this.maxX && other.getMinY() >= this.minY && other.getMaxY() <= this.maxY && other.getMinZ() >= this.minZ && other.getMaxZ() <= this.maxZ;
    }

    @Override
    public boolean intersects(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.minX < maxX && this.maxX > minX && this.minY < maxY && this.maxY > minY && this.minZ < maxZ && this.maxZ > minZ;
    }

    @Override
    public void forEachContained(CoordinateConsumer func) {
        if (this.empty()) {
            return;
        }
        for (int x = this.minX; x < this.maxX; ++x) {
            for (int y = this.minY; y < this.maxY; ++y) {
                for (int z = this.minZ; z < this.maxZ; ++z) {
                    func.consume(x, y, z);
                }
            }
        }
    }

    @Override
    public AABB toAABB() {
        return new AABB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    @Override
    public GridAlignedBB copy() {
        return new GridAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "(" + this.minX + ", " + this.minY + ", " + this.minZ + ")->(" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ")";
    }
}

