#version 330 compatibility




/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/


#include "lib/Uniforms.inc"
#include "lib/Common.inc"


const bool colortex6MipmapEnabled = false;


in vec4 texcoord;

in vec3 lightVector;
in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

#include "lib/GBufferData.inc"


// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }





#include "lib/Materials.inc"


 int f(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-0;
 }
 int t(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-1;
 }
 int f()
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int y=v.x*v.y;
   return f(FloorToInt(floor(pow(float(y),.333333))));
 }
 int t()
 {
   ivec2 v=ivec2(2048,2048);
   int y=v.x*v.y;
   return t(FloorToInt(floor(pow(float(y),.333333))));
 }
 vec3 d(vec2 v)
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int x=m.x*m.y,y=f();
   ivec2 d=ivec2(v.x*m.x,v.y*m.y);
   float z=float(d.y/y),i=float(int(d.x+mod(m.x*z,y))/y);
   i+=floor(m.x*z/y);
   vec3 s=vec3(0.,0.,i);
   s.x=mod(d.x+mod(m.x*z,y),y);
   s.y=mod(d.y,y);
   s.xyz=floor(s.xyz);
   s/=y;
   s.xyz=s.xzy;
   return s;
 }
 vec2 e(vec3 v)
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int x=f();
   vec3 i=v.xzy*x;
   i=floor(i+1e-05);
   float y=i.z;
   vec2 r;
   r.x=mod(i.x+y*x,m.x);
   float s=i.x+y*x;
   r.y=i.y+floor(s/m.x)*x;
   r+=.5;
   r/=m;
   return r;
 }
 vec3 x(vec2 v)
 {
   vec2 i=v;
   i.xy/=.5;
   ivec2 m=ivec2(2048,2048);
   int x=m.x*m.y,y=t();
   ivec2 s=ivec2(i.x*m.x,i.y*m.y);
   float z=float(s.y/y),f=float(int(s.x+mod(m.x*z,y))/y);
   f+=floor(m.x*z/y);
   vec3 r=vec3(0.,0.,f);
   r.x=mod(s.x+mod(m.x*z,y),y);
   r.y=mod(s.y,y);
   r.xyz=floor(r.xyz);
   r/=y;
   r.xyz=r.xzy;
   return r;
 }
 vec2 d(vec3 v,int y)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   vec2 m=vec2(2048,2048);
   vec3 i=v.xzy*y;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 r;
   r.x=mod(i.x+x*y,m.x);
   float s=i.x+x*y;
   r.y=i.y+floor(s/m.x)*y;
   r+=.5;
   r/=m;
   r.xy*=.5;
   return r;
 }
 vec3 e(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 f(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 v(vec3 v)
 {
   int m=t();
   v=v-vec3(.5);
   v*=m;
   return v;
 }
 vec3 n(vec3 v)
 {
   int x=f();
   v*=1./x;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 s(vec3 v)
 {
   int m=f();
   v=v-vec3(.5);
   v*=m;
   return v;
 }
 vec3 d()
 {
   vec3 v=cameraPosition.xyz+.5,i=previousCameraPosition.xyz+.5,y=floor(v-.0001),x=floor(i-.0001);
   return y-x;
 }
 vec3 m(vec3 v)
 {
   vec4 i=vec4(v,1.);
   i=shadowModelView*i;
   i=shadowProjection*i;
   i/=i.w;
   float x=sqrt(i.x*i.x+i.y*i.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   i.xy*=.95f/y;
   i.z=mix(i.z,.5,.8);
   i=i*.5f+.5f;
   i.xy*=.5;
   i.xy+=.5;
   return i.xyz;
 }
 vec3 d(vec3 v,vec3 m,vec2 i,vec2 r,vec4 s,vec4 f,inout float x,out vec2 y)
 {
   bool z=fract(v.x*2.)>.01&&fract(v.x*2.)<.99||fract(v.y*2.)>.01&&fract(v.y*2.)<.99||fract(v.z*2.)>.01&&fract(v.z*2.)<.99;
   z=!z;
   if(f.x==8||f.x==9||f.x==79||f.x<1.||!z||f.x==20.||f.x==171.||min(abs(m.x),abs(m.z))>.2)
     x=1.;
   if(f.x==50.||f.x==52.||f.x==76.)
     {
       x=0.;
       if(m.y<.5)
         x=1.;
     }
   if(f.x==51||f.x==53)
     x=0.;
   if(f.x>255)
     x=0.;
   vec3 e,c;
   if(m.x>.5)
     e=vec3(0.,0.,-1.),c=vec3(0.,-1.,0.);
   else
      if(m.x<-.5)
       e=vec3(0.,0.,1.),c=vec3(0.,-1.,0.);
     else
        if(m.y>.5)
         e=vec3(1.,0.,0.),c=vec3(0.,0.,1.);
       else
          if(m.y<-.5)
           e=vec3(1.,0.,0.),c=vec3(0.,0.,-1.);
         else
            if(m.z>.5)
             e=vec3(1.,0.,0.),c=vec3(0.,-1.,0.);
           else
              if(m.z<-.5)
               e=vec3(-1.,0.,0.),c=vec3(0.,-1.,0.);
   y=clamp((i.xy-r.xy)*100000.,vec2(0.),vec2(1.));
   float h=.15,t=.15;
   if(f.x==10.||f.x==11.)
     {
       if(abs(m.y)<.01&&z||m.y>.99)
         h=.1,t=.1,x=0.;
       else
          x=1.;
     }
   if(f.x==51||f.x==53)
     h=.5,t=.1;
   if(f.x==76)
     h=.2,t=.2;
   if(f.x-255.+39.>=103.&&f.x-255.+39.<=113.)
     t=.025,h=.025;
   e=normalize(s.xyz);
   c=normalize(cross(e,m.xyz)*sign(s.w));
   vec3 d=v.xyz+mix(e*h,-e*h,vec3(y.x));
   d.xyz+=mix(c*h,-c*h,vec3(y.y));
   d.xyz-=m.xyz*t;
   return d;
 }struct rXuEJcsNQI{vec3 QbpObHBdUl;vec3 QbpObHBdUlOrigin;vec3 ZRrfSsHfvT;vec3 fgCeZiNBHZ;vec3 ZKdJsVHIyK;vec3 frnQIYJjVJ;};
 rXuEJcsNQI r(Ray v)
 {
   rXuEJcsNQI i;
   i.QbpObHBdUl=floor(v.origin);
   i.QbpObHBdUlOrigin=i.QbpObHBdUl;
   i.ZRrfSsHfvT=abs(vec3(length(v.direction))/(v.direction+1e-07));
   i.fgCeZiNBHZ=sign(v.direction);
   i.ZKdJsVHIyK=(sign(v.direction)*(i.QbpObHBdUl-v.origin)+sign(v.direction)*.5+.5)*i.ZRrfSsHfvT;
   i.frnQIYJjVJ=vec3(0.);
   return i;
 }
 void w(inout rXuEJcsNQI v)
 {
   v.frnQIYJjVJ=step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.yzx)*step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.zxy),v.ZKdJsVHIyK+=v.frnQIYJjVJ*v.ZRrfSsHfvT,v.QbpObHBdUl+=v.frnQIYJjVJ*v.fgCeZiNBHZ;
 }
 void d(in Ray v,in vec3 i[2],out float f,out float y)
 {
   float x,z,r,s;
   f=(i[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   y=(i[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   x=(i[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   z=(i[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   r=(i[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   s=(i[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   f=max(max(f,x),r);
   y=min(min(y,z),s);
 }
 vec3 d(const vec3 v,const vec3 y,vec3 m)
 {
   const float x=1e-05;
   vec3 z=(y+v)*.5,i=(y-v)*.5,f=m-z,s=vec3(0.);
   s+=vec3(sign(f.x),0.,0.)*step(abs(abs(f.x)-i.x),x);
   s+=vec3(0.,sign(f.y),0.)*step(abs(abs(f.y)-i.y),x);
   s+=vec3(0.,0.,sign(f.z))*step(abs(abs(f.z)-i.z),x);
   return normalize(s);
 }
 bool e(const vec3 v,const vec3 y,Ray m,out vec2 i)
 {
   vec3 x=m.inv_direction*(v-m.origin),s=m.inv_direction*(y-m.origin),f=min(s,x),d=max(s,x);
   vec2 r=max(f.xx,f.yz);
   float z=max(r.x,r.y);
   r=min(d.xx,d.yz);
   float t=min(r.x,r.y);
   i.x=z;
   i.y=t;
   return t>max(z,0.);
 }
 bool d(const vec3 v,const vec3 f,Ray m,inout float x,inout vec3 y)
 {
   vec3 z=m.inv_direction*(v-1e-05-m.origin),s=m.inv_direction*(f+1e-05-m.origin),i=min(s,z),r=max(s,z);
   vec2 c=max(i.xx,i.yz);
   float t=max(c.x,c.y);
   c=min(r.xx,r.yz);
   float p=min(c.x,c.y);
   bool e=p>max(t,0.)&&max(t,0.)<x;
   if(e)
     y=d(v-1e-05,f+1e-05,m.origin+m.direction*t),x=t;
   return e;
 }
 vec3 e(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 i=m(v);
   float s=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*s),2).x;
   r*=saturate(dot(f,y));
   {
     vec4 d=texture2DLod(shadowcolor1,i.xy-vec2(0.,.5),4);
     float t=abs(d.x*256.-(v.y+cameraPosition.y)),c=GetCausticsComposite(v,f,t),h=shadow2DLod(shadowtex0,vec3(i.xy-vec2(0.,.5),i.z+1e-06),4).x;
     r=mix(r,r*c,1.-h);
   }
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 f(vec3 y,vec3 f,vec3 x,vec3 z,int t)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 i=v(y);
   i+=1.;
   i-=Fract01(cameraPosition+.5);
   vec3 s=m(i+x*.99);
   float r=.5;
   vec3 c=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*r),3).x;
   c*=saturate(dot(f,x));
   c=TintUnderwaterDepth(c);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float h=shadow2DLod(shadowtex0,vec3(s.xy-vec2(.5,0.),s.z-.0006*r),3).x;
   vec3 e=texture2DLod(shadowcolor,vec2(s.xy-vec2(.5,0.)),3).xyz;
   e*=e;
   c=mix(c,c*e,vec3(1.-h));
   #endif
   return c*(1.-rainStrength);
 }
 vec3 m(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 i=m(v);
   float s=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(i.xy,i.z-.0006*s),2).x;
   r*=saturate(dot(f,y));
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float t=shadow2DLod(shadowtex0,vec3(i.xy-vec2(.5,0.),i.z-.0006*s),3).x;
   vec3 e=texture2DLod(shadowcolor,vec2(i.xy-vec2(.5,0.)),3).xyz;
   e*=e;
   r=mix(r,r*e,vec3(1.-t));
   #endif
   return r*(1.-rainStrength);
 }struct awIafiSlNY{float mwtAZpOIMX;float KZGLOOTLva;float yDFXZDbcEk;float cvVAxIXMRt;vec3 jbwXZaPXmq;};
 vec4 p(awIafiSlNY v)
 {
   vec4 i;
   v.jbwXZaPXmq=max(vec3(0.),v.jbwXZaPXmq);
   i.x=v.mwtAZpOIMX;
   v.jbwXZaPXmq=pow(v.jbwXZaPXmq,vec3(.125));
   i.y=PackTwo16BitTo32Bit(v.jbwXZaPXmq.x,v.yDFXZDbcEk);
   i.z=PackTwo16BitTo32Bit(v.jbwXZaPXmq.y,v.cvVAxIXMRt);
   i.w=PackTwo16BitTo32Bit(v.jbwXZaPXmq.z,v.KZGLOOTLva/255.);
   return i;
 }
 awIafiSlNY h(vec4 v)
 {
   awIafiSlNY i;
   vec2 m=UnpackTwo16BitFrom32Bit(v.y),f=UnpackTwo16BitFrom32Bit(v.z),s=UnpackTwo16BitFrom32Bit(v.w);
   i.mwtAZpOIMX=v.x;
   i.yDFXZDbcEk=m.y;
   i.cvVAxIXMRt=f.y;
   i.KZGLOOTLva=s.y*255.;
   i.jbwXZaPXmq=pow(vec3(m.x,f.x,s.x),vec3(8.));
   return i;
 }
 awIafiSlNY i(vec2 v)
 {
   vec2 x=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*x;
   return h(texture2DLod(colortex5,v,0));
 }
 float h(float v,float y)
 {
   float x=1.;
   #ifdef FULL_RT_REFLECTIONS
   x=clamp(pow(v,.125)+y,0.,1.);
   #else
   x=clamp(v*10.-7.,0.,1.);
   #endif
   return x;
 }
 bool d(vec3 v,float y,Ray f,bool s,inout float x,inout vec3 i)
 {
   bool r=false,m=false;
   #if RAYTRACE_GEOMETRY_QUALITY==0
   if(s)
     return false;
   if(y>=67.)
     return false;
   m=d(v,v+vec3(1.,1.,1.),f,x,i);
   r=m;
   #else
   if(y<40.)
     return m=d(v,v+vec3(1.,1.,1.),f,x,i),m;
   if(y==40.||y==41.||y>=43.&&y<=54.)
     {
       float z=.5;
       if(y==41.)
         z=.9375;
       m=d(v+vec3(0.,0.,0.),v+vec3(1.,z,1.),f,x,i);
       r=r||m;
     }
   if(y==42.||y>=55.&&y<=66.)
     m=d(v+vec3(0.,.5,0.),v+vec3(1.,1.,1.),f,x,i),r=r||m;
   if(y==43.||y==46.||y==47.||y==52.||y==53.||y==54.||y==55.||y==58.||y==59.||y==64.||y==65.||y==66.)
     {
       float z=.5;
       if(y==55.||y==58.||y==59.||y==64.||y==65.||y==66.)
         z=0.;
       m=d(v+vec3(0.,z,0.),v+vec3(.5,.5+z,.5),f,x,i);
       r=r||m;
     }
   if(y==43.||y==45.||y==48.||y==51.||y==53.||y==54.||y==55.||y==57.||y==60.||y==63.||y==65.||y==66.)
     {
       float z=.5;
       if(y==55.||y==57.||y==60.||y==63.||y==65.||y==66.)
         z=0.;
       m=d(v+vec3(.5,z,0.),v+vec3(1.,.5+z,.5),f,x,i);
       r=r||m;
     }
   if(y==44.||y==45.||y==49.||y==51.||y==52.||y==54.||y==56.||y==57.||y==61.||y==63.||y==64.||y==66.)
     {
       float z=.5;
       if(y==56.||y==57.||y==61.||y==63.||y==64.||y==66.)
         z=0.;
       m=d(v+vec3(.5,z,.5),v+vec3(1.,.5+z,1.),f,x,i);
       r=r||m;
     }
   if(y==44.||y==46.||y==50.||y==51.||y==52.||y==53.||y==56.||y==58.||y==62.||y==63.||y==64.||y==65.)
     {
       float z=.5;
       if(y==56.||y==58.||y==62.||y==63.||y==64.||y==65.)
         z=0.;
       m=d(v+vec3(0.,z,.5),v+vec3(.5,.5+z,1.),f,x,i);
       r=r||m;
     }
   if(y>=67.&&y<=82.)
     m=d(v+vec3(6.,0.,6.)/16.,v+vec3(10.,16.,10.)/16.,f,x,i),r=r||m;
   if(y==68.||y==69.||y==70.||y==72.||y==73.||y==74.||y==76.||y==77.||y==78.||y==80.||y==81.||y==82.)
     {
       float z=8.,c=8.;
       if(y==68.||y==70.||y==72.||y==74.||y==76.||y==78.||y==80.||y==82.)
         z=0.;
       if(y==69.||y==70.||y==73.||y==74.||y==77.||y==78.||y==81.||y==82.)
         c=16.;
       m=d(v+vec3(z,6.,7.)/16.,v+vec3(c,9.,9.)/16.,f,x,i);
       r=r||m;
       m=d(v+vec3(z,12.,7.)/16.,v+vec3(c,15.,9.)/16.,f,x,i);
       r=r||m;
     }
   if(y>=71.&&y<=82.)
     {
       float z=8.,t=8.;
       if(y>=71.&&y<=74.||y>=79.&&y<=82.)
         t=16.;
       if(y>=75.&&y<=82.)
         z=0.;
       m=d(v+vec3(7.,6.,z)/16.,v+vec3(9.,9.,t)/16.,f,x,i);
       r=r||m;
       m=d(v+vec3(7.,12.,z)/16.,v+vec3(9.,15.,t)/16.,f,x,i);
       r=r||m;
     }
   #if RAYTRACE_GEOMETRY_QUALITY==2
   if(y>=83.&&y<=86.)
     {
       vec3 z=vec3(0),c=vec3(0);
       if(y==83.)
         z=vec3(0,0,0),c=vec3(16,16,3);
       if(y==84.)
         z=vec3(0,0,13),c=vec3(16,16,16);
       if(y==86.)
         z=vec3(0,0,0),c=vec3(3,16,16);
       if(y==85.)
         z=vec3(13,0,0),c=vec3(16,16,16);
       m=d(v+z/16.,v+c/16.,f,x,i);
       r=r||m;
     }
   if(y>=87.&&y<=102.)
     {
       vec3 z=vec3(0.),c=vec3(1.);
       if(y>=87.&&y<=94.)
         {
           float t=0.;
           if(y>=91.&&y<=94.)
             t=13.;
           z=vec3(0.,t,0.)/16.;
           c=vec3(16.,t+3.,16.)/16.;
         }
       if(y>=95.&&y<=98.)
         {
           float t=13.;
           if(y==97.||y==98.)
             t=0.;
           z=vec3(0.,0.,t)/16.;
           c=vec3(16.,16.,t+3.)/16.;
         }
       if(y>=99.&&y<=102.)
         {
           float t=13.;
           if(y==99.||y==100.)
             t=0.;
           z=vec3(t,0.,0.)/16.;
           c=vec3(t+3.,16.,16.)/16.;
         }
       m=d(v+z,v+c,f,x,i);
       r=r||m;
     }
   if(y>=103.&&y<=113.)
     {
       vec3 z=vec3(0.),c=vec3(1.);
       if(y>=103.&&y<=110.)
         {
           float t=float(y)-float(103.)+1.;
           c.y=t*2./16.;
         }
       if(y==111.)
         c.y=.0625;
       if(y==112.)
         z=vec3(1.,0.,1.)/16.,c=vec3(15.,1.,15.)/16.;
       if(y==113.)
         z=vec3(1.,0.,1.)/16.,c=vec3(15.,.5,15.)/16.;
       m=d(v+z,v+c,f,x,i);
       r=r||m;
     }
   #endif
   #endif
   return r;
 }
 vec3 G(vec2 v)
 {
   vec2 y=vec2(v.xy*vec2(viewWidth,viewHeight));
   y*=1./64.;
   const vec2 i[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   y=(floor(y*64.)+.5)/64.;
   vec3 r=texture2D(noisetex,y).xyz,x=vec3(sqrt(.2),sqrt(2.),1.61803);
   r=mod(r+float(frameCounter%64)*x,vec3(1.));
   return r;
 }
 float G(float v,float y)
 {
   return 1./(v*(1.-y)+y);
 }
 void G(inout vec3 v,in vec3 y,in vec3 x,vec3 z,float i)
 {
   float r=length(y);
   r*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   r*=rainStrength;
   float s=pow(exp(-r*3e-06),4.);
   vec3 f=vec3(dot(colorSkyUp,vec3(1.)));
   v=mix(f,v,vec3(s));
 }
 vec4 c(vec2 v)
 {
   vec2 y=vec2(v.x,(v.y-floor(mod(FRAME_TIME*60.f,60.f)))/60.f);
   return texture2DLod(colortex4,y.xy,0);
 }
 float c(vec3 v,float y)
 {
   vec3 i=v.xyz+cameraPosition.xyz,m=refract(worldLightVector,vec3(0.,1.,0.),.750188);
   i+=m*((v.y+cameraPosition.y)/m.y);
   vec4 f=c(mod(i.xz/4.,vec2(1.)))*13.;
   float x=pow(y/2.,.5),r=pow(f.x,saturate(x*.5+.5));
   r=mix(r,f.y,saturate(x-1.));
   r=mix(r,f.z,saturate(x-2.));
   r=mix(r,f.w,saturate(x-3.));
   return r;
 }
 float i(float v,float y)
 {
   return exp(-pow(v/(.9*y),2.));
 }
 float m(vec3 v,vec3 y)
 {
   return dot(abs(v-y),vec3(.3333));
 }
 vec3 a(vec2 v)
 {
   vec2 y=vec2(v.xy*ScreenSize)/64.;
   const vec2 i[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   y=(floor(y*64.)+.5)/64.;
   vec3 r=texture2D(noisetex,y).xyz,x=vec3(sqrt(.2),sqrt(2.),1.61803);
   r=mod(r+vec3(x)*mod(frameCounter,64.f),vec3(1.));
   return r;
 }
 vec3 G(float v,float m,float x,vec3 y)
 {
   vec3 i;
   i.x=x*cos(v);
   i.y=x*sin(v);
   i.z=m;
   vec3 z=abs(y.y)<.999?vec3(0,0,1):vec3(1,0,0),f=normalize(cross(y,vec3(0.,1.,1.))),c=cross(f,y);
   return f*i.x+c*i.y+y*i.z;
 }
 vec3 G(vec2 v,float y,vec3 i)
 {
   float x=2*3.14159*v.x,z=sqrt((1-v.y)/(1+(y*y-1)*v.y)),f=sqrt(1-z*z);
   return G(x,z,f,i);
 }
 float g(float v)
 {
   return 2./(v*v+1e-07)-2.;
 }
 vec3 a(in vec2 v,in float y,in vec3 i)
 {
   float x=g(y),f=2*3.14159*v.x,z=pow(v.y,1.f/(x+1.f)),r=sqrt(1-z*z);
   return G(f,z,r,i);
 }
 float l(vec2 v)
 {
   return texture2DLod(colortex1,v+HalfScreen,0).w;
 }
 float a(float v,float y)
 {
   return v/(y*20.01+1.);
 }
 vec2 g(vec2 v,float y)
 {
   vec2 x=v;
   mat2 m=mat2(cos(y),-sin(y),sin(y),cos(y));
   v=m*v;
   return v;
 }
 vec4 G(sampler2D v,float x,bool y,float f,float z,float i,float t)
 {
   GBufferData m=GetGBufferData(texcoord.xy);
   GBufferDataTransparent r=GetGBufferDataTransparent(texcoord.xy);
   bool s=r.depth<m.depth;
   if(s)
     m.normal=r.normal,m.smoothness=r.smoothness,m.metalness=0.,m.mcLightmap=r.mcLightmap,m.depth=r.depth;
   vec4 c=GetViewPosition(texcoord.xy,m.depth),e=gbufferModelViewInverse*vec4(c.xyz,1.),d=gbufferModelViewInverse*vec4(c.xyz,0.);
   vec3 n=normalize(c.xyz),p=normalize(d.xyz),l=normalize((gbufferModelViewInverse*vec4(m.normal,0.)).xyz);
   float G=GetDepthLinear(texcoord.xy),w=dot(-n,m.normal.xyz),T=1.-m.smoothness,o=T*T,R=h(m.smoothness,m.metalness);
   vec4 F=texture2DLod(v,texcoord.xy+HalfScreen,0);
   float Z=Luminance(F.xyz);
   if(R<.001)
     return F;
   float P=x*.9;
   P*=min(o*20.,1.1);
   P*=mix(F.w,1.,.2);
   vec2 H=vec2(0.);
   if(y)
     {
       vec2 B=BlueNoiseTemporal(texcoord.xy).xy*.99+.005;
       H=B-.5;
     }
   float q=BlueNoiseTemporal(texcoord.xy).x,S=1.1,b=a(f,m.totalTexGrad)/(o+.0001),J=a(z*.5,m.totalTexGrad);
   vec4 K=vec4(0.),Y=vec4(0.);
   float B=0.;
   vec4 Q=vec4(vec3(i),1.);
   Q.xyz=vec3(.25);
   Q.xyz*=F.w*.95+.05;
   float X=m.smoothness;
   vec2 D=normalize(cross(m.normal,n).xy),k=g(D,1.5708);
   float L=1.-pow(1.-saturate(w),1.);
   D*=mix(.1075,.5,L);
   k*=mix(mix(.7,.7,o),.5,L);
   vec3 j=reflect(-n,m.normal);
   int M=0;
   for(int u=-1;u<=1;u++)
     {
       for(int I=-1;I<=1;I++)
         {
           vec2 U=vec2(u,I)+H;
           U=U.x*D+U.y*k;
           U*=P*1.5*ScreenTexel;
           vec2 V=texcoord.xy+U.xy;
           float A=length(U*ScreenSize);
           V=clamp(V,4.*ScreenTexel,1.-4.*ScreenTexel);
           vec4 C=texture2DLod(v,V+HalfScreen,0);
           vec3 E=GetNormals(V);
           float O=GetDepthLinear(V),W=pow(saturate(dot(j,reflect(-n,E))),115./o),N=exp(-(abs(O-G)*S)),ab=W*N;
           K+=vec4(pow(length(C.xyz),Q.x)*normalize(C.xyz+1e-10),C.w)*ab;
           B+=ab;
           Y+=C;
           M++;
         }
     }
   K/=B+.0001;
   K.xyz=pow(length(K.xyz),1./Q.x)*normalize(K.xyz+1e-06);
   vec4 U=K;
   if(B<.001)
     U=F;
   return U;
 }
 void main()
 {
   GBufferData v=GetGBufferData(texcoord.xy);
   GBufferDataTransparent y=GetGBufferDataTransparent(texcoord.xy);
   MaterialMask x=CalculateMasks(v.materialID,texcoord.xy),i=CalculateMasks(y.materialID,texcoord.xy);
   bool z=y.depth<v.depth;
   if(z)
     v.normal=y.normal,v.smoothness=y.smoothness,v.metalness=0.,v.mcLightmap=y.mcLightmap,v.depth=y.depth,i.sky=0.;
   vec4 f=GetViewPosition(texcoord.xy,v.depth),c=gbufferModelViewInverse*vec4(f.xyz,1.),m=gbufferModelViewInverse*vec4(f.xyz,0.);
   vec3 r=normalize(f.xyz),s=normalize(m.xyz),t=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz);
   float e=ExpToLinearDepth(v.depth),n=1.-v.smoothness,d=n*n,o=h(v.smoothness,v.metalness);
   int w=0;
   vec4 p=texture2DLod(colortex7,texcoord.xy+HalfScreen,w),K=p;
   float U=1.-v.smoothness,a=U*U;
   vec3 l=t,V=-s,H=normalize(reflect(-V,l)+l*a),L=normalize(V+H);
   float F=saturate(dot(l,H)),R=saturate(dot(l,V)),b=saturate(dot(l,L)),T=saturate(dot(H,L)),B=v.metalness*.98+.02,S=pow(1.-T,5.),J=B+(1.-B)*S,q=a/2.,k=G(F,q)*G(R+.8,q),D=F*J*k;
   K.xyz*=mix(vec3(1.),v.albedo.xyz,vec3(v.metalness));
   D=mix(D,1.,v.metalness);
   if(v.depth>.99999)
     D=0.;
   if(i.water>.5&&isEyeInWater>0)
     {
       if(length(refract(V,l,1.3333))<.5)
         D=1.;
       else
          D=0.;
     }
   D*=h(v.smoothness,v.metalness);
   if(i.water>.5&&isEyeInWater==0)
     D=mix(.02,D,.7);
   vec4 Q=texture2DLod(colortex1,texcoord.xy+HalfScreen,0);
   vec3 Z=pow(Q.xyz,vec3(2.2)),P=Z;
   P*=120.;
   if(isEyeInWater>0)
     UnderwaterFog(P,length(m.xyz),s,colorSkyUp,colorSunlight);
   vec3 g=P;
   P=mix(P,K.xyz*12.,vec3(saturate(D)));
   P+=g*v.metalness;
   {
     #ifdef GODRAYS
     #else
     if(isEyeInWater>0)
       #endif
     {
       float I=BlueNoiseTemporal(texcoord.xy).x,Y=120.;
       if(isEyeInWater>0)
         Y=20.;
       vec3 u=vec3(0.),X=(gbufferModelViewInverse*vec4(0.,0.,0.,1.)).xyz;
       for(int M=0;M<10;M++)
         {
           float E=float(M+I)/float(10);
           vec3 C=s.xyz*Y*E+X;
           if(length(m.xyz)<length(C-X))
             {
               break;
             }
           float j,N;
           vec3 O=WorldPosToShadowProjPos(C.xyz,j,N),W=shadow2DLod(shadowtex0,vec3(O.xy,O.z+1e-06),3).xxx;
           #ifdef GODRAYS_STAINED_GLASS_TINT
           float A=shadow2DLod(shadowtex0,vec3(O.xy-vec2(.5,0.),O.z-1e-06),3).x;
           vec3 ac=texture2DLod(shadowcolor,vec2(O.xy-vec2(.5,0.)),3).xyz;
           ac*=ac;
           W=mix(W,W*ac,vec3(1.-A));
           #endif
           if(isEyeInWater>0)
             {
               float ad=abs(texture2DLod(shadowcolor1,O.xy-vec2(0.,.5),4).x*256.-(C.y+cameraPosition.y)),ae=GetCausticsComposite(C,worldLightVector,ad),af=shadow2DLod(shadowtex0,vec3(O.xy-vec2(0.,.5),O.z+1e-06),4).x;
               W=mix(W,W*ae,vec3(1.-af));
               u+=W*exp(-GetWaterAbsorption()*(Y*E))*exp(-GetWaterAbsorption()*ad);
             }
           else
              u+=W*colorSunlight*.1;
         }
       float W=dot(worldLightVector,s.xyz),E=1.;
       if(isEyeInWater>0)
         W=dot(refract(worldLightVector,vec3(0.,-1.,0.),.750019),s.xyz);
       else
          E=.5/(max(0.,pow(worldLightVector.y,2.)*2.)+.4);
       float O=W*W,N=PhaseMie(.8,W,O);
       P+=TintUnderwaterDepth(u*colorSunlight*GetWaterFogColor()*.115*N*E*(1.-wetness));
     }
   }
   if(i.sky<.5&&isEyeInWater<1)
     LandAtmosphericScattering(P,f.xyz,r.xyz,s.xyz,worldSunVector.xyz,1.);
   P/=120.;
   P*=exp(-e*blindness);
   P=pow(P.xyz,vec3(.454545));
   gl_FragData[0]=vec4(P,Luminance(P));
 };





/* DRAWBUFFERS:1 */
