/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.EventHooks;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.constants.EntityType;
import noppes.npcs.scripted.constants.JobType;
import noppes.npcs.scripted.constants.RoleType;
import noppes.npcs.scripted.entity.ScriptNpc;
import noppes.npcs.scripted.event.ScriptEvent;
import noppes.npcs.scripted.interfaces.ICustomNpc;
import noppes.npcs.scripted.interfaces.IWorld;
import noppes.npcs.scripted.wrapper.WrapperNpcAPI;

public class DataScript
implements IScriptHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    private static final EntityType entities = new EntityType();
    private static final JobType jobs = new JobType();
    private static final RoleType roles = new RoleType();
    public String scriptLanguage = "ECMAScript";
    private EntityNPCInterface npc;
    public boolean enabled = false;
    public ICustomNpc dummyNpc;
    public IWorld dummyWorld;
    public boolean clientNeedsUpdate = false;
    public boolean aiNeedsUpdate = false;
    public boolean hasInited = false;

    public DataScript(EntityNPCInterface npc) {
        for (int i = 0; i < 12; ++i) {
            this.scripts.add(new ScriptContainer(this));
        }
        this.npc = npc;
        this.dummyNpc = new ScriptNpc<EntityNPCInterface>(npc);
        if (npc.field_70170_p instanceof WorldServer) {
            this.dummyWorld = NpcAPI.Instance().getIWorld((WorldServer)npc.field_70170_p);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = this.readScript(compound.func_150295_c("ScriptsContainers", 10));
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("ScriptsContainers", (NBTBase)this.writeScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    private List<ScriptContainer> readScript(NBTTagList list) {
        int i;
        ArrayList<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
        for (i = 0; i < 12; ++i) {
            scripts.add(new ScriptContainer(this));
        }
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compoundd = list.func_150305_b(i);
            ScriptContainer script = new ScriptContainer(this);
            script.readFromNBT(compoundd);
            if (!script.hasCode() && !this.npc.isRemote()) continue;
            scripts.set(compoundd.func_74762_e("Type"), script);
        }
        return scripts;
    }

    private NBTTagList writeScript(List<ScriptContainer> scripts) {
        NBTTagList list = new NBTTagList();
        for (int type = 0; type < scripts.size(); ++type) {
            NBTTagCompound compoundd = new NBTTagCompound();
            compoundd.func_74768_a("Type", type);
            ScriptContainer script = scripts.get(type);
            script.writeToNBT(compoundd);
            list.func_74742_a((NBTBase)compoundd);
        }
        return list;
    }

    public boolean callScript(EnumScriptType type, Object ... obs) {
        ScriptContainer script;
        if (this.aiNeedsUpdate) {
            this.npc.updateAI = true;
            this.aiNeedsUpdate = false;
        }
        if (this.clientNeedsUpdate) {
            this.npc.updateClient = true;
            this.clientNeedsUpdate = false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.hasInited) {
            this.hasInited = true;
            EventHooks.onNPCInit(this.npc);
            this.callScript(EnumScriptType.INIT, new Object[0]);
        }
        if ((script = this.scripts.get(type.ordinal())) == null || script.errored || !script.hasCode()) {
            return false;
        }
        script.setEngine(this.scriptLanguage);
        if (script.engine == null) {
            return false;
        }
        int i = 0;
        while (i + 1 < obs.length) {
            Object ob = obs[i + 1];
            if (ob instanceof Entity) {
                ob = ScriptController.Instance.getScriptForEntity((Entity)ob);
            }
            script.engine.put(obs[i].toString(), ob);
            i += 2;
        }
        return this.callScript(script);
    }

    private boolean callScript(ScriptContainer script) {
        ScriptEngine engine = script.engine;
        engine.put("npc", this.dummyNpc);
        engine.put("world", this.dummyWorld);
        ScriptEvent result = (ScriptEvent)engine.get("event");
        if (result == null) {
            result = new ScriptEvent();
            engine.put("event", result);
        }
        engine.put("API", new WrapperNpcAPI());
        engine.put("EntityType", entities);
        engine.put("RoleType", roles);
        engine.put("JobType", jobs);
        script.run(engine);
        if (this.clientNeedsUpdate) {
            this.npc.updateClient = true;
            this.clientNeedsUpdate = false;
        }
        if (this.aiNeedsUpdate) {
            this.npc.updateAI = true;
            this.aiNeedsUpdate = false;
        }
        return result.isCancelled();
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.npc.field_70170_p.field_72995_K && !this.scripts.isEmpty();
    }

    public void callScript(EnumScriptType var1, Event var2, Object ... obs) {
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                map.put(entry.getKey(), " tab " + tab + ":\n" + entry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public void callScript(EnumScriptType var1, Event var2) {
    }

    @Override
    public boolean isClient() {
        return this.npc.isRemote();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        return "";
    }

    public void setWorld(World world) {
        if (world instanceof WorldServer) {
            this.dummyWorld = new ScriptWorld((WorldServer)world);
        }
    }
}

