/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.Quest;

public class QuestLogData {
    public HashMap<String, Vector<String>> categories = new HashMap();
    public String selectedQuest = "";
    public String selectedCategory = "";
    public HashMap<String, String> questText = new HashMap();
    public HashMap<String, Vector<String>> questStatus = new HashMap();
    public HashMap<String, String> finish = new HashMap();

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Categories", (NBTBase)NBTTags.nbtVectorMap(this.categories));
        compound.func_74782_a("Logs", (NBTBase)NBTTags.nbtStringStringMap(this.questText));
        compound.func_74782_a("Status", (NBTBase)NBTTags.nbtVectorMap(this.questStatus));
        compound.func_74782_a("QuestFinisher", (NBTBase)NBTTags.nbtStringStringMap(this.finish));
        return compound;
    }

    public void readNBT(NBTTagCompound compound) {
        this.categories = NBTTags.getVectorMap(compound.func_150295_c("Categories", 10));
        this.questText = NBTTags.getStringStringMap(compound.func_150295_c("Logs", 10));
        this.questStatus = NBTTags.getVectorMap(compound.func_150295_c("Status", 10));
        this.finish = NBTTags.getStringStringMap(compound.func_150295_c("QuestFinisher", 10));
    }

    public void setData(EntityPlayer player) {
        PlayerData playerData = PlayerDataController.instance.getPlayerData(player);
        for (Quest quest : PlayerQuestController.getActiveQuests(player)) {
            String category = quest.category.title;
            if (!this.categories.containsKey(category)) {
                this.categories.put(category, new Vector());
            }
            Vector<String> list = this.categories.get(category);
            list.add(quest.title);
            this.questText.put(category + ":" + quest.title, quest.logText);
            this.questStatus.put(category + ":" + quest.title, quest.questInterface.getQuestLogStatus(player));
            if (quest.completion != EnumQuestCompletion.Npc || !quest.questInterface.isCompleted(playerData)) continue;
            this.finish.put(category + ":" + quest.title, quest.completerNpc);
        }
    }

    public boolean hasSelectedQuest() {
        return !this.selectedQuest.isEmpty();
    }

    public String getQuestText() {
        return this.questText.get(this.selectedCategory + ":" + this.selectedQuest);
    }

    public Vector<String> getQuestStatus() {
        return this.questStatus.get(this.selectedCategory + ":" + this.selectedQuest);
    }

    public String getComplete() {
        return this.finish.get(this.selectedCategory + ":" + this.selectedQuest);
    }
}

