/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerDataScript;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.event.PlayerEvent;

public class ScriptPlayerEventHandler {
    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            if (player.field_70173_aa % 10 == 0) {
                PlayerDataScript handler = ScriptController.Instance.playerScripts;
                ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)player);
                EventHooks.onPlayerTick(handler, scriptPlayer);
            }
            PlayerData playerData = PlayerDataController.instance.getPlayerData(player);
            if (PlayerDataController.instance != null && playerData.timers.size() > 0) {
                playerData.timers.update();
            }
            if (player.field_70173_aa % (20 * CustomNpcs.PlayerQuestCheck) == 0) {
                PlayerQuestData questData = playerData.questData;
                for (EnumQuestType e : EnumQuestType.values()) {
                    questData.checkQuestCompletion(playerData, e);
                }
            }
        }
    }

    @SubscribeEvent
    public void invoke(EntityInteractEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(scriptPlayer, 1, NpcAPI.Instance().getIEntity(event.target));
            event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        }
    }

    @SubscribeEvent
    public void invoke(ArrowNockEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            PlayerEvent.RangedChargeEvent ev = new PlayerEvent.RangedChargeEvent(scriptPlayer);
            EventHooks.onPlayerBowCharge(handler, ev);
        }
    }

    @SubscribeEvent
    public void invoke(ArrowLooseEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            PlayerEvent.RangedLaunchedEvent ev = new PlayerEvent.RangedLaunchedEvent(scriptPlayer, event.bow, event.charge);
            EventHooks.onPlayerRanged(handler, ev);
        }
    }

    @SubscribeEvent
    public void invoke(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || event.getPlayer().field_70170_p == null) {
            return;
        }
        if (!event.getPlayer().field_70170_p.field_72995_K && event.world instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.getPlayer());
            PlayerEvent.BreakEvent ev = new PlayerEvent.BreakEvent(scriptPlayer, NpcAPI.Instance().getIBlock(event.world, new BlockPos(event.x, event.y, event.z)), event.getExpToDrop());
            event.setCanceled(EventHooks.onPlayerBreak(handler, ev));
            event.setExpToDrop(ev.exp);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Start event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onStartUsingItem(handler, scriptPlayer, event.duration, event.item));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Tick event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onUsingItem(handler, scriptPlayer, event.duration, event.item));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Stop event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onStopUsingItem(handler, scriptPlayer, event.duration, event.item));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerUseItemEvent.Finish event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onFinishUsingItem(handler, scriptPlayer, event.duration, event.item);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerDropsEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            event.setCanceled(EventHooks.onPlayerDropItems(handler, scriptPlayer, event.drops));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerPickupXpEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerPickupXP(handler, scriptPlayer, event.orb);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            EventHooks.onPlayerChangeDim(handler, scriptPlayer, event.fromDim, event.toDim);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.ItemPickupEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            EventHooks.onPlayerPickUp(handler, scriptPlayer, event.pickedUp);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerOpenContainerEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer && !(event.entityPlayer.field_71070_bA instanceof ContainerPlayer)) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerContainerOpen(handler, scriptPlayer, event.entityPlayer.field_71070_bA);
        }
    }

    @SubscribeEvent
    public void invoke(UseHoeEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerUseHoe(handler, scriptPlayer, event.current, event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerSleepInBedEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerSleep(handler, scriptPlayer, event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerWakeUpEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerWakeUp(handler, scriptPlayer, event.setSpawn);
        }
    }

    @SubscribeEvent
    public void invoke(FillBucketEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerFillBucket(handler, scriptPlayer, event.current, event.result);
        }
    }

    @SubscribeEvent
    public void invoke(BonemealEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerBonemeal(handler, scriptPlayer, event.x, event.y, event.z, event.world);
        }
    }

    @SubscribeEvent
    public void invoke(AchievementEvent event) {
        if (event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityPlayer);
            EventHooks.onPlayerAchievement(handler, scriptPlayer, CustomNpcs.proxy.getAchievementDesc(event.achievement));
        }
    }

    @SubscribeEvent
    public void invoke(ItemTossEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            EventHooks.onPlayerToss(handler, scriptPlayer, event.entityItem);
        }
    }

    @SubscribeEvent
    public void invoke(LivingFallEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p == null) {
            return;
        }
        if (event.entityLiving.field_70170_p instanceof WorldServer && event.entityLiving instanceof EntityPlayer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityLiving);
            EventHooks.onPlayerFall(handler, scriptPlayer, event.distance);
        }
    }

    @SubscribeEvent
    public void invoke(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p == null) {
            return;
        }
        if (event.entityLiving.field_70170_p instanceof WorldServer && event.entityLiving instanceof EntityPlayer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityLiving);
            EventHooks.onPlayerJump(handler, scriptPlayer);
        }
    }

    @SubscribeEvent
    public void invoke(EntityStruckByLightningEvent event) {
        if (event.entity == null || event.entity.field_70170_p == null) {
            return;
        }
        if (event.entity.field_70170_p instanceof WorldServer && event.entity instanceof EntityPlayer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity(event.entity);
            EventHooks.onPlayerLightning(handler, scriptPlayer);
        }
    }

    @SubscribeEvent
    public void invoke(PlaySoundAtEntityEvent event) {
        if (event.entity == null || event.entity.field_70170_p == null) {
            return;
        }
        if (event.entity.field_70170_p instanceof WorldServer && event.entity instanceof EntityPlayer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity(event.entity);
            EventHooks.onPlayerSound(handler, scriptPlayer, event.name, event.pitch, event.volume);
        }
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p == null) {
            return;
        }
        if (event.entityLiving.field_70170_p instanceof WorldServer) {
            ScriptPlayer scriptPlayer;
            Entity source = NoppesUtilServer.GetDamageSourcee(event.source);
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            if (event.entityLiving instanceof EntityPlayer) {
                scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.entityLiving);
                EventHooks.onPlayerDeath(handler, scriptPlayer, event.source, source);
            }
            if (source instanceof EntityPlayer) {
                scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity(event.source.func_76346_g());
                EventHooks.onPlayerKills(handler, scriptPlayer, event.entityLiving);
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingHurtEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p == null) {
            return;
        }
        if (event.entityLiving.field_70170_p instanceof WorldServer) {
            Entity source = NoppesUtilServer.GetDamageSourcee(event.source);
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            if (event.entityLiving instanceof EntityPlayer) {
                PlayerEvent.DamagedEvent pevent = new PlayerEvent.DamagedEvent((ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)((EntityPlayer)event.entityLiving)), source, event.ammount, event.source);
                event.setCanceled(EventHooks.onPlayerDamaged(handler, pevent));
                event.ammount = pevent.damage;
            }
            if (source instanceof EntityPlayer) {
                PlayerEvent.DamagedEntityEvent pevent1 = new PlayerEvent.DamagedEntityEvent((ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)((EntityPlayer)event.source.func_76346_g())), (Entity)event.entityLiving, event.ammount, event.source);
                event.setCanceled(EventHooks.onPlayerDamagedEntity(handler, pevent1));
                event.ammount = pevent1.damage;
            }
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            EventHooks.onPlayerRespawn(handler, scriptPlayer);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            EventHooks.onPlayerLogin(handler, scriptPlayer);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            EventHooks.onPlayerLogout(handler, scriptPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void invoke(ServerChatEvent event) {
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p instanceof WorldServer && !event.player.equals((Object)EntityNPCInterface.chateventPlayer)) {
            PlayerDataScript handler = ScriptController.Instance.playerScripts;
            ScriptPlayer scriptPlayer = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)event.player);
            String message = event.message;
            PlayerEvent.ChatEvent ev = new PlayerEvent.ChatEvent(scriptPlayer, event.message);
            EventHooks.onPlayerChat(handler, ev);
            event.setCanceled(ev.isCanceled());
            if (!message.equals(ev.message)) {
                ChatComponentTranslation chat = new ChatComponentTranslation("", new Object[0]);
                chat.func_150257_a(ForgeHooks.newChatWithLinks((String)ev.message));
                event.component = chat;
            }
        }
    }
}

