/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.pathfinder;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.ai.pathfinder.NPCPathFinder;
import noppes.npcs.ai.pathfinder.PathNavigateNPC;
import noppes.npcs.ai.pathfinder.WalkNodeProcessor;
import noppes.npcs.util.Vec3NPC;

public class PathNavigateGround
extends PathNavigateNPC {
    protected WalkNodeProcessor nodeProcessor;
    private boolean shouldAvoidSun;

    public PathNavigateGround(EntityLiving entitylivingIn, World worldIn) {
        super(entitylivingIn, worldIn);
    }

    protected PathFinder getPathFinder() {
        this.nodeProcessor = new WalkNodeProcessor();
        this.nodeProcessor.setEnterDoors(true);
        return new NPCPathFinder(this.nodeProcessor);
    }

    protected boolean func_75485_k() {
        return this.field_75515_a.field_70122_E || this.getCanSwim() && this.func_75506_l() || this.field_75515_a.func_70115_ae() && this.field_75515_a instanceof EntityZombie && this.field_75515_a.field_70154_o instanceof EntityChicken;
    }

    protected Vec3 func_75502_i() {
        return new Vec3NPC(this.field_75515_a.field_70165_t, this.getPathablePosY(), this.field_75515_a.field_70161_v);
    }

    private int getPathablePosY() {
        if (this.field_75515_a.func_70090_H() && this.getCanSwim()) {
            int i = (int)this.field_75515_a.field_70121_D.field_72338_b;
            Block block = this.field_75513_b.func_147439_a(MathHelper.func_76128_c((double)this.field_75515_a.field_70165_t), i, MathHelper.func_76128_c((double)this.field_75515_a.field_70161_v));
            int j = 0;
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                block = this.field_75513_b.func_147439_a(MathHelper.func_76128_c((double)this.field_75515_a.field_70165_t), ++i, MathHelper.func_76128_c((double)this.field_75515_a.field_70161_v));
                if (++j <= 16) continue;
                return (int)this.field_75515_a.field_70121_D.field_72338_b;
            }
            return i;
        }
        return (int)(this.field_75515_a.field_70121_D.field_72338_b + 0.5);
    }

    @Override
    protected void func_75487_m() {
        super.func_75487_m();
        if (this.shouldAvoidSun) {
            if (this.field_75513_b.func_72937_j(MathHelper.func_76128_c((double)this.field_75515_a.field_70165_t), (int)(this.field_75515_a.field_70121_D.field_72338_b + 0.5), MathHelper.func_76128_c((double)this.field_75515_a.field_70161_v))) {
                return;
            }
            for (int i = 0; i < this.field_75514_c.func_75874_d(); ++i) {
                PathPoint pathpoint = this.field_75514_c.func_75877_a(i);
                if (!this.field_75513_b.func_72937_j(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c)) continue;
                this.field_75514_c.func_75871_b(i - 1);
                return;
            }
        }
    }

    protected boolean func_75493_a(Vec3 posVec31, Vec3 posVec32, int sizeX, int sizeY, int sizeZ) {
        int i = MathHelper.func_76128_c((double)posVec31.field_72450_a);
        int j = MathHelper.func_76128_c((double)posVec31.field_72449_c);
        double d0 = posVec32.field_72450_a - posVec31.field_72450_a;
        double d1 = posVec32.field_72449_c - posVec31.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(i, (int)posVec31.field_72448_b, j, sizeX += 2, sizeY, sizeZ += 2, posVec31, d0 *= d3, d1 *= d3)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(i * 1) - posVec31.field_72450_a;
        double d7 = (double)(j * 1) - posVec31.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int k = d0 < 0.0 ? -1 : 1;
        int l = d1 < 0.0 ? -1 : 1;
        int i1 = MathHelper.func_76128_c((double)posVec32.field_72450_a);
        int j1 = MathHelper.func_76128_c((double)posVec32.field_72449_c);
        int k1 = i1 - i;
        int l1 = j1 - j;
        while (k1 * k > 0 || l1 * l > 0) {
            if (d6 < d7) {
                d6 += d4;
                k1 = i1 - (i += k);
            } else {
                d7 += d5;
                l1 = j1 - (j += l);
            }
            if (this.isSafeToStandAt(i, (int)posVec31.field_72448_b, j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 vec31, double p_179683_8_, double p_179683_10_) {
        int i = x - sizeX / 2;
        int j = z - sizeZ / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, vec31, p_179683_8_, p_179683_10_)) {
            return false;
        }
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - vec31.field_72450_a;
                double d1 = (double)l + 0.5 - vec31.field_72449_c;
                if (!(d0 * p_179683_8_ + d1 * p_179683_10_ >= 0.0)) continue;
                Block block = this.field_75513_b.func_147439_a(k, y - 1, l);
                Material material = block.func_149688_o();
                if (material == Material.field_151579_a) {
                    return false;
                }
                if (material == Material.field_151586_h && !this.field_75515_a.func_70090_H()) {
                    return false;
                }
                if (material != Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int p_179692_1_, int p_179692_2_, int p_179692_3_, int p_179692_4_, int p_179692_5_, int p_179692_6_, Vec3 p_179692_7_, double p_179692_8_, double p_179692_10_) {
        for (BlockPos blockpos : BlockPos.getAllInBox(new BlockPos(p_179692_1_, p_179692_2_, p_179692_3_), new BlockPos(p_179692_1_ + p_179692_4_ - 1, p_179692_2_ + p_179692_5_ - 1, p_179692_3_ + p_179692_6_ - 1))) {
            Block block;
            double d1;
            double d0 = (double)blockpos.getX() + 0.5 - p_179692_7_.field_72450_a;
            if (!(d0 * p_179692_8_ + (d1 = (double)blockpos.getZ() + 0.5 - p_179692_7_.field_72449_c) * p_179692_10_ >= 0.0) || (block = this.field_75513_b.func_147439_a(blockpos.getX(), blockpos.getY(), blockpos.getZ())).func_149655_b((IBlockAccess)this.field_75513_b, blockpos.getX(), blockpos.getY(), blockpos.getZ())) continue;
            return false;
        }
        return true;
    }

    public void func_75491_a(boolean avoidsWater) {
        this.nodeProcessor.setAvoidsWater(avoidsWater);
    }

    public boolean func_75486_a() {
        return this.nodeProcessor.getAvoidsWater();
    }

    public void func_75498_b(boolean canBreakDoors) {
        this.nodeProcessor.setBreakDoors(canBreakDoors);
    }

    public void func_75490_c(boolean par1) {
        this.nodeProcessor.setEnterDoors(par1);
    }

    public boolean getEnterDoors() {
        return this.nodeProcessor.getEnterDoors();
    }

    public void func_75495_e(boolean canSwim) {
        this.nodeProcessor.setCanSwim(canSwim);
    }

    public boolean getCanSwim() {
        return this.nodeProcessor.getCanSwim();
    }

    public void func_75504_d(boolean par1) {
        this.shouldAvoidSun = par1;
    }
}

