/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.ImageDownloadAlt;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IClickListener;
import noppes.npcs.client.renderer.ImageBufferDownloadAlt;
import noppes.npcs.scripted.gui.ScriptGuiButton;
import noppes.npcs.scripted.interfaces.ICustomGuiComponent;
import org.lwjgl.opengl.GL11;

public class CustomGuiButton
extends GuiButton
implements IClickListener {
    GuiCustom parent;
    ResourceLocation texture;
    public int textureX;
    public int textureY;
    boolean field_146123_n;
    String label;
    String[] hoverText;
    int color;
    float alpha;

    public CustomGuiButton(int id, String buttonText, int x, int y) {
        super(id, GuiCustom.guiLeft + x, GuiCustom.guiTop + y, buttonText);
    }

    public CustomGuiButton(int id, String buttonText, int x, int y, int width, int height) {
        super(id, GuiCustom.guiLeft + x, GuiCustom.guiTop + y, width, height, buttonText);
    }

    public CustomGuiButton(int buttonId, String buttonText, int x, int y, int width, int height, String texture) {
        this(buttonId, buttonText, x, y, width, height, texture, 0, 0);
    }

    public CustomGuiButton(int buttonId, String buttonText, int x, int y, int width, int height, String texture, int textureX, int textureY) {
        this(buttonId, buttonText, x, y, width, height);
        this.textureX = textureX;
        this.textureY = textureY;
        this.label = buttonText;
        this.texture = new ResourceLocation(texture);
        if (texture.startsWith("https://")) {
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            ImageDownloadAlt object = new ImageDownloadAlt(null, texture, SkinManager.field_152793_a, (IImageBuffer)new ImageBufferDownloadAlt(false));
            texturemanager.func_110579_a(this.texture, (ITextureObject)object);
        }
    }

    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    public static CustomGuiButton fromComponent(ScriptGuiButton component) {
        CustomGuiButton btn = component.hasTexture() ? (component.getTextureX() >= 0 && component.getTextureY() >= 0 ? new CustomGuiButton(component.getID(), component.getLabel(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), component.getTexture(), component.getTextureX(), component.getTextureY()) : new CustomGuiButton(component.getID(), component.getLabel(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), component.getTexture())) : (component.getWidth() >= 0 && component.getHeight() >= 0 ? new CustomGuiButton(component.getID(), component.getLabel(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight()) : new CustomGuiButton(component.getID(), component.getLabel(), component.getPosX(), component.getPosY()));
        btn.color = component.getColor();
        btn.alpha = component.getAlpha();
        if (component.hasHoverText()) {
            btn.hoverText = component.getHoverText();
        }
        return btn;
    }

    @Override
    public int getID() {
        return this.field_146127_k;
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        GL11.glPushMatrix();
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)this.alpha);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.field_146127_k);
        FontRenderer fontRenderer = mc.field_71466_p;
        if (this.texture == null) {
            mc.func_110434_K().func_110577_a(field_146122_a);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.func_146114_a(this.field_146123_n);
            GL11.glBlendFunc((int)770, (int)771);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_146119_b(mc, mouseX, mouseY);
            int j = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                j = this.packedFGColour;
            } else if (!this.field_146124_l) {
                j = 0xA0A0A0;
            } else if (this.field_146123_n) {
                j = 0xFFFFA0;
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.1);
            this.func_73732_a(fontRenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
        } else {
            mc.func_110434_K().func_110577_a(this.texture);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.hoverState(this.field_146123_n);
            GL11.glBlendFunc((int)770, (int)771);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, this.textureX, this.textureY + i * this.field_146121_g, this.field_146120_f, this.field_146121_g);
            this.func_73732_a(fontRenderer, this.label, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, this.color);
            if (this.field_146123_n && this.hoverText != null && this.hoverText.length > 0) {
                this.parent.hoverText = this.hoverText;
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public ICustomGuiComponent toComponent() {
        ScriptGuiButton component = new ScriptGuiButton(this.field_146127_k, this.label, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, this.texture.toString(), this.textureX, this.textureY);
        component.setHoverText(this.hoverText);
        component.setColor(this.color);
        component.setAlpha(this.alpha);
        return component;
    }

    protected int hoverState(boolean mouseOver) {
        int i = 0;
        if (mouseOver) {
            i = 1;
        }
        return i;
    }

    @Override
    public boolean mouseClicked(GuiCustom gui, int mouseX, int mouseY, int mouseButton) {
        if (mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g) {
            gui.buttonClick(this);
            return true;
        }
        return false;
    }
}

