/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import cpw.mods.fml.common.eventhandler.Event;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.event.CustomGuiEvent;
import noppes.npcs.scripted.gui.ScriptGui;
import noppes.npcs.scripted.interfaces.IItemStack;
import noppes.npcs.scripted.overlay.ScriptOverlay;
import noppes.npcs.scripted.wrapper.WrapperNpcAPI;

public class CustomGuiController {
    public static void openGui(ScriptPlayer player, ScriptGui gui) {
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player.getMCEntity();
        entityPlayerMP.openGui((Object)CustomNpcs.instance, EnumGuiType.CustomGui.ordinal(), (World)player.getWorld().getMCWorld(), gui.getSlots().size(), 0, 0);
        ((ContainerCustomGui)((EntityPlayerMP)player.getMCEntity()).field_71070_bA).setGui(gui, (EntityPlayer)player.getMCEntity());
        Server.sendData((EntityPlayerMP)player.getMCEntity(), EnumPacketClient.GUI_DATA, gui.toNBT());
    }

    public static boolean updateGui(ScriptPlayer player, ScriptGui gui) {
        if (((EntityPlayerMP)player.getMCEntity()).field_71070_bA instanceof ContainerCustomGui) {
            Server.sendData((EntityPlayerMP)player.getMCEntity(), EnumPacketClient.GUI_DATA, gui.toNBT());
            return true;
        }
        return false;
    }

    public static void openOverlay(ScriptPlayer player, ScriptOverlay gui) {
        Server.sendData((EntityPlayerMP)player.getMCEntity(), EnumPacketClient.OVERLAY_DATA, gui.toNBT());
    }

    public static boolean updateOverlay(ScriptPlayer player, ScriptOverlay gui) {
        Server.sendData((EntityPlayerMP)player.getMCEntity(), EnumPacketClient.OVERLAY_DATA, gui.toNBT());
        return true;
    }

    static boolean checkGui(CustomGuiEvent event) {
        EntityPlayer player = (EntityPlayer)event.player.getMCEntity();
        if (!(player.field_71070_bA instanceof ContainerCustomGui)) {
            return false;
        }
        return ((ContainerCustomGui)player.field_71070_bA).customGui.getID() == event.gui.getID();
    }

    public static IItemStack[] getSlotContents(EntityPlayer player) {
        IItemStack[] slotContents = new IItemStack[]{};
        if (player.field_71070_bA instanceof ContainerCustomGui) {
            ContainerCustomGui container = (ContainerCustomGui)player.field_71070_bA;
            slotContents = new IItemStack[container.guiInventory.func_70302_i_()];
            for (int i = 0; i < container.guiInventory.func_70302_i_(); ++i) {
                slotContents[i] = NpcAPI.Instance().getIItemStack(container.guiInventory.func_70301_a(i));
            }
        }
        return slotContents;
    }

    public static void onButton(CustomGuiEvent.ButtonEvent event) {
        EntityPlayer player = (EntityPlayer)event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().callScript(EnumScriptType.CUSTOM_GUI_BUTTON, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onSlotChange(CustomGuiEvent.SlotEvent event) {
        EntityPlayer player = (EntityPlayer)event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().callScript(EnumScriptType.CUSTOM_GUI_SLOT, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onCustomGuiUnfocused(CustomGuiEvent.UnfocusedEvent event) {
        EntityPlayer player = (EntityPlayer)event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().callScript(EnumScriptType.CUSTOM_GUI_TEXTFIELD, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onScrollClick(CustomGuiEvent.ScrollEvent event) {
        EntityPlayer player = (EntityPlayer)event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().callScript(EnumScriptType.CUSTOM_GUI_SCROLL, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onClose(CustomGuiEvent.CloseEvent event) {
        if (ScriptController.Instance.playerScripts != null) {
            ScriptController.Instance.playerScripts.callScript(EnumScriptType.CUSTOM_GUI_CLOSED, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static ScriptGui getOpenGui(EntityPlayer player) {
        return player.field_71070_bA instanceof ContainerCustomGui ? ((ContainerCustomGui)player.field_71070_bA).customGui : null;
    }

    public static String[] readScrollSelection(ByteBuf buffer) {
        try {
            NBTTagList list = Server.readNBT(buffer).func_150295_c("selection", 8);
            String[] selection = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                selection[i] = list.func_150307_f(i);
            }
            return selection;
        }
        catch (IOException var4) {
            var4.printStackTrace();
            return null;
        }
    }
}

