/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.world.WorldEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.ScriptEntityData;
import noppes.npcs.controllers.data.ForgeDataScript;
import noppes.npcs.controllers.data.NPCDataScript;
import noppes.npcs.controllers.data.PlayerDataScript;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.entity.ScriptAnimal;
import noppes.npcs.scripted.entity.ScriptEntity;
import noppes.npcs.scripted.entity.ScriptLiving;
import noppes.npcs.scripted.entity.ScriptLivingBase;
import noppes.npcs.scripted.entity.ScriptMonster;
import noppes.npcs.scripted.entity.ScriptNpc;
import noppes.npcs.scripted.entity.ScriptPixelmon;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.util.JsonException;
import noppes.npcs.util.NBTJsonUtil;

public class ScriptController {
    public static ScriptController Instance;
    public static boolean HasStart;
    private ScriptEngineManager manager;
    public Map<String, String> languages = new HashMap<String, String>();
    public Map<String, String> scripts = new HashMap<String, String>();
    public long lastLoaded = 0L;
    public File dir;
    public NBTTagCompound compound = new NBTTagCompound();
    private boolean loaded = false;
    public boolean shouldSave = false;
    public PlayerDataScript playerScripts = new PlayerDataScript(null);
    public long lastPlayerUpdate = 0L;
    public ForgeDataScript forgeScripts = new ForgeDataScript();
    public NPCDataScript npcScripts = new NPCDataScript(null);

    public ScriptController() {
        Instance = this;
        this.manager = new ScriptEngineManager();
        LogWriter.info("Script Engines Available:");
        for (ScriptEngineFactory fac : this.manager.getEngineFactories()) {
            if (fac.getExtensions().isEmpty()) continue;
            fac.getScriptEngine();
            String ext = "." + fac.getExtensions().get(0).toLowerCase();
            LogWriter.info(fac.getLanguageName() + ": " + ext);
            this.languages.put(fac.getLanguageName(), ext);
        }
    }

    private File forgeScriptsFile() {
        return new File(this.dir, "forge_scripts.json");
    }

    public boolean loadForgeScripts() {
        this.forgeScripts.clear();
        File file = this.forgeScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.forgeScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
            return true;
        }
        catch (Exception var3) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), var3);
            return false;
        }
    }

    public void setForgeScripts(NBTTagCompound compound) {
        this.forgeScripts.readFromNBT(compound);
        File file = this.forgeScriptsFile();
        try {
            NBTJsonUtil.SaveFile(file, compound);
            this.forgeScripts.lastInited = -1L;
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        catch (JsonException var5) {
            var5.printStackTrace();
        }
    }

    private File playerScriptsFile() {
        return new File(this.dir, "player_scripts.json");
    }

    private File npcScriptsFile() {
        return new File(this.dir, "npc_scripts.json");
    }

    public boolean loadPlayerScripts() {
        this.playerScripts.clear();
        File file = this.playerScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.playerScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
            this.shouldSave = false;
            return true;
        }
        catch (Exception var3) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), var3);
            return false;
        }
    }

    public void setPlayerScripts(NBTTagCompound compound) {
        this.playerScripts.readFromNBT(compound);
        File file = this.playerScriptsFile();
        try {
            NBTJsonUtil.SaveFile(file, compound);
            this.lastPlayerUpdate = System.currentTimeMillis();
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        catch (JsonException var5) {
            var5.printStackTrace();
        }
    }

    public boolean loadNPCScripts() {
        this.npcScripts.clear();
        File file = this.npcScriptsFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.npcScripts.readFromNBT(NBTJsonUtil.LoadFile(file));
            this.shouldSave = false;
            return true;
        }
        catch (Exception var3) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), var3);
            return false;
        }
    }

    public void setNPCScripts(NBTTagCompound compound) {
        this.npcScripts.readFromNBT(compound);
        File file = this.npcScriptsFile();
        try {
            NBTJsonUtil.SaveFile(file, compound);
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        catch (JsonException var5) {
            var5.printStackTrace();
        }
    }

    private void loadCategories() {
        this.dir = new File(CustomNpcs.getWorldSaveDirectory(), "scripts");
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.getSavedFile().exists()) {
            this.shouldSave = true;
        }
        new ScriptWorld(null).clearTempData();
        this.scripts.clear();
        for (String language : this.languages.keySet()) {
            String ext = this.languages.get(language);
            File scriptDir = new File(this.dir, language.toLowerCase());
            if (!scriptDir.exists()) {
                scriptDir.mkdir();
                continue;
            }
            this.loadDir(scriptDir, "", ext);
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    private void loadDir(File dir, String name, String ext) {
        for (File file : dir.listFiles()) {
            String filename = name + file.getName().toLowerCase();
            if (file.isDirectory()) {
                this.loadDir(file, filename + "/", ext);
                continue;
            }
            if (!filename.endsWith(ext)) continue;
            try {
                this.scripts.put(filename, this.readFile(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean loadStoredData() {
        this.loadCategories();
        File file = this.getSavedFile();
        try {
            if (!file.exists()) {
                return false;
            }
            this.compound = NBTJsonUtil.LoadFile(file);
            this.shouldSave = false;
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    private File getSavedFile() {
        return new File(this.dir, "world_data.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    public ScriptEngine getEngineByName(String language) {
        return this.manager.getEngineByName(language);
    }

    public NBTTagList nbtLanguages() {
        NBTTagList list = new NBTTagList();
        for (String language : this.languages.keySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList scripts = new NBTTagList();
            for (String script : this.getScripts(language)) {
                scripts.func_74742_a((NBTBase)new NBTTagString(script));
            }
            compound.func_74782_a("Scripts", (NBTBase)scripts);
            compound.func_74778_a("Language", language);
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    private List<String> getScripts(String language) {
        ArrayList<String> list = new ArrayList<String>();
        String ext = this.languages.get(language);
        if (ext == null) {
            return list;
        }
        for (String script : this.scripts.keySet()) {
            if (!script.endsWith(ext)) continue;
            list.add(script);
        }
        return list;
    }

    public ScriptEntity getScriptForEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return (ScriptNpc)((EntityNPCInterface)entity).script.dummyNpc;
        }
        ScriptEntityData data = (ScriptEntityData)entity.getExtendedProperties("ScriptedObject");
        if (data != null) {
            return data.base;
        }
        if (entity instanceof EntityPlayerMP) {
            data = new ScriptEntityData(new ScriptPlayer<EntityPlayerMP>((EntityPlayerMP)entity));
        } else {
            if (PixelmonHelper.isPixelmon(entity)) {
                return new ScriptPixelmon<EntityTameable>((EntityTameable)entity);
            }
            data = entity instanceof EntityAnimal ? new ScriptEntityData(new ScriptAnimal<EntityAnimal>((EntityAnimal)entity)) : (entity instanceof EntityMob ? new ScriptEntityData(new ScriptMonster<EntityMob>((EntityMob)entity)) : (entity instanceof EntityLiving ? new ScriptEntityData(new ScriptLiving<EntityLiving>((EntityLiving)entity)) : (entity instanceof EntityLivingBase ? new ScriptEntityData(new ScriptLivingBase<EntityLivingBase>((EntityLivingBase)entity)) : new ScriptEntityData(new ScriptEntity<Entity>(entity)))));
        }
        entity.registerExtendedProperties("ScriptedObject", (IExtendedEntityProperties)data);
        return data.base;
    }

    @SubscribeEvent
    public void saveWorld(WorldEvent.Save event) {
        if (!this.shouldSave || event.world.field_72995_K || event.world != MinecraftServer.func_71276_C().field_71305_c[0]) {
            return;
        }
        try {
            NBTJsonUtil.SaveFile(this.getSavedFile(), this.compound);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        this.shouldSave = false;
    }

    static {
        HasStart = false;
    }
}

