/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.handler.data.IQuestItem;
import noppes.npcs.scripted.handler.data.IQuestObjective;
import noppes.npcs.util.ValueUtil;

public class QuestItem
extends QuestInterface
implements IQuestItem {
    public NpcMiscInventory items = new NpcMiscInventory(3);
    public boolean leaveItems = false;
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.items.setFromNBT(compound.func_74775_l("Items"));
        this.leaveItems = compound.func_74767_n("LeaveItems");
        this.ignoreDamage = compound.func_74767_n("IgnoreDamage");
        this.ignoreNBT = compound.func_74767_n("IgnoreNBT");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Items", (NBTBase)this.items.getToNBT());
        compound.func_74757_a("LeaveItems", this.leaveItems);
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
    }

    @Override
    public boolean isCompleted(PlayerData playerData) {
        HashMap<Integer, ItemStack> map = this.getProcessSet(playerData.player);
        for (ItemStack reqItem : this.items.items.values()) {
            boolean done = false;
            for (ItemStack item : map.values()) {
                if (!NoppesUtilPlayer.compareItems(reqItem, item, this.ignoreDamage, this.ignoreNBT) || item.field_77994_a < reqItem.field_77994_a) continue;
                done = true;
                break;
            }
            if (done) continue;
            return false;
        }
        return true;
    }

    public HashMap<Integer, ItemStack> getProcessSet(EntityPlayer player) {
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        ItemStack[] itemStackArray = this.items.items.keySet().iterator();
        while (itemStackArray.hasNext()) {
            int slot = itemStackArray.next();
            ItemStack item = this.items.items.get(slot);
            if (item == null) continue;
            ItemStack is = item.func_77946_l();
            is.field_77994_a = 0;
            map.put(slot, is);
        }
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null) continue;
            for (ItemStack questItem : map.values()) {
                if (!NoppesUtilPlayer.compareItems(questItem, item, this.ignoreDamage, this.ignoreNBT)) continue;
                questItem.field_77994_a += item.field_77994_a;
            }
        }
        return map;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
        if (this.leaveItems) {
            return;
        }
        block0: for (ItemStack questitem : this.items.items.values()) {
            int stacksize = questitem.field_77994_a;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack item = player.field_71071_by.field_70462_a[i];
                if (item == null || !NoppesUtilPlayer.compareItems(item, questitem, this.ignoreDamage, this.ignoreNBT)) continue;
                int size = item.field_77994_a;
                if (stacksize - size >= 0) {
                    player.field_71071_by.func_70299_a(i, null);
                    item.func_77979_a(size);
                } else {
                    item.func_77979_a(stacksize);
                }
                if ((stacksize -= size) <= 0) continue block0;
            }
        }
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        HashMap<Integer, ItemStack> map = this.getProcessSet(player);
        for (int slot : map.keySet()) {
            ItemStack item = map.get(slot);
            ItemStack quest = this.items.items.get(slot);
            if (item == null) continue;
            String process = item.field_77994_a + "";
            if (item.field_77994_a > quest.field_77994_a) {
                process = quest.field_77994_a + "";
            }
            process = process + "/" + quest.field_77994_a + "";
            if (item.func_82837_s()) {
                vec.add(item.func_82833_r() + ": " + process);
                continue;
            }
            vec.add(item.func_77977_a() + ".name: " + process);
        }
        return vec;
    }

    @Override
    public IQuestObjective[] getObjectives(EntityPlayer player) {
        ArrayList<QuestItemObjective> list = new ArrayList<QuestItemObjective>();
        List<ItemStack> questItems = NoppesUtilPlayer.countStacks(this.items, this.ignoreDamage, this.ignoreNBT);
        for (ItemStack stack : questItems) {
            if (stack.field_77994_a <= 0) continue;
            list.add(new QuestItemObjective(this, player, stack));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    @Override
    public void setLeaveItems(boolean leaveItems) {
        this.leaveItems = leaveItems;
    }

    @Override
    public boolean getLeaveItems() {
        return this.leaveItems;
    }

    @Override
    public void setIgnoreDamage(boolean ignoreDamage) {
        this.ignoreDamage = ignoreDamage;
    }

    @Override
    public boolean getIgnoreDamage() {
        return this.ignoreDamage;
    }

    @Override
    public void setIgnoreNbt(boolean ignoreNbt) {
        this.ignoreNBT = ignoreNbt;
    }

    @Override
    public boolean getIgnoreNbt() {
        return this.ignoreNBT;
    }

    class QuestItemObjective
    implements IQuestObjective {
        private final QuestItem parent;
        private final EntityPlayer player;
        private final ItemStack questItem;

        public QuestItemObjective(QuestItem this$02, EntityPlayer player, ItemStack item) {
            this.parent = this$02;
            this.player = player;
            this.questItem = item;
        }

        @Override
        public int getProgress() {
            int count = 0;
            for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = this.player.field_71071_by.func_70301_a(i);
                if (NoppesUtilServer.IsItemStackNull(item) || !NoppesUtilPlayer.compareItems(this.questItem, item, this.parent.ignoreDamage, this.parent.ignoreNBT)) continue;
                count += item.field_77994_a;
            }
            return ValueUtil.CorrectInt(count, 0, this.questItem.field_77994_a);
        }

        @Override
        public void setProgress(int progress) {
            throw new CustomNPCsException("Cant set the progress of ItemQuests", new Object[0]);
        }

        @Override
        public int getMaxProgress() {
            return this.questItem.field_77994_a;
        }

        @Override
        public boolean isCompleted() {
            return NoppesUtilPlayer.compareItems(this.player, this.questItem, this.parent.ignoreDamage, this.parent.ignoreNBT);
        }

        @Override
        public String getText() {
            return this.questItem.func_82833_r() + ": " + this.getProgress() + "/" + this.getMaxProgress();
        }
    }
}

