/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.handler.data.IQuestKill;
import noppes.npcs.scripted.handler.data.IQuestObjective;

public class QuestKill
extends QuestInterface
implements IQuestKill {
    public HashMap<String, Integer> targets = new HashMap();
    public int targetType = 0;
    public String customTargetType = "noppes.npcs.entity.EntityCustomNpc";

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("QuestKills", (NBTBase)NBTTags.nbtStringIntegerMap(this.targets));
        compound.func_74768_a("TargetType", this.targetType);
        compound.func_74778_a("CustomTargetType", this.customTargetType);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b("QuestKills")) {
            this.targets.clear();
            HashMap<String, Integer> oldTargets = NBTTags.getStringIntegerMap(compound.func_150295_c("QuestDialogs", 10));
            this.targets.putAll(oldTargets);
        } else {
            this.targets = NBTTags.getStringIntegerMap(compound.func_150295_c("QuestKills", 10));
        }
        this.targetType = compound.func_74762_e("TargetType");
        this.customTargetType = compound.func_74779_i("CustomTargetType");
    }

    @Override
    public boolean isCompleted(PlayerData playerData) {
        PlayerQuestData playerdata = playerData.questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        HashMap<String, Integer> killed = this.getKilled(data);
        int completed = 0;
        for (String entityName : this.targets.keySet()) {
            int amount = 0;
            if (killed.containsKey(entityName)) {
                amount = killed.get(entityName);
            }
            if (amount < this.targets.get(entityName)) continue;
            ++completed;
        }
        if (completed >= this.targets.keySet().size()) {
            return true;
        }
        if (killed.size() != this.targets.size()) {
            return false;
        }
        for (String entity : killed.keySet()) {
            if (this.targets.containsKey(entity) && this.targets.get(entity) <= killed.get(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return vec;
        }
        HashMap<String, Integer> killed = this.getKilled(data);
        for (String entityName : this.targets.keySet()) {
            int amount = 0;
            if (killed.containsKey(entityName)) {
                amount = killed.get(entityName);
            }
            String state = amount + "/" + this.targets.get(entityName);
            vec.add(entityName + ": " + state);
        }
        return vec;
    }

    public HashMap<String, Integer> getKilled(QuestData data) {
        return NBTTags.getStringIntegerMap(data.extraData.func_150295_c("Killed", 10));
    }

    public void setKilled(QuestData data, HashMap<String, Integer> killed) {
        data.extraData.func_74782_a("Killed", (NBTBase)NBTTags.nbtStringIntegerMap(killed));
    }

    @Override
    public IQuestObjective[] getObjectives(EntityPlayer player) {
        ArrayList<QuestKillObjective> list = new ArrayList<QuestKillObjective>();
        for (Map.Entry<String, Integer> entry : this.targets.entrySet()) {
            list.add(new QuestKillObjective(this, player, entry.getKey(), entry.getValue()));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    @Override
    public void setTargetType(int type) {
        if (type < 0) {
            type = 0;
        }
        if (type > 2) {
            type = 2;
        }
        this.targetType = type;
    }

    @Override
    public int getTargetType() {
        return this.targetType;
    }

    class QuestKillObjective
    implements IQuestObjective {
        private final QuestKill parent;
        private final EntityPlayer player;
        private final String entity;
        private final int amount;

        public QuestKillObjective(QuestKill parent, EntityPlayer player, String entity, int amount) {
            this.parent = parent;
            this.player = player;
            this.entity = entity;
            this.amount = amount;
        }

        @Override
        public int getProgress() {
            PlayerData data = PlayerDataController.instance.getPlayerData(this.player);
            PlayerQuestData playerdata = data.questData;
            QuestData questdata = playerdata.activeQuests.get(this.parent.questId);
            HashMap<String, Integer> killed = this.parent.getKilled(questdata);
            return !killed.containsKey(this.entity) ? 0 : killed.get(this.entity);
        }

        @Override
        public void setProgress(int progress) {
            if (progress >= 0 && progress <= this.amount) {
                PlayerData data = PlayerDataController.instance.getPlayerData(this.player);
                PlayerQuestData playerdata = data.questData;
                QuestData questdata = playerdata.activeQuests.get(this.parent.questId);
                HashMap<String, Integer> killed = this.parent.getKilled(questdata);
                if (!killed.containsKey(this.entity) || killed.get(this.entity) != progress) {
                    killed.put(this.entity, progress);
                    this.parent.setKilled(questdata, killed);
                    data.questData.checkQuestCompletion(data, EnumQuestType.values()[2]);
                    data.questData.checkQuestCompletion(data, EnumQuestType.values()[4]);
                    data.saveNBTData(data.getNBT());
                }
            } else {
                throw new CustomNPCsException("Progress has to be between 0 and " + this.amount, new Object[0]);
            }
        }

        @Override
        public int getMaxProgress() {
            return this.amount;
        }

        @Override
        public boolean isCompleted() {
            return this.getProgress() >= this.amount;
        }

        @Override
        public String getText() {
            return this.entity + ": " + this.getProgress() + "/" + this.getMaxProgress();
        }
    }
}

