/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.handler.data.IQuestLocation;
import noppes.npcs.scripted.handler.data.IQuestObjective;

public class QuestLocation
extends QuestInterface
implements IQuestLocation {
    public String location = "";
    public String location2 = "";
    public String location3 = "";

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.location = compound.func_74779_i("QuestLocation");
        this.location2 = compound.func_74779_i("QuestLocation2");
        this.location3 = compound.func_74779_i("QuestLocation3");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74778_a("QuestLocation", this.location);
        compound.func_74778_a("QuestLocation2", this.location2);
        compound.func_74778_a("QuestLocation3", this.location3);
    }

    @Override
    public boolean isCompleted(PlayerData playerData) {
        PlayerQuestData playerdata = playerData.questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        return this.getFound(data, 0);
    }

    @Override
    public void handleComplete(EntityPlayer player) {
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return vec;
        }
        String found = StatCollector.func_74838_a((String)"quest.found");
        String notfound = StatCollector.func_74838_a((String)"quest.notfound");
        if (!this.location.isEmpty()) {
            vec.add(this.location + ": " + (this.getFound(data, 1) ? found : notfound));
        }
        if (!this.location2.isEmpty()) {
            vec.add(this.location2 + ": " + (this.getFound(data, 2) ? found : notfound));
        }
        if (!this.location3.isEmpty()) {
            vec.add(this.location3 + ": " + (this.getFound(data, 3) ? found : notfound));
        }
        return vec;
    }

    public boolean getFound(QuestData data, int i) {
        if (i == 1) {
            return data.extraData.func_74767_n("LocationFound");
        }
        if (i == 2) {
            return data.extraData.func_74767_n("Location2Found");
        }
        if (i == 3) {
            return data.extraData.func_74767_n("Location3Found");
        }
        if (!this.location.isEmpty() && !data.extraData.func_74767_n("LocationFound")) {
            return false;
        }
        if (!this.location2.isEmpty() && !data.extraData.func_74767_n("Location2Found")) {
            return false;
        }
        return this.location3.isEmpty() || data.extraData.func_74767_n("Location3Found");
    }

    public boolean setFound(QuestData data, String location) {
        if (location.equalsIgnoreCase(this.location) && !data.extraData.func_74767_n("LocationFound")) {
            data.extraData.func_74757_a("LocationFound", true);
            return true;
        }
        if (location.equalsIgnoreCase(this.location2) && !data.extraData.func_74767_n("LocationFound2")) {
            data.extraData.func_74757_a("Location2Found", true);
            return true;
        }
        if (location.equalsIgnoreCase(this.location3) && !data.extraData.func_74767_n("LocationFound3")) {
            data.extraData.func_74757_a("Location3Found", true);
            return true;
        }
        return false;
    }

    @Override
    public IQuestObjective[] getObjectives(EntityPlayer player) {
        ArrayList<QuestLocationObjective> list = new ArrayList<QuestLocationObjective>();
        if (!this.location.isEmpty()) {
            list.add(new QuestLocationObjective(this, player, this.location, "LocationFound"));
        }
        if (!this.location2.isEmpty()) {
            list.add(new QuestLocationObjective(this, player, this.location2, "Location2Found"));
        }
        if (!this.location3.isEmpty()) {
            list.add(new QuestLocationObjective(this, player, this.location3, "Location3Found"));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    @Override
    public void setLocation1(String loc1) {
        this.location = loc1;
    }

    @Override
    public String getLocation1() {
        return this.location;
    }

    @Override
    public void setLocation2(String loc2) {
        this.location2 = loc2;
    }

    @Override
    public String getLocation2() {
        return this.location2;
    }

    @Override
    public void setLocation3(String loc3) {
        this.location3 = loc3;
    }

    @Override
    public String getLocation3() {
        return this.location3;
    }

    class QuestLocationObjective
    implements IQuestObjective {
        private final QuestLocation parent;
        private final EntityPlayer player;
        private final String location;
        private final String nbtName;

        public QuestLocationObjective(QuestLocation this$02, EntityPlayer player, String location, String nbtName) {
            this.parent = this$02;
            this.player = player;
            this.location = location;
            this.nbtName = nbtName;
        }

        @Override
        public int getProgress() {
            return this.isCompleted() ? 1 : 0;
        }

        @Override
        public void setProgress(int progress) {
            if (progress >= 0 && progress <= 1) {
                PlayerData data = PlayerDataController.instance.getPlayerData(this.player);
                QuestData questData = data.questData.activeQuests.get(this.parent.questId);
                boolean completed = questData.extraData.func_74767_n(this.nbtName);
                if (!(completed && progress == 1 || !completed && progress == 0)) {
                    questData.extraData.func_74757_a(this.nbtName, progress == 1);
                    data.questData.checkQuestCompletion(data, EnumQuestType.values()[3]);
                    data.saveNBTData(data.getNBT());
                }
            } else {
                throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
            }
        }

        @Override
        public int getMaxProgress() {
            return 1;
        }

        @Override
        public boolean isCompleted() {
            PlayerData data = PlayerDataController.instance.getPlayerData(this.player);
            QuestData questData = data.questData.activeQuests.get(this.parent.questId);
            return questData.extraData.func_74767_n(this.nbtName);
        }

        @Override
        public String getText() {
            return this.location + ": " + (this.isCompleted() ? "Found" : "Not Found");
        }
    }
}

