/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.scripted.ScriptBlock;
import noppes.npcs.scripted.ScriptEntityParticle;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptScoreboard;
import noppes.npcs.scripted.entity.ScriptEntity;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.interfaces.IBlock;
import noppes.npcs.scripted.interfaces.IWorld;

public class ScriptWorld
implements IWorld {
    private static Map<String, Object> tempData = new HashMap<String, Object>();
    public WorldServer world;

    public ScriptWorld(WorldServer world) {
        this.world = world;
    }

    public static ScriptWorld createNew(WorldServer world) {
        return new ScriptWorld(world);
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    @Override
    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        if (block == null || block.isAir((IBlockAccess)this.world, x, y, z)) {
            return null;
        }
        return new ScriptBlock((World)this.world, block, new BlockPos(x, y, z));
    }

    @Override
    public String getSignText(int x, int y, int z) {
        TileEntity tile = this.world.func_147438_o(x, y, z);
        if (tile instanceof TileBigSign) {
            return ((TileBigSign)tile).getText();
        }
        if (tile instanceof TileEntitySign) {
            TileEntitySign tileSign = (TileEntitySign)tile;
            String s = tileSign.field_145915_a[0] + "\n";
            s = s + tileSign.field_145915_a[1] + "\n";
            s = s + tileSign.field_145915_a[2] + "\n";
            s = s + tileSign.field_145915_a[3];
            return s;
        }
        return null;
    }

    @Override
    public void setBlock(int x, int y, int z, ScriptItemStack item) {
        if (item == null) {
            this.removeBlock(x, y, z);
            return;
        }
        Block block = Block.func_149634_a((Item)item.item.func_77973_b());
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        this.world.func_147449_b(x, y, z, block);
    }

    @Override
    public void removeBlock(int x, int y, int z) {
        this.world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    @Override
    public ScriptPlayer getPlayer(String name) {
        EntityPlayer player = this.world.func_72924_a(name);
        if (player == null) {
            return null;
        }
        return (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)player);
    }

    @Override
    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    @Override
    public boolean isDay() {
        return this.world.func_72820_D() % 24000L < 12000L;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void setRaining(boolean bo) {
        this.world.func_72912_H().func_76084_b(bo);
    }

    @Override
    public void thunderStrike(double x, double y, double z) {
        this.world.func_72942_c((Entity)new EntityLightningBolt((World)this.world, x, y, z));
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        this.world.func_147487_a(particle, x, y, z, count, dx, dy, dz, speed);
    }

    @Override
    public ScriptItemStack createItem(String id, int damage, int size) {
        Item item = (Item)Item.field_150901_e.func_82594_a(id);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(new ItemStack(item, size, damage));
    }

    @Override
    public ScriptEntityParticle createEntityParticle(String directory) {
        return new ScriptEntityParticle(directory);
    }

    @Override
    public Object getTempData(String key) {
        return tempData.get(key);
    }

    @Override
    public void setTempData(String key, Object value) {
        tempData.put(key, value);
    }

    @Override
    public boolean hasTempData(String key) {
        return tempData.containsKey(key);
    }

    @Override
    public void removeTempData(String key) {
        tempData.remove(key);
    }

    @Override
    public void clearTempData() {
        tempData.clear();
    }

    @Override
    public Object getStoredData(String key) {
        NBTTagCompound compound = ScriptController.Instance.compound;
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        if (base instanceof NBTBase.NBTPrimitive) {
            return ((NBTBase.NBTPrimitive)base).func_150286_g();
        }
        return ((NBTTagString)base).func_150285_a_();
    }

    @Override
    public void setStoredData(String key, Object value) {
        NBTTagCompound compound = ScriptController.Instance.compound;
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        ScriptController.Instance.shouldSave = true;
    }

    @Override
    public boolean hasStoredData(String key) {
        return ScriptController.Instance.compound.func_74764_b(key);
    }

    @Override
    public void removeStoredData(String key) {
        ScriptController.Instance.compound.func_82580_o(key);
        ScriptController.Instance.shouldSave = true;
    }

    @Override
    public void clearStoredData() {
        ScriptController.Instance.compound = new NBTTagCompound();
        ScriptController.Instance.shouldSave = true;
    }

    @Override
    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.world.func_72885_a(null, x, y, z, range, fire, grief);
    }

    @Override
    public ScriptPlayer[] getAllServerPlayers() {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        ScriptPlayer[] arr = new ScriptPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)list.get(i));
        }
        return arr;
    }

    @Override
    public String getBiomeName(int x, int z) {
        return this.world.func_72807_a((int)x, (int)z).field_76791_y;
    }

    @Override
    public ScriptEntity spawnClone(int x, int y, int z, int tab, String name) {
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(null, name, tab);
        if (compound == null) {
            return null;
        }
        Entity entity = NoppesUtilServer.spawnClone(compound, x, y, z, (World)this.world);
        if (entity == null) {
            return null;
        }
        return ScriptController.Instance.getScriptForEntity(entity);
    }

    @Override
    public ScriptScoreboard getScoreboard() {
        return new ScriptScoreboard();
    }

    @Override
    public BlockPos getMCBlockPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public WorldServer getMCWorld() {
        return this.world;
    }

    @Override
    public int getDimensionID() {
        return this.world.field_73011_w.field_76574_g;
    }
}

