/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.ScriptBlockPos;
import noppes.npcs.scripted.ScriptEntityParticle;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.interfaces.IEntity;
import noppes.npcs.scripted.interfaces.INbt;
import noppes.npcs.scripted.interfaces.IPos;

public class ScriptEntity<T extends Entity>
implements IEntity {
    protected T entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();

    public ScriptEntity(T entity) {
        this.entity = entity;
    }

    @Override
    public void spawnParticle(String directory, int HEXcolor, int amount, int maxAge, double x, double y, double z, double motionX, double motionY, double motionZ, float gravity, float scale1, float scale2, float scaleRate, int scaleRateStart, float alpha1, float alpha2, float alphaRate, int alphaRateStart, float rotation1, float rotation2, float rotationRate, int rotationRateStart, float rotationX1, float rotationX2, float rotationXRate, int rotationXRateStart, float rotationY1, float rotationY2, float rotationYRate, int rotationYRateStart, float rotationZ1, float rotationZ2, float rotationZRate, int rotationZRateStart) {
        int entityID = this.entity.func_145782_y();
        NoppesUtilServer.spawnScriptedParticle(directory, HEXcolor, amount, maxAge, x, y, z, motionX, motionY, motionZ, gravity, scale1, scale2, scaleRate, scaleRateStart, alpha1, alpha2, alphaRate, alphaRateStart, rotationX1, rotationX2, rotationXRate, rotationXRateStart, rotationY1, rotationY2, rotationYRate, rotationYRateStart, rotationZ1, rotationZ2, rotationZRate, rotationZRateStart, entityID);
    }

    public void spawnParticle(String directory, int HEXcolor, int amount, int maxAge, double x, double y, double z, double motionX, double motionY, double motionZ, float gravity, float scale1, float scale2, float scaleRate, int scaleRateStart, float alpha1, float alpha2, float alphaRate, int alphaRateStart) {
        int entityID = this.entity.func_145782_y();
        NoppesUtilServer.spawnScriptedParticle(directory, HEXcolor, amount, maxAge, x, y, z, motionX, motionY, motionZ, gravity, scale1, scale2, scaleRate, scaleRateStart, alpha1, alpha2, alphaRate, alphaRateStart, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, entityID);
    }

    public void spawnParticle(String directory, int HEXcolor, int amount, int maxAge, double x, double y, double z, double motionX, double motionY, double motionZ, float gravity, float scale1, float scale2, float scaleRate, int scaleRateStart) {
        int entityID = this.entity.func_145782_y();
        NoppesUtilServer.spawnScriptedParticle(directory, HEXcolor, amount, maxAge, x, y, z, motionX, motionY, motionZ, gravity, scale1, scale2, scaleRate, scaleRateStart, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, entityID);
    }

    public void spawnParticle(String directory, int HEXcolor, int amount, int maxAge, double x, double y, double z, double motionX, double motionY, double motionZ, float gravity) {
        int entityID = this.entity.func_145782_y();
        NoppesUtilServer.spawnScriptedParticle(directory, HEXcolor, amount, maxAge, x, y, z, motionX, motionY, motionZ, gravity, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, entityID);
    }

    public void spawnParticle(String directory, int HEXcolor, int amount, int maxAge, double x, double y, double z) {
        int entityID = this.entity.func_145782_y();
        NoppesUtilServer.spawnScriptedParticle(directory, HEXcolor, amount, maxAge, x, y, z, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, entityID);
    }

    public void spawnParticle(String directory, int HEXcolor, int amount, int maxAge) {
        int entityID = this.entity.func_145782_y();
        NoppesUtilServer.spawnScriptedParticle(directory, HEXcolor, amount, maxAge, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 0, entityID);
    }

    public void spawnParticle(ScriptEntityParticle entityParticle) {
        entityParticle.spawnOnEntity(this);
    }

    @Override
    public double getYOffset() {
        return this.entity.func_70033_W();
    }

    @Override
    public double getWidth() {
        return ((Entity)this.entity).field_70130_N;
    }

    @Override
    public double getHeight() {
        return ((Entity)this.entity).field_70131_O;
    }

    @Override
    public double getX() {
        return ((Entity)this.entity).field_70165_t;
    }

    @Override
    public void setX(double x) {
        this.entity.func_70107_b(x, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v);
    }

    @Override
    public double getY() {
        return ((Entity)this.entity).field_70163_u;
    }

    @Override
    public void setY(double y) {
        this.entity.func_70107_b(((Entity)this.entity).field_70165_t, y, ((Entity)this.entity).field_70161_v);
    }

    @Override
    public double getZ() {
        return ((Entity)this.entity).field_70161_v;
    }

    @Override
    public void setZ(double z) {
        this.entity.func_70107_b(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, z);
    }

    public double getMotionX() {
        return ((Entity)this.entity).field_70159_w;
    }

    public void setMotionX(double x) {
        ((Entity)this.entity).field_70159_w = x;
        ((Entity)this.entity).field_70133_I = true;
    }

    public double getMotionY() {
        return ((Entity)this.entity).field_70181_x;
    }

    public void setMotionY(double y) {
        ((Entity)this.entity).field_70181_x = y;
        ((Entity)this.entity).field_70133_I = true;
    }

    public double getMotionZ() {
        return ((Entity)this.entity).field_70179_y;
    }

    public void setMotionZ(double z) {
        ((Entity)this.entity).field_70179_y = z;
        ((Entity)this.entity).field_70133_I = true;
    }

    public void setMotion(double x, double y, double z) {
        this.setMotionX(x);
        this.setMotionY(y);
        this.setMotionZ(z);
    }

    public boolean isAirborne() {
        return ((Entity)this.entity).field_70160_al;
    }

    @Override
    public int getBlockX() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70165_t);
    }

    @Override
    public int getBlockY() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70163_u);
    }

    @Override
    public int getBlockZ() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70161_v);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    public IPos getPos() {
        return new ScriptBlockPos(new BlockPos(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v));
    }

    public void setPos(IPos pos) {
        this.entity.func_70107_b((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
    }

    @Override
    public ScriptEntity[] getSurroundingEntities(int range) {
        List entities = ((Entity)this.entity).field_70170_p.func_72872_a(Entity.class, ((Entity)this.entity).field_70121_D.func_72314_b((double)range, (double)range, (double)range));
        ArrayList<ScriptEntity> list = new ArrayList<ScriptEntity>();
        for (Entity living : entities) {
            if (living == this.entity) continue;
            list.add(ScriptController.Instance.getScriptForEntity(living));
        }
        return list.toArray(new ScriptEntity[list.size()]);
    }

    @Override
    public ScriptEntity[] getSurroundingEntities(int range, int type) {
        Class cls = Entity.class;
        if (type == 5) {
            cls = EntityLivingBase.class;
        } else if (type == 1) {
            cls = EntityPlayer.class;
        } else if (type == 4) {
            cls = EntityAnimal.class;
        } else if (type == 3) {
            cls = EntityMob.class;
        } else if (type == 2) {
            cls = EntityNPCInterface.class;
        }
        List entities = ((Entity)this.entity).field_70170_p.func_72872_a(cls, ((Entity)this.entity).field_70121_D.func_72314_b((double)range, (double)range, (double)range));
        ArrayList<ScriptEntity> list = new ArrayList<ScriptEntity>();
        for (Entity living : entities) {
            if (living == this.entity) continue;
            list.add(ScriptController.Instance.getScriptForEntity(living));
        }
        return list.toArray(new ScriptEntity[list.size()]);
    }

    @Override
    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    @Override
    public Object getTempData(String key) {
        return this.tempData.get(key);
    }

    @Override
    public void setTempData(String key, Object value) {
        this.tempData.put(key, value);
    }

    @Override
    public boolean hasTempData(String key) {
        return this.tempData.containsKey(key);
    }

    @Override
    public void removeTempData(String key) {
        this.tempData.remove(key);
    }

    @Override
    public void clearTempData() {
        this.tempData.clear();
    }

    @Override
    public Object getStoredData(String key) {
        NBTTagCompound compound = this.getStoredCompound();
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        if (base instanceof NBTBase.NBTPrimitive) {
            return ((NBTBase.NBTPrimitive)base).func_150286_g();
        }
        return ((NBTTagString)base).func_150285_a_();
    }

    @Override
    public void setStoredData(String key, Object value) {
        NBTTagCompound compound = this.getStoredCompound();
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        this.saveStoredCompound(compound);
    }

    @Override
    public boolean hasStoredData(String key) {
        return this.getStoredCompound().func_74764_b(key);
    }

    @Override
    public void removeStoredData(String key) {
        NBTTagCompound compound = this.getStoredCompound();
        compound.func_82580_o(key);
        this.saveStoredCompound(compound);
    }

    @Override
    public void clearStoredData() {
        this.entity.getEntityData().func_82580_o("CNPCStoredData");
    }

    private NBTTagCompound getStoredCompound() {
        NBTTagCompound compound = this.entity.getEntityData().func_74775_l("CNPCStoredData");
        if (compound == null) {
            compound = new NBTTagCompound();
            this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
        }
        return compound;
    }

    private void saveStoredCompound(NBTTagCompound compound) {
        this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
    }

    @Override
    public long getAge() {
        return ((Entity)this.entity).field_70173_aa;
    }

    @Override
    public void despawn() {
        ((Entity)this.entity).field_70128_L = true;
    }

    @Override
    public boolean inWater() {
        return this.entity.func_70055_a(Material.field_151586_h);
    }

    @Override
    public boolean inLava() {
        return this.entity.func_70055_a(Material.field_151587_i);
    }

    @Override
    public boolean inFire() {
        return this.entity.func_70055_a(Material.field_151581_o);
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.func_70015_d(ticks);
    }

    @Override
    public void extinguish() {
        this.entity.func_70066_B();
    }

    @Override
    public String getTypeName() {
        return EntityList.func_75621_b(this.entity);
    }

    @Override
    public void dropItem(ScriptItemStack item) {
        this.entity.func_70099_a(item.item, 0.0f);
    }

    @Override
    public ScriptEntity getRider() {
        return ScriptController.Instance.getScriptForEntity(((Entity)this.entity).field_70153_n);
    }

    @Override
    public void setRider(ScriptEntity entity) {
        if (entity != null) {
            entity.entity.func_70078_a(this.entity);
        } else if (((Entity)this.entity).field_70153_n != null) {
            ((Entity)this.entity).field_70153_n.func_70078_a(null);
        }
    }

    @Override
    public ScriptEntity getMount() {
        return ScriptController.Instance.getScriptForEntity(((Entity)this.entity).field_70154_o);
    }

    @Override
    public void setMount(ScriptEntity entity) {
        if (entity == null) {
            this.entity.func_70078_a(null);
        } else {
            this.entity.func_70078_a(entity.entity);
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 0;
    }

    @Override
    public void setRotation(float rotation) {
        ((Entity)this.entity).field_70177_z = rotation;
    }

    @Override
    public float getRotation() {
        return ((Entity)this.entity).field_70177_z;
    }

    public void setPitch(float pitch) {
        ((Entity)this.entity).field_70125_A = pitch;
    }

    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)power), (double)power, (double)(MathHelper.func_76134_b((float)v) * (float)power));
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void knockback(int xpower, int ypower, int zpower, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)xpower), (double)ypower, (double)(MathHelper.func_76134_b((float)v) * (float)zpower));
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setImmune(int ticks) {
        ((Entity)this.entity).field_70172_ad = ticks;
    }

    @Override
    public boolean hasCollided() {
        return ((Entity)this.entity).field_70132_H;
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    public INbt getNbt() {
        return NpcAPI.Instance().getINbt(this.entity.getEntityData());
    }

    public INbt getAllNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        this.entity.func_70109_d(compound);
        return NpcAPI.Instance().getINbt(compound);
    }

    public void setNbt(INbt nbt) {
        this.entity.func_70020_e(nbt.getMCNBT());
    }

    @Override
    public void storeAsClone(int tab, String name) {
        NBTTagCompound compound = new NBTTagCompound();
        if (!this.entity.func_70039_c(compound)) {
            throw new CustomNPCsException("Cannot store dead entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }

    public ScriptWorld getWorld() {
        return (ScriptWorld)NpcAPI.Instance().getIWorld((WorldServer)((Entity)this.entity).field_70170_p);
    }
}

