/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.entity;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptPixelmonPlayerData;
import noppes.npcs.scripted.entity.ScriptDBCPlayer;
import noppes.npcs.scripted.entity.ScriptLivingBase;
import noppes.npcs.scripted.gui.ScriptGui;
import noppes.npcs.scripted.handler.data.IQuest;
import noppes.npcs.scripted.interfaces.IContainer;
import noppes.npcs.scripted.interfaces.ICustomGui;
import noppes.npcs.scripted.interfaces.ICustomOverlay;
import noppes.npcs.scripted.interfaces.IPlayer;
import noppes.npcs.scripted.interfaces.ITimers;
import noppes.npcs.scripted.overlay.ScriptOverlay;
import noppes.npcs.util.ValueUtil;

public class ScriptPlayer<T extends EntityPlayerMP>
extends ScriptLivingBase<T>
implements IPlayer {
    public T player;
    private PlayerData data;

    public ScriptPlayer(T player) {
        super(player);
        this.player = player;
    }

    @Override
    public String getDisplayName() {
        return this.player.getDisplayName();
    }

    @Override
    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        NoppesUtilPlayer.teleportPlayer(this.player, x, y, z, ((EntityPlayerMP)this.player).field_71093_bK);
    }

    @Override
    public void setPosition(double x, double y, double z, int dimensionId) {
        if (NpcAPI.Instance().getIWorld(dimensionId) == null) {
            return;
        }
        NoppesUtilPlayer.teleportPlayer(this.player, x, y, z, dimensionId);
    }

    public int getHunger() {
        return this.player.func_71024_bL().func_75116_a();
    }

    public void setHunger(int hunger) {
        int prevHunger = this.getHunger();
        if (hunger < 0) {
            hunger = 0;
        }
        this.player.func_71024_bL().func_75122_a(hunger - prevHunger, 0.0f);
    }

    public float getSaturation() {
        return this.player.func_71024_bL().func_75115_e();
    }

    public void setSaturation(float saturation) {
        float prevSaturation = this.getHunger();
        if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        this.player.func_71024_bL().func_75122_a(0, saturation - prevSaturation);
    }

    public int getDimension() {
        return ((EntityPlayerMP)this.player).field_71093_bK;
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData(this.player).questData;
        return data.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData(this.player).questData;
        return data.activeQuests.containsKey(id);
    }

    @Override
    public void showDialog(int id) {
        Dialog dialog = (Dialog)DialogController.instance.get(id);
        if (dialog == null) {
            return;
        }
        NoppesUtilServer.openDialog(this.player, new EntityDialogNpc(((EntityPlayerMP)this.player).field_70170_p), dialog, 0);
    }

    @Override
    public boolean hasReadDialog(int id) {
        PlayerDialogData data = PlayerDataController.instance.getPlayerData(this.player).dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        if (data.questData.activeQuests.containsKey(id)) {
            return;
        }
        QuestData questdata = new QuestData(quest);
        data.questData.activeQuests.put(id, questdata);
        Server.sendData(this.player, EnumPacketClient.MESSAGE, new Object[]{"quest.newquest", quest.title});
        Server.sendData(this.player, EnumPacketClient.CHAT, new Object[]{"quest.newquest", ": ", quest.title});
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.finishedQuests.put(id, System.currentTimeMillis());
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.activeQuests.remove(id);
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.activeQuests.remove(id);
        data.questData.finishedQuests.remove(id);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 ? true : super.typeOf(type);
    }

    @Override
    public void addFactionPoints(int faction, int points) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.factionData.increasePoints(faction, points, (EntityPlayer)this.player);
    }

    @Override
    public int getFactionPoints(int faction) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        return data.factionData.getFactionPoints(faction);
    }

    @Override
    public void sendMessage(String message) {
        this.player.func_145747_a((IChatComponent)new ChatComponentTranslation(NoppesStringUtils.formatText(message, this.player), new Object[0]));
    }

    @Override
    public int getMode() {
        return ((EntityPlayerMP)this.player).field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setMode(int type) {
        this.player.func_71033_a(WorldSettings.func_77161_a((int)type));
    }

    @Override
    public int inventoryItemCount(ScriptItemStack item) {
        int i = 0;
        for (ItemStack is : ((EntityPlayerMP)this.player).field_71071_by.field_70462_a) {
            if (is == null || !is.func_77969_a(item.item)) continue;
            i += is.field_77994_a;
        }
        return i;
    }

    @Override
    public ScriptItemStack[] getInventory() {
        ScriptItemStack[] items = new ScriptItemStack[36];
        for (int i = 0; i < ((EntityPlayerMP)this.player).field_71071_by.field_70462_a.length; ++i) {
            ItemStack item = ((EntityPlayerMP)this.player).field_71071_by.field_70462_a[i];
            if (item == null) continue;
            items[i] = new ScriptItemStack(item);
        }
        return items;
    }

    @Override
    public boolean removeItem(ScriptItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < ((EntityPlayerMP)this.player).field_71071_by.field_70462_a.length; ++i) {
                ItemStack is = ((EntityPlayerMP)this.player).field_71071_by.field_70462_a[i];
                if (is == null || !is.func_77969_a(item.item)) continue;
                if (amount > is.field_77994_a) {
                    ((EntityPlayerMP)this.player).field_71071_by.field_70462_a[i] = null;
                    amount -= is.field_77994_a;
                    continue;
                }
                is.func_77979_a(amount);
                break;
            }
        }
        this.updatePlayerInventory();
        return true;
    }

    @Override
    public boolean removeItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a(id);
        if (item == null) {
            return false;
        }
        return this.removeItem(new ScriptItemStack(new ItemStack(item, 1, damage)), amount);
    }

    @Override
    public boolean giveItem(ScriptItemStack item, int amount) {
        if (item != null && item.getMCItemStack() != null) {
            item.setStackSize(amount);
            boolean bool = ((EntityPlayerMP)this.player).field_71071_by.func_70441_a(item.getMCItemStack());
            this.updatePlayerInventory();
            return bool;
        }
        return false;
    }

    @Override
    public boolean giveItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a(id);
        if (item == null) {
            return false;
        }
        return ((EntityPlayerMP)this.player).field_71071_by.func_70441_a(new ItemStack(item, amount, damage));
    }

    @Override
    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        this.player.func_71063_a(new ChunkCoordinates(x, y, z), true);
    }

    @Override
    public void resetSpawnpoint() {
        this.player.func_71063_a(null, false);
    }

    @Override
    public void removeAllItems(ScriptItemStack item) {
        for (int i = 0; i < ((EntityPlayerMP)this.player).field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = ((EntityPlayerMP)this.player).field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77969_a(item.item)) continue;
            ((EntityPlayerMP)this.player).field_71071_by.field_70462_a[i] = null;
        }
    }

    @Override
    public void setRotation(float rotationYaw) {
        NoppesUtilPlayer.teleportPlayer(this.player, ((EntityPlayerMP)this.player).field_70165_t, ((EntityPlayerMP)this.player).field_70163_u, ((EntityPlayerMP)this.player).field_70161_v, rotationYaw, ((EntityPlayerMP)this.player).field_70125_A, ((EntityPlayerMP)this.player).field_71093_bK);
    }

    public void setRotation(float rotationYaw, float rotationPitch) {
        NoppesUtilPlayer.teleportPlayer(this.player, ((EntityPlayerMP)this.player).field_70165_t, ((EntityPlayerMP)this.player).field_70163_u, ((EntityPlayerMP)this.player).field_70161_v, rotationYaw, rotationPitch, ((EntityPlayerMP)this.player).field_71093_bK);
    }

    @Override
    public boolean hasAchievement(String achievement) {
        StatBase statbase = StatList.func_151177_a((String)achievement);
        if (statbase == null || !(statbase instanceof Achievement)) {
            return false;
        }
        return this.player.func_147099_x().func_77443_a((Achievement)statbase);
    }

    @Override
    public boolean hasBukkitPermission(String permission) {
        return CustomNpcsPermissions.hasPermissionString(this.player, permission);
    }

    @Override
    public int getExpLevel() {
        return ((EntityPlayerMP)this.player).field_71068_ca;
    }

    @Override
    public void setExpLevel(int level) {
        ((EntityPlayerMP)this.player).field_71068_ca = level;
        this.player.func_82242_a(0);
    }

    @Override
    public ScriptPixelmonPlayerData getPixelmonData() {
        if (!PixelmonHelper.Enabled) {
            return null;
        }
        return new ScriptPixelmonPlayerData((EntityPlayerMP)this.player);
    }

    @Override
    public ITimers getTimers() {
        return PlayerDataController.instance.getPlayerData(this.player).timers;
    }

    @Override
    public void updatePlayerInventory() {
        ((EntityPlayerMP)this.entity).field_71069_bz.func_75142_b();
        PlayerData playerData = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        PlayerQuestData questData = playerData.questData;
        questData.checkQuestCompletion(playerData, EnumQuestType.Item);
    }

    @Override
    public boolean checkGUIOpen() {
        NoppesUtilPlayer.isGUIOpen(this.player);
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        return data.getGUIOpen();
    }

    public ScriptDBCPlayer<T> getDBCPlayer() {
        Set keySet = this.player.getEntityData().func_74775_l("PlayerPersisted").func_150296_c();
        for (String s : keySet) {
            if (!s.contains("jrmc")) continue;
            return new ScriptDBCPlayer<T>(this.player);
        }
        return null;
    }

    public boolean blocking() {
        return this.player.func_70632_aY();
    }

    private PlayerData getData() {
        if (this.data == null) {
            this.data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        }
        return this.data;
    }

    public IQuest[] getActiveQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.activeQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    public IContainer getOpenContainer() {
        return NpcAPI.Instance().getIContainer(((EntityPlayerMP)this.entity).field_71070_bA);
    }

    public void showCustomGui(ICustomGui gui) {
        CustomGuiController.openGui(this, (ScriptGui)gui);
    }

    public ICustomGui getCustomGui() {
        return ((EntityPlayerMP)this.entity).field_71070_bA instanceof ContainerCustomGui ? ((ContainerCustomGui)((EntityPlayerMP)this.entity).field_71070_bA).customGui : null;
    }

    public void closeGui() {
        ((EntityPlayerMP)this.entity).func_71128_l();
        Server.sendData((EntityPlayerMP)this.entity, EnumPacketClient.GUI_CLOSE, -1, new NBTTagCompound());
    }

    public void showCustomOverlay(ICustomOverlay overlay) {
        CustomGuiController.openOverlay(this, (ScriptOverlay)overlay);
    }

    public void closeOverlay(int id) {
        Server.sendData((EntityPlayerMP)this.entity, EnumPacketClient.OVERLAY_CLOSE, id, new NBTTagCompound());
    }

    public IQuest[] getFinishedQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.finishedQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }
}

