/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerDataScript;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.gui.ScriptGuiButton;
import noppes.npcs.scripted.gui.ScriptGuiComponent;
import noppes.npcs.scripted.gui.ScriptGuiItemSlot;
import noppes.npcs.scripted.gui.ScriptGuiLabel;
import noppes.npcs.scripted.gui.ScriptGuiLine;
import noppes.npcs.scripted.gui.ScriptGuiScroll;
import noppes.npcs.scripted.gui.ScriptGuiTextField;
import noppes.npcs.scripted.gui.ScriptGuiTexturedRect;
import noppes.npcs.scripted.interfaces.IButton;
import noppes.npcs.scripted.interfaces.ICustomGui;
import noppes.npcs.scripted.interfaces.ICustomGuiComponent;
import noppes.npcs.scripted.interfaces.IItemSlot;
import noppes.npcs.scripted.interfaces.IItemStack;
import noppes.npcs.scripted.interfaces.ILabel;
import noppes.npcs.scripted.interfaces.ILine;
import noppes.npcs.scripted.interfaces.IPlayer;
import noppes.npcs.scripted.interfaces.IScroll;
import noppes.npcs.scripted.interfaces.ITextField;
import noppes.npcs.scripted.interfaces.ITexturedRect;

public class ScriptGui
implements ICustomGui {
    int id;
    int width;
    int height;
    int playerInvX;
    int playerInvY;
    boolean pauseGame;
    boolean showPlayerInv;
    String backgroundTexture = "";
    List<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
    List<IItemSlot> slots = new ArrayList<IItemSlot>();

    public ScriptGui() {
    }

    public ScriptGui(int id, int width, int height, boolean pauseGame) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.pauseGame = pauseGame;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public List<ICustomGuiComponent> getComponents() {
        return this.components;
    }

    @Override
    public List<IItemSlot> getSlots() {
        return this.slots;
    }

    public PlayerDataScript getScriptHandler() {
        return ScriptController.Instance.playerScripts;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setDoesPauseGame(boolean pauseGame) {
        this.pauseGame = pauseGame;
    }

    public boolean getDoesPauseGame() {
        return this.pauseGame;
    }

    @Override
    public void setBackgroundTexture(String resourceLocation) {
        this.backgroundTexture = resourceLocation;
    }

    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public IButton addButton(int id, String label, int x, int y) {
        ScriptGuiButton component = new ScriptGuiButton(id, label, x, y);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public IButton addButton(int id, String label, int x, int y, int width, int height) {
        ScriptGuiButton component = new ScriptGuiButton(id, label, x, y, width, height);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture) {
        ScriptGuiButton component = new ScriptGuiButton(id, label, x, y, width, height, texture);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture, int textureX, int textureY) {
        ScriptGuiButton component = new ScriptGuiButton(id, label, x, y, width, height, texture, textureX, textureY);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height) {
        ScriptGuiLabel component = new ScriptGuiLabel(id, label, x, y, width, height);
        this.components.add(component);
        return (ILabel)this.components.get(this.components.size() - 1);
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height, int color) {
        ScriptGuiLabel component = new ScriptGuiLabel(id, label, x, y, width, height, color);
        this.components.add(component);
        return (ILabel)this.components.get(this.components.size() - 1);
    }

    @Override
    public ITextField addTextField(int id, int x, int y, int width, int height) {
        ScriptGuiTextField component = new ScriptGuiTextField(id, x, y, width, height);
        this.components.add(component);
        return (ITextField)this.components.get(this.components.size() - 1);
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height) {
        ScriptGuiTexturedRect component = new ScriptGuiTexturedRect(id, texture, x, y, width, height);
        this.components.add(component);
        return (ITexturedRect)this.components.get(this.components.size() - 1);
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        ScriptGuiTexturedRect component = new ScriptGuiTexturedRect(id, texture, x, y, width, height, textureX, textureY);
        this.components.add(component);
        return (ITexturedRect)this.components.get(this.components.size() - 1);
    }

    @Override
    public IItemSlot addItemSlot(int x, int y) {
        ScriptGuiItemSlot slot = new ScriptGuiItemSlot(x, y);
        this.slots.add(slot);
        return this.slots.get(this.slots.size() - 1);
    }

    @Override
    public IItemSlot addItemSlot(int x, int y, IItemStack stack) {
        ScriptGuiItemSlot slot = new ScriptGuiItemSlot(x, y, stack);
        this.slots.add(slot);
        return this.slots.get(this.slots.size() - 1);
    }

    @Override
    public IScroll addScroll(int id, int x, int y, int width, int height, String[] list) {
        ScriptGuiScroll component = new ScriptGuiScroll(id, x, y, width, height, list);
        this.components.add(component);
        return (IScroll)this.components.get(this.components.size() - 1);
    }

    @Override
    public ILine addLine(int id, int x1, int y1, int x2, int y2, int color, int thickness) {
        ScriptGuiLine line = new ScriptGuiLine(id, x1, y1, x2, y2, color, thickness);
        this.components.add(line);
        return (ILine)this.components.get(this.components.size() - 1);
    }

    @Override
    public ILine addLine(int id, int x1, int y1, int x2, int y2) {
        ScriptGuiLine line = new ScriptGuiLine(id, x1, y1, x2, y2);
        this.components.add(line);
        return (ILine)this.components.get(this.components.size() - 1);
    }

    @Override
    public void showPlayerInventory(int x, int y) {
        this.showPlayerInv = true;
        this.playerInvX = x;
        this.playerInvY = y;
    }

    @Override
    public ICustomGuiComponent getComponent(int componentID) {
        ICustomGuiComponent component;
        Iterator<ICustomGuiComponent> var2 = this.components.iterator();
        do {
            if (var2.hasNext()) continue;
            return null;
        } while ((component = var2.next()).getID() != componentID);
        return component;
    }

    @Override
    public void removeComponent(int componentID) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).getID() != componentID) continue;
            this.components.remove(i);
            return;
        }
    }

    @Override
    public void updateComponent(ICustomGuiComponent component) {
        for (int i = 0; i < this.components.size(); ++i) {
            ICustomGuiComponent c = this.components.get(i);
            if (c.getID() != component.getID()) continue;
            this.components.set(i, component);
            return;
        }
    }

    @Override
    public void update(IPlayer player) {
        CustomGuiController.updateGui((ScriptPlayer)player, this);
    }

    public boolean getShowPlayerInv() {
        return this.showPlayerInv;
    }

    public int getPlayerInvX() {
        return this.playerInvX;
    }

    public int getPlayerInvY() {
        return this.playerInvY;
    }

    public ICustomGui fromNBT(NBTTagCompound tag) {
        this.id = tag.func_74762_e("id");
        this.width = tag.func_74759_k("size")[0];
        this.height = tag.func_74759_k("size")[1];
        this.pauseGame = tag.func_74767_n("pause");
        this.backgroundTexture = tag.func_74779_i("bgTexture");
        ArrayList<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
        NBTTagList list = tag.func_150295_c("components", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound b = list.func_150305_b(i);
            ScriptGuiComponent component = ScriptGuiComponent.createFromNBT(b);
            components.add(component);
        }
        this.components = components;
        ArrayList<IItemSlot> slots = new ArrayList<IItemSlot>();
        list = tag.func_150295_c("slots", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound b = list.func_150305_b(i);
            ScriptGuiItemSlot component = (ScriptGuiItemSlot)ScriptGuiComponent.createFromNBT(b);
            slots.add(component);
        }
        this.slots = slots;
        this.showPlayerInv = tag.func_74767_n("showPlayerInv");
        if (this.showPlayerInv) {
            this.playerInvX = tag.func_74759_k("pInvPos")[0];
            this.playerInvY = tag.func_74759_k("pInvPos")[1];
        }
        return this;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        tag.func_74783_a("size", new int[]{this.width, this.height});
        tag.func_74757_a("pause", this.pauseGame);
        tag.func_74778_a("bgTexture", this.backgroundTexture);
        NBTTagList list = new NBTTagList();
        for (ICustomGuiComponent iCustomGuiComponent : this.components) {
            list.func_74742_a((NBTBase)((ScriptGuiComponent)iCustomGuiComponent).toNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("components", (NBTBase)list);
        list = new NBTTagList();
        for (ICustomGuiComponent iCustomGuiComponent : this.slots) {
            list.func_74742_a((NBTBase)((ScriptGuiComponent)iCustomGuiComponent).toNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("slots", (NBTBase)list);
        tag.func_74757_a("showPlayerInv", this.showPlayerInv);
        if (this.showPlayerInv) {
            tag.func_74783_a("pInvPos", new int[]{this.playerInvX, this.playerInvY});
        }
        return tag;
    }
}

