/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.wrapper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.scripted.entity.ScriptAnimal;
import noppes.npcs.scripted.entity.ScriptEntity;
import noppes.npcs.scripted.entity.ScriptLiving;
import noppes.npcs.scripted.entity.ScriptLivingBase;
import noppes.npcs.scripted.entity.ScriptMonster;
import noppes.npcs.scripted.entity.ScriptPixelmon;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.interfaces.IEntity;

public class WrapperEntityData {
    public IEntity base;
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "entitydata");

    public WrapperEntityData(IEntity base) {
        this.base = base;
    }

    public static IEntity get(Entity entity) {
        if (entity == null) {
            return null;
        }
        WrapperEntityData data = new WrapperEntityData(new ScriptEntity<Entity>(entity));
        if (data == null) {
            return WrapperEntityData.getData((Entity)entity).base;
        }
        return data.base;
    }

    private static WrapperEntityData getData(Entity entity) {
        if (entity != null && entity.field_70170_p != null && !entity.field_70170_p.field_72995_K) {
            if (entity instanceof EntityPlayerMP) {
                return new WrapperEntityData(new ScriptPlayer<EntityPlayerMP>((EntityPlayerMP)entity));
            }
            if (PixelmonHelper.isPixelmon(entity)) {
                return new WrapperEntityData(new ScriptPixelmon<EntityTameable>((EntityTameable)entity));
            }
            if (entity instanceof EntityAnimal) {
                return new WrapperEntityData(new ScriptAnimal<EntityAnimal>((EntityAnimal)entity));
            }
            if (entity instanceof EntityMob) {
                return new WrapperEntityData(new ScriptMonster<EntityMob>((EntityMob)entity));
            }
            if (entity instanceof EntityLiving) {
                return new WrapperEntityData(new ScriptLiving<EntityLiving>((EntityLiving)entity));
            }
            if (entity instanceof EntityLivingBase) {
                return new WrapperEntityData(new ScriptLivingBase<EntityLivingBase>((EntityLivingBase)entity));
            }
        }
        return null;
    }
}

