/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.wrapper;

import cpw.mods.fml.common.eventhandler.EventBus;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.containers.ContainerNpcInterface;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ScriptEntityData;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.ScriptBlock;
import noppes.npcs.scripted.ScriptContainer;
import noppes.npcs.scripted.ScriptEntityParticle;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptNbt;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.entity.ScriptAnimal;
import noppes.npcs.scripted.entity.ScriptEntity;
import noppes.npcs.scripted.entity.ScriptLiving;
import noppes.npcs.scripted.entity.ScriptLivingBase;
import noppes.npcs.scripted.entity.ScriptMonster;
import noppes.npcs.scripted.entity.ScriptPixelmon;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.gui.ScriptGui;
import noppes.npcs.scripted.handler.ICloneHandler;
import noppes.npcs.scripted.handler.IDialogHandler;
import noppes.npcs.scripted.handler.IFactionHandler;
import noppes.npcs.scripted.handler.IQuestHandler;
import noppes.npcs.scripted.handler.IRecipeHandler;
import noppes.npcs.scripted.interfaces.IBlock;
import noppes.npcs.scripted.interfaces.IContainer;
import noppes.npcs.scripted.interfaces.ICustomGui;
import noppes.npcs.scripted.interfaces.ICustomNpc;
import noppes.npcs.scripted.interfaces.ICustomOverlay;
import noppes.npcs.scripted.interfaces.IDamageSource;
import noppes.npcs.scripted.interfaces.IEntity;
import noppes.npcs.scripted.interfaces.IItemStack;
import noppes.npcs.scripted.interfaces.INbt;
import noppes.npcs.scripted.interfaces.IWorld;
import noppes.npcs.scripted.overlay.ScriptOverlay;
import noppes.npcs.scripted.wrapper.ScriptDamageSource;
import noppes.npcs.util.JsonException;
import noppes.npcs.util.LRUHashMap;
import noppes.npcs.util.NBTJsonUtil;

public class WrapperNpcAPI
extends NpcAPI {
    private static final Map<Integer, ScriptWorld> worldCache = new LRUHashMap<Integer, ScriptWorld>(10);
    public static final EventBus EVENT_BUS = new EventBus();
    private static NpcAPI instance = null;

    public static void clearCache() {
        worldCache.clear();
    }

    public IFactionHandler getFactions() {
        this.checkWorld();
        return FactionController.getInstance();
    }

    public IRecipeHandler getRecipes() {
        this.checkWorld();
        return RecipeController.instance;
    }

    public IQuestHandler getQuests() {
        this.checkWorld();
        return QuestController.instance;
    }

    public IDialogHandler getDialogs() {
        return DialogController.instance;
    }

    public ICloneHandler getClones() {
        return ServerCloneController.Instance;
    }

    @Override
    public IEntity getIEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).wrappedNPC;
        }
        ScriptEntityData data = (ScriptEntityData)entity.getExtendedProperties("ScriptedObject");
        if (data != null) {
            return data.base;
        }
        if (entity instanceof EntityPlayerMP) {
            data = new ScriptEntityData(new ScriptPlayer<EntityPlayerMP>((EntityPlayerMP)entity));
        } else {
            if (PixelmonHelper.isPixelmon(entity)) {
                return new ScriptPixelmon<EntityTameable>((EntityTameable)entity);
            }
            data = entity instanceof EntityAnimal ? new ScriptEntityData(new ScriptAnimal<EntityAnimal>((EntityAnimal)entity)) : (entity instanceof EntityMob ? new ScriptEntityData(new ScriptMonster<EntityMob>((EntityMob)entity)) : (entity instanceof EntityLiving ? new ScriptEntityData(new ScriptLiving<EntityLiving>((EntityLiving)entity)) : (entity instanceof EntityLivingBase ? new ScriptEntityData(new ScriptLivingBase<EntityLivingBase>((EntityLivingBase)entity)) : new ScriptEntityData(new ScriptEntity<Entity>(entity)))));
        }
        entity.registerExtendedProperties("ScriptedObject", (IExtendedEntityProperties)data);
        return data.base;
    }

    @Override
    public IBlock getIBlock(World world, BlockPos pos) {
        return new ScriptBlock(world, world.func_147439_a(pos.getX(), pos.getY(), pos.getZ()), pos);
    }

    @Override
    public IBlock getIBlock(World world, int x, int y, int z) {
        return new ScriptBlock(world, world.func_147439_a(x, y, z), new BlockPos(x, y, z));
    }

    @Override
    public INbt getINbt(NBTTagCompound compound) {
        return compound == null ? new ScriptNbt(new NBTTagCompound()) : new ScriptNbt(compound);
    }

    public INbt stringToNbt(String str) {
        if (str != null && !str.isEmpty()) {
            try {
                return this.getINbt(NBTJsonUtil.Convert(str));
            }
            catch (JsonException var3) {
                throw new CustomNPCsException(var3, "Failed converting " + str, new Object[0]);
            }
        }
        throw new CustomNPCsException("Cant cast empty string to nbt", new Object[0]);
    }

    @Override
    public ICustomNpc createNPC(World world) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        return npc.wrappedNPC;
    }

    @Override
    public ICustomNpc spawnNPC(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        npc.func_70080_a((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        npc.func_70606_j(npc.func_110138_aP());
        world.func_72838_d((Entity)npc);
        return npc.wrappedNPC;
    }

    public static NpcAPI Instance() {
        if (instance == null) {
            instance = new WrapperNpcAPI();
        }
        return instance;
    }

    @Override
    public EventBus events() {
        return EVENT_BUS;
    }

    @Override
    public IItemStack getIItemStack(ItemStack itemstack) {
        return itemstack != null && itemstack.field_77994_a > 0 ? new ScriptItemStack(itemstack) : new ScriptItemStack(new ItemStack(Item.func_150899_d((int)0)));
    }

    @Override
    public IWorld getIWorld(WorldServer world) {
        ScriptWorld w = worldCache.get(world.field_73011_w.field_76574_g);
        if (w != null) {
            w.world = world;
            return w;
        }
        w = ScriptWorld.createNew(world);
        worldCache.put(world.field_73011_w.field_76574_g, w);
        return w;
    }

    @Override
    public IWorld getIWorld(int dimensionId) {
        for (WorldServer world : CustomNpcs.getServer().field_71305_c) {
            if (world.field_73011_w.field_76574_g != dimensionId) continue;
            return this.getIWorld(world);
        }
        throw new CustomNPCsException("Unknown dimension id: " + dimensionId, new Object[0]);
    }

    @Override
    public IContainer getIContainer(IInventory inventory) {
        return new ScriptContainer(inventory);
    }

    @Override
    public IContainer getIContainer(Container container) {
        return container instanceof ContainerNpcInterface ? ContainerNpcInterface.getOrCreateIContainer((ContainerNpcInterface)container) : new ScriptContainer(container);
    }

    private void checkWorld() {
        if (CustomNpcs.getServer() == null || CustomNpcs.getServer().func_71241_aa()) {
            throw new CustomNPCsException("No world is loaded right now", new Object[0]);
        }
    }

    @Override
    public IWorld[] getIWorlds() {
        this.checkWorld();
        IWorld[] worlds = new IWorld[CustomNpcs.getServer().field_71305_c.length];
        for (int i = 0; i < CustomNpcs.getServer().field_71305_c.length; ++i) {
            worlds[i] = this.getIWorld(CustomNpcs.getServer().field_71305_c[i]);
        }
        return worlds;
    }

    @Override
    public File getGlobalDir() {
        return CustomNpcs.Dir;
    }

    @Override
    public File getWorldDir() {
        return CustomNpcs.getWorldSaveDirectory();
    }

    @Override
    public IDamageSource getIDamageSource(DamageSource damagesource) {
        return new ScriptDamageSource(damagesource);
    }

    public IDamageSource getIDamageSource(IEntity entity) {
        if (entity.getType() == 1) {
            return new ScriptDamageSource((DamageSource)new EntityDamageSource("player", entity.getMCEntity()));
        }
        return new ScriptDamageSource((DamageSource)new EntityDamageSource(entity.getTypeName(), entity.getMCEntity()));
    }

    @Override
    public void executeCommand(IWorld world, String command) {
        NoppesUtilServer.runCommand((World)world.getMCWorld(), "API", command);
    }

    @Override
    public String getRandomName(int dictionary, int gender) {
        return CustomNpcs.MARKOV_GENERATOR[dictionary].fetch(gender);
    }

    @Override
    public ScriptPlayer[] getAllServerPlayers() {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        ScriptPlayer[] arr = new ScriptPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)list.get(i));
        }
        return arr;
    }

    @Override
    public ScriptItemStack createItem(String id, int damage, int size) {
        Item item = (Item)Item.field_150901_e.func_82594_a(id);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(new ItemStack(item, size, damage));
    }

    @Override
    public ScriptEntityParticle createEntityParticle(String directory) {
        return new ScriptEntityParticle(directory);
    }

    @Override
    public int getServerTime() {
        return MinecraftServer.func_71276_C().func_71259_af();
    }

    public ICustomGui createCustomGui(int id, int width, int height, boolean pauseGame) {
        return new ScriptGui(id, width, height, pauseGame);
    }

    public ICustomOverlay createCustomOverlay(int id) {
        return new ScriptOverlay(id);
    }
}

