/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjBadCrcException;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;

class PngIDatChunkInputStream
extends InputStream {
    private final InputStream inputStream;
    private final CRC32 crcEngine;
    private boolean checkCrc = true;
    private int lenLastChunk;
    private byte[] idLastChunk = new byte[4];
    private int toReadThisChunk = 0;
    private boolean ended = false;
    private long offset;
    List<IdatChunkInfo> foundChunksInfo = new ArrayList<IdatChunkInfo>();

    PngIDatChunkInputStream(InputStream iStream, int lenFirstChunk, long offset) {
        this.offset = offset;
        this.inputStream = iStream;
        this.lenLastChunk = lenFirstChunk;
        this.toReadThisChunk = lenFirstChunk;
        System.arraycopy(ChunkHelper.b_IDAT, 0, this.idLastChunk, 0, 4);
        this.crcEngine = new CRC32();
        this.crcEngine.update(this.idLastChunk, 0, 4);
        this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, offset - 8L));
        if (this.lenLastChunk == 0) {
            this.endChunkGoForNext();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void endChunkGoForNext() {
        do {
            int crc = PngHelperInternal.readInt4(this.inputStream);
            this.offset += 4L;
            if (this.checkCrc) {
                int crccalc = (int)this.crcEngine.getValue();
                if (this.lenLastChunk > 0 && crc != crccalc) {
                    throw new PngjBadCrcException("error reading idat; offset: " + this.offset);
                }
                this.crcEngine.reset();
            }
            this.toReadThisChunk = this.lenLastChunk = PngHelperInternal.readInt4(this.inputStream);
            PngHelperInternal.readBytes(this.inputStream, this.idLastChunk, 0, 4);
            this.offset += 8L;
            boolean bl = this.ended = !Arrays.equals(this.idLastChunk, ChunkHelper.b_IDAT);
            if (this.ended) continue;
            this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, this.offset - 8L));
            if (!this.checkCrc) continue;
            this.crcEngine.update(this.idLastChunk, 0, 4);
        } while (this.lenLastChunk == 0 && !this.ended);
    }

    void forceChunkEnd() {
        if (!this.ended) {
            byte[] dummy = new byte[this.toReadThisChunk];
            PngHelperInternal.readBytes(this.inputStream, dummy, 0, this.toReadThisChunk);
            if (this.checkCrc) {
                this.crcEngine.update(dummy, 0, this.toReadThisChunk);
            }
            this.endChunkGoForNext();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.ended) {
            return -1;
        }
        if (this.toReadThisChunk == 0) {
            throw new PngjExceptionInternal("this should not happen");
        }
        int n = this.inputStream.read(b, off, len >= this.toReadThisChunk ? this.toReadThisChunk : len);
        if (n > 0) {
            if (this.checkCrc) {
                this.crcEngine.update(b, off, n);
            }
            this.offset += (long)n;
            this.toReadThisChunk -= n;
        }
        if (this.toReadThisChunk == 0) {
            this.endChunkGoForNext();
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        byte[] b1 = new byte[1];
        int r = this.read(b1, 0, 1);
        return r < 0 ? -1 : b1[0];
    }

    int getLenLastChunk() {
        return this.lenLastChunk;
    }

    byte[] getIdLastChunk() {
        return this.idLastChunk;
    }

    long getOffset() {
        return this.offset;
    }

    boolean isEnded() {
        return this.ended;
    }

    void disableCrcCheck() {
        this.checkCrc = false;
    }

    static class IdatChunkInfo {
        public final int len;
        public final long offset;

        private IdatChunkInfo(int len, long offset) {
            this.len = len;
            this.offset = offset;
        }
    }
}

