/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjBadCrcException;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class ChunkRaw {
    public final int len;
    public final byte[] idbytes = new byte[4];
    public byte[] data = null;
    private int crcval = 0;

    public ChunkRaw(int len, byte[] idbytes, boolean alloc) {
        this.len = len;
        System.arraycopy(idbytes, 0, this.idbytes, 0, 4);
        if (alloc) {
            this.allocData();
        }
    }

    private void allocData() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }

    private int computeCrc() {
        CRC32 crcengine = PngHelperInternal.getCRC();
        crcengine.reset();
        crcengine.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            crcengine.update(this.data, 0, this.len);
        }
        return (int)crcengine.getValue();
    }

    public void writeChunk(OutputStream os) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + ChunkHelper.toString(this.idbytes) + "]");
        }
        this.crcval = this.computeCrc();
        PngHelperInternal.writeInt4(os, this.len);
        PngHelperInternal.writeBytes(os, this.idbytes);
        if (this.len > 0) {
            PngHelperInternal.writeBytes(os, this.data, 0, this.len);
        }
        PngHelperInternal.writeInt4(os, this.crcval);
    }

    public int readChunkData(InputStream is, boolean checkCrc) {
        int crc;
        PngHelperInternal.readBytes(is, this.data, 0, this.len);
        this.crcval = PngHelperInternal.readInt4(is);
        if (checkCrc && (crc = this.computeCrc()) != this.crcval) {
            throw new PngjBadCrcException("chunk: " + this + " crc calc=" + crc + " read=" + this.crcval);
        }
        return this.len + 4;
    }

    ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toString(this.idbytes) + " len=" + this.len;
    }
}

