/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties.config;

import com.google.common.util.concurrent.AtomicDouble;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import journeymap.client.Constants;
import journeymap.client.log.LogFormatter;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.properties.config.Config;
import journeymap.client.ui.option.StringListProvider;
import journeymap.common.Journeymap;

public class ConfigValidation {
    public static boolean validateConfigs(PropertiesBase instance) {
        try {
            boolean saveNeeded = ConfigValidation.validateConfigs(instance.getClass(), instance);
            if (saveNeeded) {
                Journeymap.getLogger().warn(instance.getClass().getSimpleName() + " failed validation and has been corrected.");
            }
            return saveNeeded;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ConfigValidation: " + LogFormatter.toString(t));
            return false;
        }
    }

    private static boolean validateConfigs(Class<? extends PropertiesBase> propertiesClass, PropertiesBase instance) throws Exception {
        boolean saveNeeded = false;
        for (Field field : propertiesClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Config.class)) continue;
            Config config = field.getAnnotation(Config.class);
            Class<?> fieldType = field.getType();
            if (field.get(instance) == null) {
                saveNeeded = true;
                continue;
            }
            if (fieldType.equals(AtomicBoolean.class)) continue;
            if (fieldType.equals(AtomicInteger.class)) {
                saveNeeded = ConfigValidation.validateInteger(config, field, instance) || saveNeeded;
                continue;
            }
            if (fieldType.equals(AtomicDouble.class)) {
                Journeymap.getLogger().error("Validation for AtomicDouble not implemented.");
                continue;
            }
            if (!fieldType.equals(AtomicReference.class)) continue;
            saveNeeded = !config.stringListProvider().equals(Config.NoStringProvider.class) ? ConfigValidation.validateString(config, field, instance) || saveNeeded : ConfigValidation.validateEnum(config, field, instance) || saveNeeded;
        }
        Class<? extends PropertiesBase> parentClass = propertiesClass.getSuperclass();
        if (PropertiesBase.class.isAssignableFrom(parentClass)) {
            saveNeeded = ConfigValidation.validateConfigs(parentClass, instance) || saveNeeded;
        }
        return saveNeeded;
    }

    private static boolean validateInteger(Config config, Field field, PropertiesBase instance) throws Exception {
        boolean saveNeeded = false;
        if (config.minValue() == config.maxValue()) {
            Journeymap.getLogger().warn(String.format("@Config on %s.%s has no range", instance.getClass().getSimpleName(), field.getName()));
        } else {
            int defaultValue = (int)config.defaultValue();
            boolean defaultValueUsable = true;
            if ((double)defaultValue < config.minValue() || (double)defaultValue > config.maxValue()) {
                defaultValueUsable = false;
                Journeymap.getLogger().warn(String.format("@Config on %s.%s defaultValue is out of range", instance.getClass().getSimpleName(), field.getName()));
            }
            AtomicInteger property = (AtomicInteger)field.get(instance);
            int value = property.get();
            int okValue = Math.max((int)config.minValue(), Math.min((int)config.maxValue(), value));
            if (okValue != value) {
                if (defaultValueUsable) {
                    okValue = defaultValue;
                }
                ConfigValidation.warnPropertyValue(config, field, value, okValue);
                property.set(okValue);
                saveNeeded = true;
            }
        }
        return saveNeeded;
    }

    private static boolean validateString(Config config, Field field, PropertiesBase instance) throws Exception {
        boolean saveNeeded = false;
        AtomicReference property = (AtomicReference)field.get(instance);
        StringListProvider slp = config.stringListProvider().newInstance();
        if (!slp.getStrings().contains(slp.getDefaultString())) {
            Journeymap.getLogger().warn(String.format("@Config on %s.%s has an invalid default String: %s", instance.getClass().getSimpleName(), field.getName(), slp.getDefaultString()));
        }
        String value = (String)property.get();
        if (!slp.getStrings().contains(value)) {
            String okValue = slp.getDefaultString();
            ConfigValidation.warnPropertyValue(config, field, value, okValue);
            property.set(okValue);
            saveNeeded = true;
        }
        return saveNeeded;
    }

    private static boolean validateEnum(Config config, Field field, PropertiesBase instance) throws Exception {
        boolean saveNeeded = false;
        AtomicReference property = (AtomicReference)field.get(instance);
        Enum enumValue = (Enum)property.get();
        Class<?> enumClass = ((Enum)property.get()).getClass();
        ArrayList enumSet = new ArrayList(EnumSet.allOf(enumClass));
        Enum defaultValue = null;
        try {
            defaultValue = (Enum)Enum.valueOf(enumClass, config.defaultEnum());
        }
        catch (Exception e) {
            defaultValue = (Enum)enumSet.iterator().next();
            Journeymap.getLogger().warn(String.format("@Config on %s.%s has an invalid default Enum: %s", instance.getClass().getSimpleName(), field.getName(), config.defaultEnum()));
        }
        Enum value = (Enum)property.get();
        if (value == null || !enumSet.contains(value)) {
            Enum okValue = defaultValue;
            ConfigValidation.warnPropertyValue(config, field, value, okValue);
            property.set(okValue);
            saveNeeded = true;
        }
        return saveNeeded;
    }

    private static void warnPropertyValue(Config config, Field field, Object oldValue, Object newValue) {
        Journeymap.getLogger().warn(String.format("Property %s.%s invalid: %s . Changing to: %s", field.getDeclaringClass().getSimpleName(), field.getName(), oldValue, newValue));
    }

    public static String getName(Config annotation) {
        return Constants.getString(annotation.key());
    }

    public static String getTooltip(Config annotation) {
        String tooltip;
        String tooltipKey = annotation.key() + ".tooltip";
        if (tooltipKey.equals(tooltip = Constants.getString(tooltipKey))) {
            tooltip = null;
        }
        return tooltip;
    }
}

