/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.FoliageColorHandler;
import twilightforest.TFMagicMapData;
import twilightforest.entity.TFEntities;
import twilightforest.entity.TFPart;
import twilightforest.item.TFItems;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateTFMultipartPacket;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.registration.TFGenerationSettings;
import twilightforest.world.registration.TwilightFeatures;

public class ASMHooks {
    public static long seed(long seed) {
        TwilightFeatures.seed = seed;
        return seed;
    }

    public static Dynamic<Tag> seed(Dynamic<Tag> seed) {
        TwilightFeatures.seed = ((CompoundTag)seed.getValue()).m_128454_("seed");
        return seed;
    }

    public static void mapRenderContext(PoseStack stack, MultiBufferSource buffer, int light) {
        TFMagicMapData.TFMapDecoration.RenderContext.stack = stack;
        TFMagicMapData.TFMapDecoration.RenderContext.buffer = buffer;
        TFMagicMapData.TFMapDecoration.RenderContext.light = light;
    }

    private static boolean isOurMap(ItemStack stack) {
        return stack.m_150930_((Item)TFItems.FILLED_MAGIC_MAP.get()) || stack.m_150930_((Item)TFItems.FILLED_MAZE_MAP.get()) || stack.m_150930_((Item)TFItems.FILLED_ORE_MAP.get());
    }

    public static boolean shouldMapRender(boolean o, ItemStack stack) {
        return o || ASMHooks.isOurMap(stack);
    }

    @Nullable
    public static MapItemSavedData renderMapData(@Nullable MapItemSavedData o, ItemStack stack, @Nullable Level level) {
        return o == null && ASMHooks.isOurMap(stack) ? (level == null ? null : MapItem.m_42853_((ItemStack)stack, (Level)level)) : o;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Music music(Music music) {
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null && (music == Musics.f_11646_ || music == Musics.f_11650_) && TFGenerationSettings.isTwilightWorldOnClient((Level)Minecraft.m_91087_().f_91073_)) {
            return ((Biome)Minecraft.m_91087_().f_91073_.m_7062_().m_204216_(Minecraft.m_91087_().f_91074_.m_142538_()).m_203334_()).m_47566_().orElse(Musics.f_11651_);
        }
        return music;
    }

    public static Entity updateMultiparts(Entity entity) {
        if (entity.isMultipartEntity()) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new UpdateTFMultipartPacket(entity));
        }
        return entity;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static EntityRenderer<?> getMultipartRenderer(@Nullable EntityRenderer<?> renderer, Entity entity) {
        if (entity instanceof TFPart) {
            return TFEntities.BakedMultiPartRenderers.lookup(((TFPart)entity).renderer());
        }
        return renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static EntityRendererProvider.Context bakeMultipartRenders(EntityRendererProvider.Context context) {
        TFEntities.BakedMultiPartRenderers.bakeMultiPartRenderers(context);
        return context;
    }

    public static Iterable<Entity> renderMutiparts(Iterable<Entity> iter) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        iter.forEach(entity -> {
            list.add((Entity)entity);
            if (entity.isMultipartEntity() && entity.getParts() != null) {
                for (PartEntity part : entity.getParts()) {
                    if (!(part instanceof TFPart)) continue;
                    list.add((Entity)part);
                }
            }
        });
        return list;
    }

    public static int foliage(int o, Biome biome, double x, double z) {
        return FoliageColorHandler.get(o, biome, x, z);
    }

    public static StructureStart conquered(StructureStart start, CompoundTag nbt) {
        if (start instanceof TFStructureStart) {
            TFStructureStart s = (TFStructureStart)start;
            s.load(nbt);
        }
        return start;
    }

    public static boolean mountFix(boolean o, boolean wantsToStopRiding, boolean isPassenger) {
        if (wantsToStopRiding && isPassenger) {
            return false;
        }
        return o;
    }
}

