/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import twilightforest.world.components.feature.BlockSpikeFeature;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IMCHandler {
    private static final ImmutableList.Builder<BlockState> ORE_BLOCKS_BUILDER = ImmutableList.builder();
    private static final ImmutableList.Builder<ItemStack> LOADING_ICONS_BUILDER = ImmutableList.builder();
    private static final ImmutableMultimap.Builder<BlockState, BlockState> CRUMBLE_BLOCKS_BUILDER = ImmutableMultimap.builder();
    private static final ImmutableMultimap.Builder<Integer, BlockSpikeFeature.StalactiteEntry> STALACTITE_BUILDER = ImmutableMultimap.builder();

    @SubscribeEvent
    public static void onIMC(InterModProcessEvent event) {
        InterModComms.getMessages((String)"twilightforest").forEach(message -> {
            Object thing = message.getMessageSupplier().get();
            if (thing instanceof CompoundTag) {
                CompoundTag imcCompound = (CompoundTag)thing;
                IMCHandler.readFromTagList(imcCompound.m_128437_("Ore_Blocks", 10), IMCHandler::handleOre);
                IMCHandler.readFromTagList(imcCompound.m_128437_("Crumbling", 10), IMCHandler::handleCrumble);
            }
            if (thing instanceof ItemStack && message.getMethod().equals("Loading_Icon")) {
                LOADING_ICONS_BUILDER.add((Object)((ItemStack)thing));
            }
        });
    }

    private static void readFromTagList(ListTag list, Consumer<CompoundTag> consumer) {
        for (int i = 0; i < list.size(); ++i) {
            consumer.accept(list.m_128728_(i));
        }
    }

    private static void readStatesFromTagList(ListTag list, Consumer<BlockState> consumer) {
        for (int i = 0; i < list.size(); ++i) {
            BlockState state = NbtUtils.m_129241_((CompoundTag)list.m_128728_(i));
            if (state.m_60734_() == Blocks.f_50016_) continue;
            consumer.accept(state);
        }
    }

    private static void handleCrumble(CompoundTag nbt) {
        BlockState key = NbtUtils.m_129241_((CompoundTag)nbt);
        if (key.m_60734_() != Blocks.f_50016_) {
            IMCHandler.readStatesFromTagList(nbt.m_128437_("Crumbling", 10), value -> CRUMBLE_BLOCKS_BUILDER.put((Object)key, value));
        }
    }

    private static void handleOre(CompoundTag nbt) {
        BlockState nbtState = NbtUtils.m_129241_((CompoundTag)nbt);
        if (nbtState.m_60734_() != Blocks.f_50016_) {
            ORE_BLOCKS_BUILDER.add((Object)nbtState);
            if (nbt.m_128425_("Stalactite_Settings", 10)) {
                CompoundTag settings = nbt.m_128469_("Stalactite_Settings");
                int weight = IMCHandler.readInt(settings, "Weight", 15);
                int hillSize = IMCHandler.readInt(settings, "Hill_Size", 3);
                float size = IMCHandler.readFloat(settings, "Size", 0.7f);
                int maxLength = IMCHandler.readInt(settings, "Max_Length", 8);
                int minHeight = IMCHandler.readInt(settings, "Min_Height", 1);
                STALACTITE_BUILDER.put((Object)hillSize, (Object)new BlockSpikeFeature.StalactiteEntry(nbtState, size, maxLength, weight));
            }
        }
    }

    private static int readInt(CompoundTag tag, String key, int defaultValue) {
        return tag.m_128425_(key, 99) ? tag.m_128451_(key) : defaultValue;
    }

    private static float readFloat(CompoundTag tag, String key, float defaultValue) {
        return tag.m_128425_(key, 99) ? tag.m_128457_(key) : defaultValue;
    }

    public static ImmutableList<ItemStack> getLoadingIconStacks() {
        return LOADING_ICONS_BUILDER.build();
    }

    public static ImmutableMultimap<Integer, BlockSpikeFeature.StalactiteEntry> getStalactites() {
        return STALACTITE_BUILDER.build();
    }
}

