/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import twilightforest.TFSounds;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.block.entity.TrophyBlockEntity;
import twilightforest.client.particle.TFParticleType;
import twilightforest.enums.BossVariant;
import twilightforest.item.TFItems;

public abstract class AbstractTrophyBlock
extends BaseEntityBlock {
    private final BossVariant variant;
    private final int comparatorValue;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected AbstractTrophyBlock(BossVariant variant, int value, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = variant;
        this.comparatorValue = value;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public int getComparatorValue() {
        return this.comparatorValue;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.f_46443_ && (flag = worldIn.m_46753_(pos)) != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag) {
                this.playSound(worldIn, pos);
            }
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        this.playSound(worldIn, pos);
        this.createParticle(worldIn, pos);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AbstractTrophyBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.TROPHY.get()), TrophyBlockEntity::tick);
    }

    public BossVariant getVariant() {
        return this.variant;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void playSound(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!world.f_46443_ && te instanceof TrophyBlockEntity) {
            SoundEvent sound = null;
            float volume = 1.0f;
            float pitch = 0.9f;
            switch (this.variant) {
                case NAGA: {
                    sound = TFSounds.NAGA_RATTLE;
                    volume = 1.25f;
                    pitch = 1.2f;
                    break;
                }
                case LICH: {
                    sound = TFSounds.LICH_AMBIENT;
                    volume = 0.35f;
                    pitch = 1.1f;
                    break;
                }
                case HYDRA: {
                    sound = TFSounds.HYDRA_GROWL;
                    pitch = 1.2f;
                    break;
                }
                case UR_GHAST: {
                    sound = TFSounds.URGHAST_AMBIENT;
                    pitch = 0.6f;
                    break;
                }
                case SNOW_QUEEN: {
                    sound = TFSounds.SNOW_QUEEN_AMBIENT;
                    break;
                }
                case KNIGHT_PHANTOM: {
                    sound = TFSounds.PHANTOM_AMBIENT;
                    pitch = 1.1f;
                    break;
                }
                case MINOSHROOM: {
                    sound = TFSounds.MINOSHROOM_AMBIENT;
                    volume = 0.75f;
                    pitch = 0.7f;
                    break;
                }
                case ALPHA_YETI: {
                    sound = world.f_46441_.nextInt(50) == 0 ? TFSounds.ALPHAYETI_ROAR : TFSounds.ALPHAYETI_GROWL;
                    volume = 0.75f;
                    pitch = 0.75f;
                    break;
                }
                case QUEST_RAM: {
                    sound = TFSounds.QUEST_RAM_AMBIENT;
                    pitch = 0.7f;
                    break;
                }
            }
            if (sound != null) {
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, volume, world.f_46441_.nextFloat() * 0.1f + pitch);
            }
        }
    }

    public void createParticle(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TrophyBlockEntity) {
            Random rand = world.m_5822_();
            if (world instanceof ServerLevel) {
                switch (this.variant) {
                    case NAGA: {
                        for (int daze = 0; daze < 10; ++daze) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + (double)rand.nextFloat() * 0.5 * 2.0, 1, 0.0, 0.0, 0.0, rand.nextGaussian() * 0.02);
                        }
                        break;
                    }
                    case LICH: {
                        for (int a = 0; a < 5; ++a) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.m_123342_() + 0.5 + (double)rand.nextFloat() * 0.25, (double)pos.m_123343_() + (double)rand.nextFloat() * 0.5 * 2.0, 1, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, 0.0);
                        }
                        break;
                    }
                    case MINOSHROOM: {
                        for (int g = 0; g < 10; ++g) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, world.m_8055_(pos.m_7495_())), (double)pos.m_123341_() + (double)(rand.nextFloat() * 10.0f) - 5.0, (double)pos.m_123342_() + (double)0.1f + (double)(rand.nextFloat() * 0.3f), (double)pos.m_123343_() + (double)(rand.nextFloat() * 10.0f) - 5.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case KNIGHT_PHANTOM: {
                        for (int brek = 0; brek < 10; ++brek) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SWORD.get())), (double)pos.m_123341_() + 0.5 + ((double)rand.nextFloat() - 0.5), (double)((float)pos.m_123342_() + rand.nextFloat()) + 0.5, (double)pos.m_123343_() + 0.5 + ((double)rand.nextFloat() - 0.5), 1, 0.0, 0.25, 0.0, 0.0);
                        }
                        break;
                    }
                    case UR_GHAST: {
                        for (int red = 0; red < 10; ++red) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + rand.nextDouble() * 1.0 - 0.25, (double)pos.m_123342_() + rand.nextDouble() * 0.5 + 0.5, (double)pos.m_123343_() + rand.nextDouble() * 1.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case ALPHA_YETI: {
                        for (int sweat = 0; sweat < 10; ++sweat) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + rand.nextDouble() * 1.0 - 0.25, (double)pos.m_123342_() + rand.nextDouble() * 0.5 + 0.5, (double)pos.m_123343_() + rand.nextDouble() * 1.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case SNOW_QUEEN: {
                        for (int b = 0; b < 20; ++b) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)((SimpleParticleType)TFParticleType.SNOW_WARNING.get()), (double)pos.m_123341_() - 1.0 + rand.nextDouble() * 3.25, (double)pos.m_123342_() + 5.0, (double)pos.m_123343_() - 1.0 + rand.nextDouble() * 3.25, 1, 0.0, 1.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case QUEST_RAM: {
                        for (int p = 0; p < 10; ++p) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + (rand.nextDouble() - 0.5), (double)pos.m_123342_() + (rand.nextDouble() - 0.5), (double)pos.m_123343_() + 0.5 + (rand.nextDouble() - 0.5), 1, (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat(), 1.0);
                        }
                        break;
                    }
                }
            }
        }
    }
}

