/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.enums.BanisterShape;

public class BanisterBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<BanisterShape> SHAPE = EnumProperty.m_61587_((String)"shape", BanisterShape.class);
    public static final BooleanProperty EXTENDED = BooleanProperty.m_61465_((String)"extended");
    private static final VoxelShape NORTH_SUPPORTS_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.5, (double)0.0, (double)0.0, (double)5.5, (double)16.0, (double)3.0), (VoxelShape)Block.m_49796_((double)10.5, (double)0.0, (double)0.0, (double)13.5, (double)16.0, (double)3.0));
    private static final VoxelShape EAST_SUPPORTS_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)2.5, (double)16.0, (double)16.0, (double)5.5), (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)10.5, (double)16.0, (double)16.0, (double)13.5));
    private static final VoxelShape SOUTH_SUPPORTS_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.5, (double)0.0, (double)13.0, (double)5.5, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)10.5, (double)0.0, (double)13.0, (double)13.5, (double)16.0, (double)16.0));
    private static final VoxelShape WEST_SUPPORTS_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.5, (double)3.0, (double)16.0, (double)5.5), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)10.5, (double)3.0, (double)16.0, (double)13.5));
    private static final VoxelShape NORTH_SUPPORTS_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.5, (double)0.0, (double)0.0, (double)5.5, (double)4.0, (double)3.0), (VoxelShape)Block.m_49796_((double)10.5, (double)0.0, (double)0.0, (double)13.5, (double)4.0, (double)3.0));
    private static final VoxelShape EAST_SUPPORTS_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)2.5, (double)16.0, (double)4.0, (double)5.5), (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)10.5, (double)16.0, (double)4.0, (double)13.5));
    private static final VoxelShape SOUTH_SUPPORTS_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.5, (double)0.0, (double)13.0, (double)5.5, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)10.5, (double)0.0, (double)13.0, (double)13.5, (double)4.0, (double)16.0));
    private static final VoxelShape WEST_SUPPORTS_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.5, (double)3.0, (double)4.0, (double)5.5), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)10.5, (double)3.0, (double)4.0, (double)13.5));
    private static final VoxelShape NORTH_EXTENSION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.5, (double)-8.0, (double)0.0, (double)5.5, (double)0.0, (double)3.0), (VoxelShape)Block.m_49796_((double)10.5, (double)-8.0, (double)0.0, (double)13.5, (double)0.0, (double)3.0));
    private static final VoxelShape EAST_EXTENSION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)-8.0, (double)2.5, (double)16.0, (double)0.0, (double)5.5), (VoxelShape)Block.m_49796_((double)13.0, (double)-8.0, (double)10.5, (double)16.0, (double)0.0, (double)13.5));
    private static final VoxelShape SOUTH_EXTENSION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.5, (double)-8.0, (double)13.0, (double)5.5, (double)0.0, (double)16.0), (VoxelShape)Block.m_49796_((double)10.5, (double)-8.0, (double)13.0, (double)13.5, (double)0.0, (double)16.0));
    private static final VoxelShape WEST_EXTENSION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)-8.0, (double)2.5, (double)3.0, (double)0.0, (double)5.5), (VoxelShape)Block.m_49796_((double)0.0, (double)-8.0, (double)10.5, (double)3.0, (double)0.0, (double)13.5));
    private static final VoxelShape NORTH_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)NORTH_SUPPORTS_TALL);
    private static final VoxelShape EAST_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)EAST_SUPPORTS_TALL);
    private static final VoxelShape SOUTH_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)SOUTH_SUPPORTS_TALL);
    private static final VoxelShape WEST_TALL = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)WEST_SUPPORTS_TALL);
    private static final VoxelShape NORTH_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), (VoxelShape)NORTH_SUPPORTS_SHORT);
    private static final VoxelShape EAST_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)EAST_SUPPORTS_SHORT);
    private static final VoxelShape SOUTH_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)SOUTH_SUPPORTS_SHORT);
    private static final VoxelShape WEST_SHORT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0), (VoxelShape)WEST_SUPPORTS_SHORT);
    private static final VoxelShape NORTH_TALL_EXTENDED = Shapes.m_83110_((VoxelShape)NORTH_TALL, (VoxelShape)NORTH_EXTENSION);
    private static final VoxelShape EAST_TALL_EXTENDED = Shapes.m_83110_((VoxelShape)EAST_TALL, (VoxelShape)EAST_EXTENSION);
    private static final VoxelShape SOUTH_TALL_EXTENDED = Shapes.m_83110_((VoxelShape)SOUTH_TALL, (VoxelShape)SOUTH_EXTENSION);
    private static final VoxelShape WEST_TALL_EXTENDED = Shapes.m_83110_((VoxelShape)WEST_TALL, (VoxelShape)WEST_EXTENSION);
    private static final VoxelShape NORTH_SHORT_EXTENDED = Shapes.m_83110_((VoxelShape)NORTH_SHORT, (VoxelShape)NORTH_EXTENSION);
    private static final VoxelShape EAST_SHORT_EXTENDED = Shapes.m_83110_((VoxelShape)EAST_SHORT, (VoxelShape)EAST_EXTENSION);
    private static final VoxelShape SOUTH_SHORT_EXTENDED = Shapes.m_83110_((VoxelShape)SOUTH_SHORT, (VoxelShape)SOUTH_EXTENSION);
    private static final VoxelShape WEST_SHORT_EXTENDED = Shapes.m_83110_((VoxelShape)WEST_SHORT, (VoxelShape)WEST_EXTENSION);
    private static final VoxelShape NORTH_CONNECTED_EXTENDED = Shapes.m_83110_((VoxelShape)NORTH_SUPPORTS_TALL, (VoxelShape)NORTH_EXTENSION);
    private static final VoxelShape EAST_CONNECTED_EXTENDED = Shapes.m_83110_((VoxelShape)EAST_SUPPORTS_TALL, (VoxelShape)EAST_EXTENSION);
    private static final VoxelShape SOUTH_CONNECTED_EXTENDED = Shapes.m_83110_((VoxelShape)SOUTH_SUPPORTS_TALL, (VoxelShape)SOUTH_EXTENSION);
    private static final VoxelShape WEST_CONNECTED_EXTENDED = Shapes.m_83110_((VoxelShape)WEST_SUPPORTS_TALL, (VoxelShape)WEST_EXTENSION);

    public BanisterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)((Object)BanisterShape.TALL))).m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_())).m_61124_(SHAPE, (Comparable)((Object)(context.m_43725_().m_8055_(pos.m_7494_()).m_204336_(BlockTagGenerator.BANISTERS) ? BanisterShape.CONNECTED : BanisterShape.TALL)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        boolean extended = (Boolean)state.m_61143_((Property)EXTENDED);
        return switch ((BanisterShape)((Object)state.m_61143_(SHAPE))) {
            default -> throw new IncompatibleClassChangeError();
            case BanisterShape.SHORT -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        if (extended) {
                            yield NORTH_SHORT_EXTENDED;
                        }
                        yield NORTH_SHORT;
                    }
                    case WEST: {
                        if (extended) {
                            yield WEST_SHORT_EXTENDED;
                        }
                        yield WEST_SHORT;
                    }
                    case EAST: {
                        if (extended) {
                            yield EAST_SHORT_EXTENDED;
                        }
                        yield EAST_SHORT;
                    }
                }
                if (extended) {
                    yield SOUTH_SHORT_EXTENDED;
                }
                yield SOUTH_SHORT;
            }
            case BanisterShape.CONNECTED -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        if (extended) {
                            yield NORTH_CONNECTED_EXTENDED;
                        }
                        yield NORTH_SUPPORTS_TALL;
                    }
                    case WEST: {
                        if (extended) {
                            yield WEST_CONNECTED_EXTENDED;
                        }
                        yield WEST_SUPPORTS_TALL;
                    }
                    case EAST: {
                        if (extended) {
                            yield EAST_CONNECTED_EXTENDED;
                        }
                        yield EAST_SUPPORTS_TALL;
                    }
                }
                if (extended) {
                    yield SOUTH_CONNECTED_EXTENDED;
                }
                yield SOUTH_SUPPORTS_TALL;
            }
            case BanisterShape.TALL -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        if (extended) {
                            yield NORTH_TALL_EXTENDED;
                        }
                        yield NORTH_TALL;
                    }
                    case WEST: {
                        if (extended) {
                            yield WEST_TALL_EXTENDED;
                        }
                        yield WEST_TALL;
                    }
                    case EAST: {
                        if (extended) {
                            yield EAST_TALL_EXTENDED;
                        }
                        yield EAST_TALL;
                    }
                }
                yield extended ? SOUTH_TALL_EXTENDED : SOUTH_TALL;
            }
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("block.twilightforest.banister.cycle").m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.BLOCKED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{SHAPE, EXTENDED, f_54117_, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack held = player.m_21120_(hand);
        if (held.canPerformAction(ToolActions.AXE_WAX_OFF)) {
            BlockState newState = (BlockState)state.m_61122_(SHAPE);
            level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, newState.m_61143_(SHAPE) == BanisterShape.TALL ? (BlockState)newState.m_61122_((Property)EXTENDED) : newState, 3);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }
}

