/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;

public class GiantBlock
extends Block {
    private boolean isSelfDestructing;

    public GiantBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        for (BlockPos dPos : GiantBlock.getVolume(ctx.m_8083_())) {
            if (ctx.m_43725_().m_8055_(dPos).m_60629_(ctx)) continue;
            return null;
        }
        return this.m_49966_();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.f_46443_) {
            for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                world.m_46597_(dPos, this.m_49966_());
            }
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (!this.isSelfDestructing && !this.isVolumeFilled(world, pos)) {
            this.setGiantBlockToAir(world, pos);
        }
    }

    private void setGiantBlockToAir(Level world, BlockPos pos) {
        this.isSelfDestructing = true;
        for (BlockPos iterPos : GiantBlock.getVolume(pos)) {
            if (pos.equals((Object)iterPos) || world.m_8055_(iterPos).m_60734_() != this) continue;
            world.m_46961_(iterPos, false);
        }
        this.isSelfDestructing = false;
    }

    private boolean isVolumeFilled(Level world, BlockPos pos) {
        for (BlockPos dPos : GiantBlock.getVolume(pos)) {
            if (world.m_8055_(dPos).m_60734_() == this) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public static Iterable<BlockPos> getVolume(BlockPos pos) {
        return BlockPos.m_121976_((int)(pos.m_123341_() & 0xFFFFFFFC), (int)(pos.m_123342_() & 0xFFFFFFFC), (int)(pos.m_123343_() & 0xFFFFFFFC), (int)(pos.m_123341_() | 3), (int)(pos.m_123342_() | 3), (int)(pos.m_123343_() | 3));
    }
}

