/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.entity.boss.Lich;

public class LichModel
extends HumanoidModel<Lich> {
    private boolean shadowClone;
    private final ModelPart collar;
    private final ModelPart cloak;

    public LichModel(ModelPart root) {
        super(root);
        this.collar = root.m_171324_("collar");
        this.cloak = root.m_171324_("cloak");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partRoot = mesh.m_171576_();
        partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        partRoot.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        partRoot.m_171599_("collar", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171481_(-6.0f, -2.0f, -4.0f, 12.0f, 12.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-1.0f, (float)2.164208f, (float)0.0f, (float)0.0f));
        partRoot.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171481_(-6.0f, 2.0f, 0.0f, 12.0f, 19.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)2.5f));
        partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(8, 16).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 24.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        partRoot.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.0f, -2.0f, -2.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)-5.0f, (float)-2.0f, (float)0.0f));
        partRoot.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 16).m_171481_(-1.0f, -2.0f, -2.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partRoot.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partRoot.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.shadowClone) {
            super.m_7695_(stack, builder, light, overlay, red, green, blue, alpha);
        } else {
            float shadow = 0.33f;
            super.m_7695_(stack, builder, light, overlay, red * shadow, green * shadow, blue * shadow, 0.8f);
        }
    }

    protected Iterable<ModelPart> m_5608_() {
        if (this.shadowClone) {
            return super.m_5608_();
        }
        return Iterables.concat(Arrays.asList(this.cloak, this.collar), (Iterable)super.m_5608_());
    }

    public void setupAnim(Lich entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.shadowClone = entity.isShadowClone();
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float ogSin = Mth.m_14031_((float)(this.f_102608_ * 3.141593f));
        float otherSin = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * 3.141593f));
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.5f;
        this.f_102811_.f_104204_ = -(0.1f - ogSin * 0.6f);
        this.f_102812_.f_104204_ = 0.1f - ogSin * 0.6f;
        this.f_102811_.f_104203_ = -1.570796f;
        this.f_102812_.f_104203_ = -3.141593f;
        this.f_102811_.f_104203_ -= ogSin * 1.2f - otherSin * 0.4f;
        this.f_102812_.f_104203_ -= ogSin * 1.2f - otherSin * 0.4f;
        this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.26f)) * 0.15f + 0.05f;
        this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.26f)) * 0.15f + 0.05f;
        this.f_102811_.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.167f)) * 0.15f;
        this.f_102812_.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.167f)) * 0.15f;
        this.f_102808_.f_104201_ = -4.0f;
        this.f_102809_.f_104201_ = -4.0f;
    }
}

