/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import twilightforest.entity.SlideBlock;

public class SlideBlockRenderer
extends EntityRenderer<SlideBlock> {
    public SlideBlockRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.f_114477_ = 0.0f;
    }

    public void render(SlideBlock entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        Level world;
        BlockState blockstate;
        if (entity.getBlockState() != null && (blockstate = entity.getBlockState()).m_60799_() == RenderShape.MODEL && blockstate != (world = entity.f_19853_).m_8055_(entity.m_142538_()) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
            stack.m_85836_();
            BlockPos blockpos = new BlockPos(entity.m_20185_(), entity.m_142469_().f_82292_, entity.m_20189_());
            if (blockstate.m_61147_().contains(RotatedPillarBlock.f_55923_)) {
                Direction.Axis axis = (Direction.Axis)blockstate.m_61143_((Property)RotatedPillarBlock.f_55923_);
                float angle = ((float)entity.f_19797_ + partialTicks) * 60.0f;
                stack.m_85837_(0.0, 0.5, 0.0);
                if (axis == Direction.Axis.Y) {
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
                } else if (axis == Direction.Axis.X) {
                    stack.m_85845_(Vector3f.f_122223_.m_122240_(angle));
                } else if (axis == Direction.Axis.Z) {
                    stack.m_85845_(Vector3f.f_122227_.m_122240_(angle));
                }
                stack.m_85837_(-0.5, -0.5, -0.5);
            }
            BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)blockstate, (RenderType)type)) continue;
                ForgeHooksClient.setRenderType((RenderType)type);
                blockrendererdispatcher.m_110937_().m_111047_((BlockAndTintGetter)world, blockrendererdispatcher.m_110910_(blockstate), blockstate, blockpos, stack, buffer.m_6299_(type), false, new Random(), blockstate.m_60726_(blockpos), OverlayTexture.f_118083_);
            }
            ForgeHooksClient.setRenderType(null);
            stack.m_85849_();
            super.m_7392_((Entity)entity, yaw, partialTicks, stack, buffer, light);
        }
    }

    public ResourceLocation getTextureLocation(SlideBlock entity) {
        return TextureAtlas.f_118259_;
    }
}

