/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.shader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import org.lwjgl.opengl.ARBShaderObjects;
import twilightforest.TwilightForestMod;
import twilightforest.client.TFClientEvents;
import twilightforest.client.shader.ShaderUniform;

public final class ShaderManager {
    private static ReloadableResourceManager shaderReloadListener;
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    private static final String PREFIX = "/assets/twilightforest/shaders/";
    public static int enderPortalShader;
    public static int twilightSkyShader;
    public static int fireflyShader;
    public static int auroraShader;
    public static int carminiteShader;
    public static int towerDeviceShader;
    public static int yellowCircuitShader;
    public static int bloomShader;
    public static int starburstShader;
    public static int shieldShader;
    public static int outlineShader;

    public static void initShaders() {
        ResourceManager iManager = Minecraft.m_91087_().m_91098_();
        if (iManager instanceof ReloadableResourceManager) {
            // empty if block
        }
    }

    public static ReloadableResourceManager getShaderReloadListener() {
        return shaderReloadListener;
    }

    private static void reloadShaders() {
        ShaderManager.deleteProgram(twilightSkyShader);
        ShaderManager.deleteProgram(fireflyShader);
        ShaderManager.deleteProgram(auroraShader);
        ShaderManager.deleteProgram(carminiteShader);
        ShaderManager.deleteProgram(towerDeviceShader);
        ShaderManager.deleteProgram(yellowCircuitShader);
        ShaderManager.deleteProgram(starburstShader);
        ShaderManager.initShaderList();
    }

    private static void deleteProgram(int id) {
        if (id != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)id);
        }
    }

    private static void initShaderList() {
        twilightSkyShader = ShaderManager.createProgram("standard_texcoord.vert", "twilight_sky.frag");
        fireflyShader = ShaderManager.createProgram("standard_texcoord2.vert", "firefly.frag");
        auroraShader = ShaderManager.createProgram("standard_texcoord2.vert", "aurora.frag");
        carminiteShader = ShaderManager.createProgram("camera_fixed.vert", "spiral.frag");
        towerDeviceShader = ShaderManager.createProgram("camera_fixed.vert", "pulsing.frag");
        yellowCircuitShader = ShaderManager.createProgram("standard_texcoord2.vert", "pulsing_yellow.frag");
        starburstShader = ShaderManager.createProgram("standard_texcoord2.vert", "starburst.frag");
        shieldShader = ShaderManager.createProgram("standard_texcoord2.vert", "shield.frag");
    }

    public static void useShader(int shader, @Nullable IntConsumer callback) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0 && callback != null) {
            callback.accept(shader);
        }
    }

    public static void useShader(int shader, ShaderUniform uniform) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            uniform.assignUniform(shader);
        }
    }

    public static void useShader(int shader, ShaderUniform ... uniforms) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            for (ShaderUniform uniform : uniforms) {
                uniform.assignUniform(shader);
            }
        }
    }

    public static void useShader(int shader) {
        if (!ShaderManager.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
    }

    public static void releaseShader() {
        ShaderManager.useShader(0);
    }

    public static boolean useShaders() {
        return true;
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderManager.createShader(PREFIX + vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderManager.createShader(PREFIX + frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            TwilightForestMod.LOGGER.error("Failed to create shader! (LINK) {} {}", (Object)vert, (Object)frag);
            TwilightForestMod.LOGGER.error(ShaderManager.getInfoLog(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            TwilightForestMod.LOGGER.error("Failed to create shader! (VALIDATE) {} {}", (Object)vert, (Object)frag);
            TwilightForestMod.LOGGER.error(ShaderManager.getInfoLog(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderManager.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                TwilightForestMod.LOGGER.error("Failed to create shader! (COMPILE) {}", (Object)filename);
                throw new RuntimeException("Error creating shader: " + ShaderManager.getInfoLog(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String path) throws Exception {
        StringBuilder source;
        block28: {
            source = new StringBuilder();
            InputStream in = ShaderManager.class.getResourceAsStream(path);
            Exception exception = null;
            if (in == null) {
                return "";
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        if (innerExc == null) {
                            innerExc = exc;
                        }
                        exc.printStackTrace();
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block28;
                throw exception;
            }
        }
        return source.toString();
    }

    private static String getInfoLog(int program) {
        return ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716));
    }

    static void glUniform2i(int location, int v0, int v1) {
        ARBShaderObjects.glUniform2iARB((int)location, (int)v0, (int)v1);
    }

    static void glUniform1f(int location, float v0) {
        ARBShaderObjects.glUniform1fARB((int)location, (float)v0);
    }

    static void glUniform2f(int location, float v0, float v1) {
        ARBShaderObjects.glUniform2fARB((int)location, (float)v0, (float)v1);
    }

    public static final class Uniforms {
        public static final ShaderUniform TIME = ShaderUniform.create("time", () -> (float)TFClientEvents.time + Minecraft.m_91087_().m_91296_());
        public static final ShaderUniform YAW = ShaderUniform.create("yaw", () -> Minecraft.m_91087_().f_91074_.m_146908_() * 2.0f * (float)Math.PI / 360.0f);
        public static final ShaderUniform PITCH = ShaderUniform.create("pitch", () -> -(Minecraft.m_91087_().f_91074_.m_146909_() * 2.0f * (float)Math.PI) / 360.0f);
        public static final ShaderUniform RESOLUTION = ShaderUniform.create("resolution", () -> Minecraft.m_91087_().m_91268_().m_85443_(), () -> Minecraft.m_91087_().m_91268_().m_85444_());
        public static final ShaderUniform ZERO = ShaderUniform.create("zero", 0);
        public static final ShaderUniform ONE = ShaderUniform.create("one", 1);
        public static final ShaderUniform TWO = ShaderUniform.create("two", 2);
        public static final ShaderUniform[] STAR_UNIFORMS = new ShaderUniform[]{TIME, YAW, PITCH, RESOLUTION, ZERO, TWO};
        public static final ShaderUniform[] TIME_UNIFORM = new ShaderUniform[]{TIME};
    }
}

