/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.chunkgenerators.warp.TerrainPoint;
import twilightforest.world.registration.TFGenerationSettings;
import twilightforest.world.registration.TFNoiseGenerationSettings;
import twilightforest.world.registration.biomes.BiomeKeys;
import twilightforest.world.registration.biomes.BiomeMaker;

public record WorldGenerator(DataGenerator generator) implements DataProvider
{
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        RegistryAccess registryaccess = BuiltinRegistries.f_206379_;
        RegistryOps dynamicops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryaccess);
        Registry<LevelStem> twilight = this.registerTFSettings(registryaccess);
        MappedRegistry biomeRegistry = new MappedRegistry(Registry.f_122885_, Lifecycle.experimental(), null);
        Map<ResourceLocation, Biome> biomes = this.getBiomes();
        biomes.forEach((arg_0, arg_1) -> WorldGenerator.lambda$run$0((WritableRegistry)biomeRegistry, arg_0, arg_1));
        StreamSupport.stream(RegistryAccess.m_194613_().spliterator(), false).filter(r -> registryaccess.m_142664_(r.f_123101_()).isPresent() && !r.f_123101_().equals((Object)Registry.f_122885_)).forEach(arg_0 -> WorldGenerator.lambda$run$2(cache, path, registryaccess, (DynamicOps)dynamicops, arg_0));
        LOGGER.info("Dumping real BIOME_REGISTRY");
        WorldGenerator.dumpRegistry(path, cache, (DynamicOps<JsonElement>)dynamicops, Registry.f_122885_, biomeRegistry, Biome.f_47429_);
        LOGGER.info("Dumping real LEVEL_STEM_REGISTRY");
        WorldGenerator.dumpRegistry(path, cache, (DynamicOps<JsonElement>)dynamicops, Registry.f_122820_, twilight, LevelStem.f_63970_);
    }

    private static <T> void dumpRegistryCap(HashCache cache, Path path, RegistryAccess access, DynamicOps<JsonElement> ops, RegistryAccess.RegistryData<T> data) {
        LOGGER.info("Dumping: {}", (Object)data.f_123101_());
        WorldGenerator.dumpRegistry(path, cache, ops, data.f_123101_(), access.m_206191_(data.f_123101_()), data.f_123102_());
    }

    private Registry<LevelStem> registerTFSettings(RegistryAccess access) {
        MappedRegistry writableregistry = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental(), null);
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Holder noiseGenSettings = access.m_175515_(Registry.f_122878_).m_203538_(TFNoiseGenerationSettings.TWILIGHT_NOISE_GEN.getKey());
        NoiseBasedChunkGenerator forestChunkGen = new NoiseBasedChunkGenerator(access.m_175515_(Registry.f_211073_), access.m_175515_(Registry.f_194568_), (BiomeSource)new TFBiomeProvider(0L, (Registry<Biome>)biomeRegistry, this.makeBiomeList((Registry<Biome>)biomeRegistry), -1.25f, 2.5f), 0L, noiseGenSettings);
        writableregistry.m_203505_(TFGenerationSettings.WORLDGEN_KEY, (Object)new LevelStem(Holder.m_205709_((Object)this.twilightDimType()), (ChunkGenerator)new ChunkGeneratorTwilight((ChunkGenerator)forestChunkGen, (Registry<StructureSet>)access.m_175515_(Registry.f_211073_), (Holder<NoiseGeneratorSettings>)noiseGenSettings, true, true, Optional.of(12), true), true), Lifecycle.experimental());
        return writableregistry;
    }

    private Registry<LevelStem> registerSkylightSettings(RegistryAccess access) {
        MappedRegistry writableregistry = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental(), null);
        MappedRegistry biomeRegistry = new MappedRegistry(Registry.f_122885_, Lifecycle.experimental(), null);
        Holder noiseGenSettings = access.m_175515_(Registry.f_122878_).m_203538_(TFNoiseGenerationSettings.SKYLIGHT_NOISE_GEN.getKey());
        NoiseBasedChunkGenerator forestChunkGen = new NoiseBasedChunkGenerator(access.m_175515_(Registry.f_211073_), access.m_175515_(Registry.f_194568_), (BiomeSource)new TFBiomeProvider(0L, (Registry<Biome>)biomeRegistry, this.makeBiomeList((Registry<Biome>)biomeRegistry), -1.25f, 2.5f), 4L, noiseGenSettings);
        writableregistry.m_203505_(ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)TwilightForestMod.prefix("skylight_forest")), (Object)new LevelStem(Holder.m_205709_((Object)this.twilightDimType()), (ChunkGenerator)new ChunkGeneratorTwilight((ChunkGenerator)forestChunkGen, (Registry<StructureSet>)access.m_175515_(Registry.f_211073_), (Holder<NoiseGeneratorSettings>)noiseGenSettings, true, true, Optional.of(12), true)), Lifecycle.stable());
        return writableregistry;
    }

    private static <E, T extends Registry<E>> void dumpRegistry(Path path, HashCache cache, DynamicOps<JsonElement> ops, ResourceKey<? extends T> key, T registry, Encoder<E> encoder) {
        for (Map.Entry entry : registry.m_6579_()) {
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("twilightforest")) continue;
            LOGGER.info("\t\t{}", (Object)((ResourceKey)entry.getKey()).m_135782_().m_135815_());
            Path otherPath = WorldGenerator.createPath(path, key.m_135782_(), ((ResourceKey)entry.getKey()).m_135782_());
            WorldGenerator.dumpValue(otherPath, cache, ops, encoder, entry.getValue());
        }
    }

    private static <E> void dumpValue(Path path, HashCache cache, DynamicOps<JsonElement> ops, Encoder<E> encoder, E entry) {
        try {
            Optional optional = encoder.encodeStart(ops, entry).resultOrPartial(p_206405_ -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, p_206405_));
            if (optional.isPresent()) {
                JsonObject object;
                if (((JsonElement)optional.get()).isJsonObject() && (object = ((JsonElement)optional.get()).getAsJsonObject()).has("generator") && object.get("generator").isJsonObject()) {
                    JsonObject wrapped_generator;
                    JsonObject generator = object.getAsJsonObject("generator");
                    if (generator.has("use_overworld_seed")) {
                        generator.remove("use_overworld_seed");
                        generator.addProperty("use_overworld_seed", Boolean.valueOf(true));
                    }
                    if (generator.has("wrapped_generator") && (wrapped_generator = generator.getAsJsonObject("wrapped_generator")).has("biome_source")) {
                        wrapped_generator.getAsJsonObject("biome_source").remove("seed");
                    }
                }
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save element {}", (Object)path, (Object)ioexception);
        }
    }

    private static Path createPath(Path path, ResourceLocation registry, ResourceLocation entry) {
        return path.resolve("data").resolve(entry.m_135827_()).resolve(registry.m_135815_()).resolve(entry.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Worldgen";
    }

    private DimensionType twilightDimType() {
        return DimensionType.m_204497_((OptionalLong)OptionalLong.of(13000L), (boolean)true, (boolean)false, (boolean)false, (boolean)true, (double)0.125, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (int)-32, (int)288, (int)288, (TagKey)BlockTags.f_13058_, (ResourceLocation)TwilightForestMod.prefix("renderer"), (float)0.0f);
    }

    private Map<ResourceLocation, Biome> getBiomes() {
        return BiomeMaker.BIOMES.entrySet().stream().peek(registryKeyBiomeEntry -> ((Biome)registryKeyBiomeEntry.getValue()).setRegistryName(((ResourceKey)registryKeyBiomeEntry.getKey()).m_135782_())).collect(Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).m_135782_(), Map.Entry::getValue));
    }

    private List<Pair<TerrainPoint, Holder<Biome>>> makeBiomeList(Registry<Biome> registry) {
        return List.of(this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.FOREST), this.pairBiome(registry, 0.1f, 0.2f, BiomeKeys.DENSE_FOREST), this.pairBiome(registry, 0.0625f, 0.05f, BiomeKeys.FIREFLY_FOREST), this.pairBiome(registry, 0.005f, 0.005f, BiomeKeys.CLEARING), this.pairBiome(registry, 0.05f, 0.1f, BiomeKeys.OAK_SAVANNAH), this.pairBiome(registry, -1.65f, 0.25f, BiomeKeys.STREAM), this.pairBiome(registry, -1.97f, 0.0f, BiomeKeys.LAKE), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.MUSHROOM_FOREST), this.pairBiome(registry, 0.05f, 0.05f, BiomeKeys.DENSE_MUSHROOM_FOREST), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.ENCHANTED_FOREST), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.SPOOKY_FOREST), this.pairBiome(registry, -0.9f, 0.15f, BiomeKeys.SWAMP), this.pairBiome(registry, -0.2f, 0.05f, BiomeKeys.FIRE_SWAMP), this.pairBiome(registry, 0.025f, 0.005f, BiomeKeys.DARK_FOREST), this.pairBiome(registry, 0.025f, 0.005f, BiomeKeys.DARK_FOREST_CENTER), this.pairBiome(registry, 0.05f, 0.15f, BiomeKeys.SNOWY_FOREST), this.pairBiome(registry, 0.025f, 0.05f, BiomeKeys.GLACIER), this.pairBiome(registry, 3.0f, 0.25f, BiomeKeys.HIGHLANDS), this.pairBiome(registry, 7.0f, 0.1f, BiomeKeys.THORNLANDS), this.pairBiome(registry, 13.75f, 0.025f, BiomeKeys.FINAL_PLATEAU));
    }

    private Pair<TerrainPoint, Holder<Biome>> pairBiome(Registry<Biome> registry, float depth, float scale, ResourceKey<Biome> key) {
        return Pair.of((Object)new TerrainPoint(depth, scale), (Object)Holder.Reference.m_205766_(registry, key));
    }

    private static /* synthetic */ void lambda$run$2(HashCache cache, Path path, RegistryAccess registryaccess, DynamicOps dynamicops, RegistryAccess.RegistryData data) {
        WorldGenerator.dumpRegistryCap(cache, path, registryaccess, (DynamicOps<JsonElement>)dynamicops, data);
    }

    private static /* synthetic */ void lambda$run$0(WritableRegistry biomeRegistry, ResourceLocation rl, Biome biome) {
        biomeRegistry.m_203505_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)rl), (Object)biome, Lifecycle.experimental());
    }
}

