/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.monster.Kobold;

public class FlockToSameKindGoal
extends Goal {
    private static final double MAX_DIST = 256.0;
    private static final double MIN_DIST = 25.0;
    private final Mob flockCreature;
    private Vec3 flockPosition;
    double speed;
    private int moveTimer;

    public FlockToSameKindGoal(Mob living, double speed) {
        this.flockCreature = living;
        this.speed = speed;
    }

    public boolean m_8036_() {
        Kobold kobold;
        Mob mob = this.flockCreature;
        if (mob instanceof Kobold && (kobold = (Kobold)mob).m_6844_(EquipmentSlot.MAINHAND).m_204117_(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
            return false;
        }
        if (this.flockCreature.m_21187_().nextInt(40) != 0) {
            return false;
        }
        List flockList = this.flockCreature.f_19853_.m_45976_(this.flockCreature.getClass(), this.flockCreature.m_142469_().m_82377_(16.0, 4.0, 16.0));
        if (flockList.size() > 5) {
            return false;
        }
        int flocknum = 0;
        double flockX = 0.0;
        double flockY = 0.0;
        double flockZ = 0.0;
        for (LivingEntity flocker : flockList) {
            ++flocknum;
            flockX += flocker.m_20185_();
            flockY += flocker.m_20186_();
            flockZ += flocker.m_20189_();
        }
        if (this.flockCreature.m_20275_(flockX /= (double)flocknum, flockY /= (double)flocknum, flockZ /= (double)flocknum) < 25.0) {
            return false;
        }
        this.flockPosition = new Vec3(flockX, flockY, flockZ);
        return true;
    }

    public boolean m_8045_() {
        if (this.flockPosition == null) {
            return false;
        }
        double distance = this.flockCreature.m_20275_(this.flockPosition.f_82479_, this.flockPosition.f_82480_, this.flockPosition.f_82481_);
        return distance >= 25.0 && distance <= 256.0;
    }

    public void m_8056_() {
        this.moveTimer = 0;
    }

    public void m_8041_() {
        this.flockPosition = null;
    }

    public void m_8037_() {
        if (--this.moveTimer <= 0) {
            this.moveTimer = 10;
            this.flockCreature.m_21573_().m_26519_(this.flockPosition.f_82479_, this.flockPosition.f_82480_, this.flockPosition.f_82481_, this.speed);
        }
    }
}

