/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraPart;

public class HydraMortarHead
extends ThrowableProjectile {
    private static final int BURN_FACTOR = 5;
    private static final int DIRECT_DAMAGE = 18;
    public int fuse = 80;
    private boolean megaBlast = false;

    public HydraMortarHead(EntityType<? extends HydraMortarHead> type, Level world) {
        super(type, world);
    }

    public HydraMortarHead(EntityType<? extends HydraMortarHead> type, Level world, HydraHead head) {
        super(type, (LivingEntity)head.getParent(), world);
        Vec3 vector = head.m_20154_();
        double dist = 3.5;
        double px = head.m_20185_() + vector.m_7096_() * dist;
        double py = head.m_20186_() + 1.0 + vector.m_7098_() * dist;
        double pz = head.m_20189_() + vector.m_7094_() * dist;
        this.m_7678_(px, py, pz, 0.0f, 0.0f);
        head.m_20256_(Vec3.f_82478_);
        this.m_37251_((Entity)head, head.m_146909_(), head.m_146908_(), -20.0f, 0.5f, 1.0f);
        TwilightForestMod.LOGGER.debug("Launching mortar! Current head motion is {}, {}", (Object)head.m_20184_().m_7096_(), (Object)head.m_20184_().m_7094_());
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_()) {
            this.m_20184_().m_82542_(0.9, 0.9, 0.9);
            if (!this.f_19853_.m_5776_() && this.fuse-- <= 0) {
                this.detonate();
            }
        }
    }

    public void setToBlasting() {
        this.megaBlast = true;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.megaBlast) {
            if (result.m_82434_() != Direction.DOWN) {
                this.detonate();
            }
            this.m_20334_(this.m_20184_().m_7096_(), 0.0, this.m_20184_().m_7094_());
            this.f_19861_ = true;
        } else {
            this.detonate();
        }
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type hitresult$type = result.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)result);
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)result);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        HydraMortarHead mortar;
        Entity entity = result.m_82443_();
        if (!(this.f_19853_.m_5776_() || this.m_37282_() == null || entity instanceof HydraMortarHead && !(mortar = (HydraMortarHead)entity).m_37282_().m_7306_(this.m_37282_()) || entity.m_7306_(this.m_37282_()) || this.isPartOfHydra(entity))) {
            this.detonate();
        }
    }

    private boolean isPartOfHydra(Entity entity) {
        HydraPart part;
        return this.m_37282_() instanceof Hydra && entity instanceof HydraPart && ((Hydra)(part = (HydraPart)entity).getParent()).m_7306_(this.m_37282_());
    }

    public float m_7077_(Explosion explosion, BlockGetter getter, BlockPos pos, BlockState state, FluidState fluid, float idk) {
        float resistance = super.m_7077_(explosion, getter, pos, state, fluid, idk);
        if (this.megaBlast && !state.m_204336_(BlockTagGenerator.COMMON_PROTECTIONS)) {
            resistance = Math.min(0.8f, resistance);
        }
        return resistance;
    }

    private void detonate() {
        float explosionPower = this.megaBlast ? 4.0f : 0.1f;
        boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.m_183503_(), (Entity)this);
        Explosion.BlockInteraction flag1 = flag ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
        this.m_183503_().m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosionPower, flag, flag1);
        DamageSource src = new IndirectEntityDamageSource("onFire", (Entity)this, this.m_37282_()).m_19383_().m_19366_();
        for (Entity nearby : this.m_183503_().m_45933_((Entity)this, this.m_142469_().m_82377_(1.0, 1.0, 1.0))) {
            if (nearby.m_5825_() && !(nearby instanceof Hydra) && !(nearby instanceof HydraPart) || !nearby.m_6469_(src, 18.0f)) continue;
            nearby.m_20254_(5);
        }
        this.m_146870_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        super.m_6469_(source, amount);
        if (source.m_7639_() != null && !this.m_183503_().m_5776_()) {
            Vec3 vec3d = source.m_7639_().m_20154_();
            if (vec3d != null) {
                this.m_6686_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.5f, 0.1f);
                this.f_19861_ = false;
                this.fuse += 20;
            }
            if (source.m_7639_() instanceof LivingEntity) {
                this.m_5602_(source.m_7639_());
            }
            return true;
        }
        return false;
    }

    public boolean m_6060_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.5f;
    }

    protected float m_7139_() {
        return 0.05f;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

