/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.TFPart;
import twilightforest.entity.boss.Hydra;

public abstract class HydraPart
extends TFPart<Hydra> {
    private static final EntityDataAccessor<Boolean> DATA_SIZEACTIVE = SynchedEntityData.m_135353_(HydraPart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    final float maxHealth = 1000.0f;
    float health = 1000.0f;
    private EntityDimensions cacheSize;

    public HydraPart(Hydra hydra) {
        super(hydra);
    }

    protected void m_8097_() {
        this.m_5825_();
        this.f_19804_.m_135372_(DATA_SIZEACTIVE, (Object)true);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (pKey == DATA_SIZEACTIVE) {
            if (((Boolean)this.f_19804_.m_135370_(DATA_SIZEACTIVE)).booleanValue()) {
                this.activate();
            } else {
                this.deactivate();
            }
        }
    }

    public boolean canEntityBeSeen(Entity entityIn) {
        Vec3 vector3d1;
        Vec3 vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1 = new Vec3(entityIn.m_20185_(), entityIn.m_20188_(), entityIn.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public HydraPart(Hydra parent, float width, float height) {
        this(parent);
        this.setSize(EntityDimensions.m_20395_((float)width, (float)height));
        this.m_6210_();
    }

    @Override
    protected void setSize(EntityDimensions size) {
        super.setSize(size);
        this.cacheSize = size;
    }

    @Override
    public void m_8119_() {
        this.m_20095_();
        super.m_8119_();
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.health <= 0.0f) {
            ++this.deathTime;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.getParent() != null && ((Hydra)this.getParent()).attackEntityFromPart(this, source, amount);
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    protected void m_19915_(float yaw, float pitch) {
        this.m_146922_(yaw % 360.0f);
        this.m_146926_(pitch % 360.0f);
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void activate() {
        this.f_19815_ = this.cacheSize;
        this.f_19804_.m_135381_(DATA_SIZEACTIVE, (Object)true);
    }

    public void deactivate() {
        this.f_19815_ = EntityDimensions.m_20395_((float)0.0f, (float)0.0f);
        this.f_19804_.m_135381_(DATA_SIZEACTIVE, (Object)false);
    }
}

