/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.entity.Chain;
import twilightforest.entity.SpikeBlock;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.AvoidAnyEntityGoal;
import twilightforest.entity.ai.ThrowSpikeBlockGoal;
import twilightforest.util.TFDamageSources;

public class BlockChainGoblin
extends Monster {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "speedPenalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final float CHAIN_SPEED = 16.0f;
    private static final EntityDataAccessor<Byte> DATA_CHAINLENGTH = SynchedEntityData.m_135353_(BlockChainGoblin.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_CHAINPOS = SynchedEntityData.m_135353_(BlockChainGoblin.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_THROWING = SynchedEntityData.m_135353_(BlockChainGoblin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int recoilCounter;
    private float chainAngle;
    private float chainMoveLength;
    public final SpikeBlock block = new SpikeBlock((Entity)this);
    public final Chain chain1 = new Chain((Entity)this);
    public final Chain chain2 = new Chain((Entity)this);
    public final Chain chain3 = new Chain((Entity)this);
    private final MultipartGenericsAreDumb[] partsArray = new MultipartGenericsAreDumb[]{this.block, this.chain1, this.chain2, this.chain3};

    public BlockChainGoblin(EntityType<? extends BlockChainGoblin> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new AvoidAnyEntityGoal<PrimedTnt>((PathfinderMob)this, PrimedTnt.class, 2.0f, 1.0, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new ThrowSpikeBlockGoal(this, this.block));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHAINLENGTH, (Object)0);
        this.f_19804_.m_135372_(DATA_CHAINPOS, (Object)0);
        this.f_19804_.m_135372_(IS_THROWING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 11.0);
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() * 0.78f;
    }

    protected SoundEvent m_7515_() {
        return TFSounds.BLOCKCHAIN_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return TFSounds.BLOCKCHAIN_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.BLOCKCHAIN_DEATH;
    }

    public double getChainYOffset() {
        return 1.5 - (double)this.getChainLength() / 4.0;
    }

    public Vec3 getChainPosition() {
        return this.getChainPosition(this.getChainAngle(), this.getChainLength());
    }

    public Vec3 getChainPosition(float angle, float distance) {
        double dx = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3(this.m_20185_() + dx, this.m_20186_() + this.getChainYOffset(), this.m_20189_() + dz);
    }

    public boolean isSwingingChain() {
        return this.f_20911_ || this.m_5448_() != null && this.recoilCounter == 0;
    }

    public boolean m_7327_(Entity entity) {
        this.m_6674_(InteractionHand.MAIN_HAND);
        entity.m_6469_(TFDamageSources.spiked((Entity)this.block, (Entity)this), (float)this.m_21133_(Attributes.f_22281_));
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.block.m_8119_();
        this.chain1.m_8119_();
        this.chain2.m_8119_();
        this.chain3.m_8119_();
        if (this.recoilCounter > 0) {
            --this.recoilCounter;
        }
        this.chainAngle += 16.0f;
        this.chainAngle %= 360.0f;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(DATA_CHAINLENGTH, (Object)((byte)Math.floor(this.getChainLength() * 127.0f)));
            this.f_19804_.m_135381_(DATA_CHAINPOS, (Object)((byte)Math.floor(this.getChainAngle() / 360.0f * 255.0f)));
        } else if (Math.abs(this.chainAngle - this.getChainAngle()) > 32.0f) {
            this.chainAngle = this.getChainAngle();
        }
        if (this.m_6084_()) {
            if (this.chainMoveLength > 0.0f) {
                Vec3 blockPos = this.getThrowPos();
                double sx2 = this.m_20185_();
                double sy2 = this.m_20186_() + (double)this.m_20206_() - 0.1;
                double sz2 = this.m_20189_();
                double ox2 = sx2 - blockPos.f_82479_;
                double oy2 = sy2 - blockPos.f_82480_ - 0.25;
                double oz2 = sz2 - blockPos.f_82481_;
                if (this.chainMoveLength >= 6.0f || !this.m_6084_()) {
                    this.setThrowing(false);
                }
                this.chain1.m_6034_(sx2 - ox2 * 0.25, sy2 - oy2 * 0.25, sz2 - oz2 * 0.25);
                this.chain2.m_6034_(sx2 - ox2 * 0.5, sy2 - oy2 * 0.5, sz2 - oz2 * 0.5);
                this.chain3.m_6034_(sx2 - ox2 * 0.85, sy2 - oy2 * 0.85, sz2 - oz2 * 0.85);
                this.block.m_6034_(sx2 - ox2, sy2 - oy2, sz2 - oz2);
            } else {
                Vec3 blockPos = this.getChainPosition();
                this.block.m_6034_(blockPos.f_82479_, blockPos.f_82480_, blockPos.f_82481_);
                this.block.m_146922_(this.getChainAngle());
                double sx = this.m_20185_();
                double sy = this.m_20186_() + (double)this.m_20206_() - 0.1;
                double sz = this.m_20189_();
                double ox = sx - blockPos.f_82479_;
                double oy = sy - blockPos.f_82480_ - (double)this.block.m_20206_() / 3.0;
                double oz = sz - blockPos.f_82481_;
                this.chain1.m_6034_(sx - ox * 0.4, sy - oy * 0.4, sz - oz * 0.4);
                this.chain2.m_6034_(sx - ox * 0.5, sy - oy * 0.5, sz - oz * 0.5);
                this.chain3.m_6034_(sx - ox * 0.6, sy - oy * 0.6, sz - oz * 0.6);
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && (this.isThrowing() || this.isSwingingChain())) {
            this.applyBlockCollisions((Entity)this.block);
        }
        this.chainMove();
    }

    private Vec3 getThrowPos() {
        Vec3 vec3d = this.m_20252_(1.0f);
        return new Vec3(this.m_20185_() + vec3d.f_82479_ * (double)this.chainMoveLength, this.m_20186_() + (double)this.m_20192_(), this.m_20189_() + vec3d.f_82481_ * (double)this.chainMoveLength);
    }

    private void chainMove() {
        this.chainMoveLength = this.isThrowing() ? Mth.m_14036_((float)(this.chainMoveLength + 0.5f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.chainMoveLength - 1.5f), (float)0.0f, (float)6.0f);
    }

    public float getChainMoveLength() {
        return this.chainMoveLength;
    }

    protected void applyBlockCollisions(Entity collider) {
        List list = this.f_19853_.m_45933_(collider, collider.m_142469_().m_82377_((double)0.2f, 0.0, (double)0.2f));
        for (Entity entity : list) {
            if (!entity.m_6094_()) continue;
            this.applyBlockCollision(collider, entity);
        }
        if (this.isThrowing() && collider.m_5830_()) {
            this.setThrowing(false);
            collider.m_5496_(TFSounds.BLOCKCHAIN_COLLIDE, 0.65f, 0.75f);
        }
    }

    protected void applyBlockCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.m_7334_(collider);
            if (collided instanceof LivingEntity && super.m_7327_(collided)) {
                collided.m_5997_(0.0, 0.4, 0.0);
                this.m_5496_(TFSounds.BLOCKCHAIN_HIT, 1.0f, 1.0f);
                this.recoilCounter = 40;
                if (this.isThrowing()) {
                    this.setThrowing(false);
                }
            }
        }
    }

    public boolean isThrowing() {
        return (Boolean)this.f_19804_.m_135370_(IS_THROWING);
    }

    public void setThrowing(boolean isThrowing) {
        this.f_19804_.m_135381_(IS_THROWING, (Object)isThrowing);
    }

    private float getChainAngle() {
        if (!this.f_19853_.f_46443_) {
            return this.chainAngle;
        }
        return (float)((Byte)this.f_19804_.m_135370_(DATA_CHAINPOS) & 0xFF) / 255.0f * 360.0f;
    }

    private float getChainLength() {
        if (!this.f_19853_.f_46443_) {
            if (this.isSwingingChain()) {
                return 0.9f;
            }
            return 0.3f;
        }
        return (float)((Byte)this.f_19804_.m_135370_(DATA_CHAINLENGTH) & 0xFF) / 127.0f;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_142223_(ClientboundAddMobPacket p_147206_) {
        super.m_142223_(p_147206_);
        TFPart.assignPartIDs((Entity)this);
    }

    public MultipartGenericsAreDumb[] getParts() {
        return this.partsArray;
    }

    public static abstract class MultipartGenericsAreDumb
    extends TFPart<Entity> {
        public MultipartGenericsAreDumb(Entity parent) {
            super(parent);
        }
    }
}

