/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;

public class TowerwoodBorer
extends Monster {
    private SummonBorersGoal summonBorers;

    public TowerwoodBorer(EntityType<? extends TowerwoodBorer> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.summonBorers = new SummonBorersGoal(this);
        this.f_21345_.m_25352_(3, (Goal)this.summonBorers);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new HideInTowerwoodGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 8.0);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_20161_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return TFSounds.TERMITE_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return TFSounds.TERMITE_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.TERMITE_DEATH;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if ((source instanceof EntityDamageSource || source == DamageSource.f_19319_) && this.summonBorers != null) {
            this.summonBorers.notifyHurt();
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(TFSounds.TERMITE_STEP, 0.15f, 1.0f);
    }

    public void m_8119_() {
        this.f_20883_ = this.m_146908_();
        super.m_8119_();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    private static class SummonBorersGoal
    extends Goal {
        private final TowerwoodBorer borer;
        private int lookForFriends;

        public SummonBorersGoal(TowerwoodBorer borer) {
            this.borer = borer;
        }

        public void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = 20;
            }
        }

        public boolean m_8036_() {
            return this.lookForFriends > 0;
        }

        public void m_8037_() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                Level world = this.borer.m_183503_();
                Random random = this.borer.m_21187_();
                BlockPos pos = new BlockPos((Vec3i)this.borer.m_142538_());
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos offsetPos = pos.m_142082_(j, i, k);
                            BlockState state = world.m_8055_(offsetPos);
                            if (state.m_60713_((Block)TFBlocks.INFESTED_TOWERWOOD.get())) {
                                if (ForgeEventFactory.getMobGriefingEvent((Level)world, (Entity)this.borer)) {
                                    world.m_46961_(offsetPos, true);
                                } else {
                                    world.m_7731_(offsetPos, ((Block)TFBlocks.TOWERWOOD.get()).m_49966_(), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }

    private static class HideInTowerwoodGoal
    extends RandomStrollGoal {
        private Direction facing;
        private boolean doMerge;

        public HideInTowerwoodGoal(TowerwoodBorer borer) {
            super((PathfinderMob)borer, 1.0, 10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.f_25725_.m_5448_() != null) {
                return false;
            }
            if (!this.f_25725_.m_21573_().m_26571_()) {
                return false;
            }
            Random random = this.f_25725_.m_21187_();
            if (random.nextInt(10) == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_25725_.m_183503_(), (Entity)this.f_25725_)) {
                this.facing = Direction.m_122404_((Random)random);
                BlockPos blockpos = new BlockPos(this.f_25725_.m_20185_(), this.f_25725_.m_20186_() + 0.5, this.f_25725_.m_20189_()).m_142300_(this.facing);
                BlockState state = this.f_25725_.m_183503_().m_8055_(blockpos);
                if (state.m_60713_((Block)TFBlocks.TOWERWOOD.get())) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.doMerge && super.m_8045_();
        }

        public void m_8056_() {
            if (!this.doMerge) {
                super.m_8056_();
            } else {
                BlockPos blockpos;
                Level level = this.f_25725_.m_183503_();
                BlockState state = level.m_8055_(blockpos = new BlockPos(this.f_25725_.m_20185_(), this.f_25725_.m_20186_() + 0.5, this.f_25725_.m_20189_()).m_142300_(this.facing));
                if (state.m_60713_((Block)TFBlocks.TOWERWOOD.get()) && this.f_25725_.m_21187_().nextInt(5) == 0) {
                    level.m_7731_(blockpos, ((Block)TFBlocks.INFESTED_TOWERWOOD.get()).m_49966_(), 3);
                    this.f_25725_.m_21373_();
                    this.f_25725_.m_146870_();
                }
            }
        }
    }
}

