/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.entity.ai.TinyBirdFlyGoal;
import twilightforest.entity.passive.Bird;

public class TinyBird
extends Bird {
    private static final EntityDataAccessor<Byte> DATA_BIRDTYPE = SynchedEntityData.m_135353_(TinyBird.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_BIRDFLAGS = SynchedEntityData.m_135353_(TinyBird.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BlockPos spawnPosition;
    private int currentFlightTime;

    public TinyBird(EntityType<? extends TinyBird> type, Level world) {
        super(type, world);
        this.setBirdType(this.f_19796_.nextInt(4));
        this.setIsBirdLanded(true);
        this.m_146762_(0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new TinyBirdFlyGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, SEEDS, true));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 8.0f, 1.0, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 8.0f, 1.0, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BIRDTYPE, (Object)0);
        this.f_19804_.m_135372_(DATA_BIRDFLAGS, (Object)0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.20000001192092895);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BirdType", this.getBirdType());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBirdType(compound.m_128451_("BirdType"));
    }

    public int getBirdType() {
        return ((Byte)this.f_19804_.m_135370_(DATA_BIRDTYPE)).byteValue();
    }

    public void setBirdType(int type) {
        this.f_19804_.m_135381_(DATA_BIRDTYPE, (Object)((byte)type));
    }

    protected SoundEvent m_7515_() {
        return TFSounds.TINYBIRD_CHIRP;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return TFSounds.TINYBIRD_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.TINYBIRD_HURT;
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() * 0.7f;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public float m_21692_(BlockPos pos) {
        Material underMaterial = this.f_19853_.m_8055_(pos.m_7495_()).m_60767_();
        if (underMaterial == Material.f_76274_) {
            return 200.0f;
        }
        if (underMaterial == Material.f_76320_) {
            return 15.0f;
        }
        if (underMaterial == Material.f_76315_) {
            return 9.0f;
        }
        return (float)this.f_19853_.m_46803_(pos) - 0.5f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isBirdLanded()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        BlockPos blockpos = this.m_142538_();
        if (this.isBirdLanded()) {
            this.currentFlightTime = 0;
            boolean flag = this.m_20067_();
            if (this.isSpooked() || this.m_20069_() || this.f_19853_.m_46855_(this.m_142469_()) || this.f_19796_.nextInt(200) == 0 && !this.isLandableBlock(this.m_142538_().m_7495_())) {
                this.setIsBirdLanded(false);
                if (!flag) {
                    this.m_5496_(TFSounds.TINYBIRD_TAKEOFF, 0.05f, this.m_6100_());
                }
            }
        } else {
            ++this.currentFlightTime;
            if (!(this.spawnPosition == null || this.f_19853_.m_46859_(this.spawnPosition) && this.spawnPosition.m_123342_() > this.f_19853_.m_141937_())) {
                this.spawnPosition = null;
            }
            if (this.m_20069_() || this.f_19853_.m_46855_(this.m_142469_())) {
                this.currentFlightTime = 0;
                this.m_20334_(this.m_20184_().m_7096_(), 0.1f, this.m_20184_().m_7094_());
            }
            if (this.spawnPosition == null || this.f_19796_.nextInt(30) == 0 || this.spawnPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
                int yTarget = this.currentFlightTime < 100 ? 2 : 4;
                this.spawnPosition = new BlockPos(this.m_20185_() + (double)this.f_19796_.nextInt(7) - (double)this.f_19796_.nextInt(7), this.m_20186_() + (double)this.f_19796_.nextInt(6) - (double)yTarget, this.m_20189_() + (double)this.f_19796_.nextInt(7) - (double)this.f_19796_.nextInt(7));
            }
            double d2 = (double)this.spawnPosition.m_123341_() + 0.5 - this.m_20185_();
            double d0 = (double)this.spawnPosition.m_123342_() + 0.1 - this.m_20186_();
            double d1 = (double)this.spawnPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            Vec3 vec31 = vec3.m_82520_((Math.signum(d2) * 0.5 - vec3.f_82479_) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vec3.f_82480_) * (double)0.1f, (Math.signum(d1) * 0.5 - vec3.f_82481_) * (double)0.1f);
            this.m_20256_(vec31);
            float f = (float)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
            if (this.f_19796_.nextInt(10) == 0 && this.isLandableBlock(this.m_142538_().m_7495_())) {
                this.setIsBirdLanded(true);
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
        }
    }

    public boolean isSpooked() {
        if (this.f_20916_ > 0) {
            return true;
        }
        Player closestPlayer = this.f_19853_.m_45930_((Entity)this, 4.0);
        return closestPlayer != null && !SEEDS.test(closestPlayer.m_21205_()) && !SEEDS.test(closestPlayer.m_21206_());
    }

    public boolean isLandableBlock(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        return !state.m_60795_() && (state.m_204336_(BlockTags.f_13035_) || state.m_60783_((BlockGetter)this.f_19853_, pos, Direction.UP));
    }

    @Override
    public boolean isBirdLanded() {
        return ((Byte)this.f_19804_.m_135370_(DATA_BIRDFLAGS) & 1) != 0;
    }

    public void setIsBirdLanded(boolean landed) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_BIRDFLAGS);
        this.f_19804_.m_135381_(DATA_BIRDFLAGS, (Object)((byte)(landed ? flags | 1 : flags & 0xFFFFFFFE)));
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public boolean m_6090_() {
        return true;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    protected void m_6138_() {
    }

    public boolean m_6162_() {
        return false;
    }
}

