/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;

public class MagicBeansItem
extends Item {
    private int blocksSkipped;

    protected MagicBeansItem(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Block blockAt = world.m_8055_(pos).m_60734_();
        ItemStack stack = context.m_43722_();
        int minY = pos.m_123342_() + 1;
        int maxY = Math.max(pos.m_123342_() + 100, 175);
        if (pos.m_123342_() < maxY && blockAt == TFBlocks.UBEROUS_SOIL.get()) {
            if (!world.f_46443_) {
                stack.m_41774_(1);
                this.makeHugeStalk(world, pos, minY, maxY);
                if (player instanceof ServerPlayer) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    PlayerAdvancements advancements = ((ServerPlayer)player).m_8960_();
                    ServerAdvancementManager manager = ((ServerLevel)player.m_20193_()).m_142572_().m_129889_();
                    Advancement advancement = manager.m_136041_(TwilightForestMod.prefix("beanstalk"));
                    if (advancement != null) {
                        advancements.m_135988_(advancement, "use_beans");
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void makeHugeStalk(Level world, BlockPos pos, int minY, int maxY) {
        float x = pos.m_123341_();
        float z = pos.m_123343_();
        int yOffset = world.f_46441_.nextInt(100);
        float cScale = world.f_46441_.nextFloat() * 0.25f + 0.125f;
        float rScale = world.f_46441_.nextFloat() * 0.25f + 0.125f;
        float radius = 4.0f + Mth.m_14031_((float)((float)(minY + yOffset) * rScale)) * 3.0f;
        x -= Mth.m_14031_((float)((float)(minY + yOffset) * cScale)) * radius;
        z -= Mth.m_14089_((float)((float)(minY + yOffset) * cScale)) * radius;
        int nextLeafY = minY + 10 + world.f_46441_.nextInt(20);
        boolean isClear = true;
        for (int dy = minY; dy < maxY && isClear; ++dy) {
            radius = 5.0f + Mth.m_14031_((float)((float)(dy + yOffset) * rScale)) * 2.5f;
            float cx = x + Mth.m_14031_((float)((float)(dy + yOffset) * cScale)) * radius;
            float cz = z + Mth.m_14089_((float)((float)(dy + yOffset) * cScale)) * radius;
            float stalkThickness = 2.5f;
            if (maxY - dy < 5) {
                stalkThickness *= (float)(maxY - dy) / 5.0f;
            }
            int minX = Mth.m_14143_((float)(x - radius - stalkThickness));
            int maxX = Mth.m_14167_((float)(x + radius + stalkThickness));
            int minZ = Mth.m_14143_((float)(z - radius - stalkThickness));
            int maxZ = Mth.m_14167_((float)(z + radius + stalkThickness));
            for (int dx = minX; dx < maxX && isClear; ++dx) {
                for (int dz = minZ; dz < maxZ && isClear; ++dz) {
                    if (!(((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz) < stalkThickness * stalkThickness)) continue;
                    isClear = this.tryToPlaceStalk(world, new BlockPos(dx, dy, dz));
                }
            }
            this.blocksSkipped = 0;
            if (dy != nextLeafY) continue;
            int lx = (int)(x + Mth.m_14031_((float)((float)(dy + yOffset) * cScale)) * (radius + stalkThickness));
            int lz = (int)(z + Mth.m_14089_((float)((float)(dy + yOffset) * cScale)) * (radius + stalkThickness));
            this.placeLeaves(world, new BlockPos(lx, dy, lz));
            nextLeafY = dy + 5 + world.f_46441_.nextInt(10);
        }
    }

    private void placeLeaves(Level world, BlockPos pos) {
        int dz;
        int dx;
        world.m_46597_(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).m_49966_());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                this.tryToPlaceLeaves(world, pos.m_142082_(dx, -1, dz));
                this.tryToPlaceLeaves(world, pos.m_142082_(dx, 1, dz));
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(world, pos.m_142082_(dx, 0, dz));
            }
        }
    }

    private boolean tryToPlaceStalk(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_60767_().m_76336_() || state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_60734_().equals(TFBlocks.FLUFFY_CLOUD.get())) {
            world.m_46597_(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).m_49966_());
            if (pos.m_123342_() > 150) {
                for (int i = 0; i < 7; ++i) {
                    if (!world.m_8055_(pos.m_5484_(Direction.UP, i)).equals(((Block)TFBlocks.WISPY_CLOUD.get()).m_49966_()) && !world.m_8055_(pos.m_5484_(Direction.UP, i)).equals(((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_())) continue;
                    world.m_46597_(pos.m_5484_(Direction.UP, i), Blocks.f_50016_.m_49966_());
                }
            }
            return true;
        }
        ++this.blocksSkipped;
        return this.blocksSkipped < 15;
    }

    private void tryToPlaceLeaves(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_204336_(BlockTags.f_13035_)) {
            world.m_7731_(pos, (BlockState)((Block)TFBlocks.BEANSTALK_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

