/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.block.TFBlocks;

public class OreMeterItem
extends Item {
    protected OreMeterItem(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        int useX = Mth.m_14107_((double)player.m_20185_());
        int useZ = Mth.m_14107_((double)player.m_20189_());
        if (!world.f_46443_) {
            this.countOreInArea(player, world, useX, useZ, 3);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)world.f_46443_);
    }

    private void countOreInArea(Player player, Level world, int useX, int useZ, int radius) {
        int chunkX = useX >> 4;
        int chunkZ = useZ >> 4;
        int countStone = 0;
        int countDirt = 0;
        int countGravel = 0;
        int countCoal = 0;
        int countIron = 0;
        int countGold = 0;
        int countDiamond = 0;
        int countLapis = 0;
        int countRedstone = 0;
        int countExposedDiamond = 0;
        int countRoots = 0;
        int countOreRoots = 0;
        ScanResult dummy = new ScanResult();
        for (int cx = chunkX - radius; cx <= chunkX + radius; ++cx) {
            for (int cz = chunkZ - radius; cz <= chunkZ + radius; ++cz) {
                Map<BlockState, ScanResult> results = this.countBlocksInChunk(world, chunkX, chunkZ);
                countStone += results.entrySet().stream().filter(e -> ((BlockState)e.getKey()).m_60734_() == Blocks.f_50069_).mapToInt(e -> ((ScanResult)e.getValue()).count).sum();
                countDirt += results.entrySet().stream().filter(e -> ((BlockState)e.getKey()).m_60734_() == Blocks.f_50493_).mapToInt(e -> ((ScanResult)e.getValue()).count).sum();
                countGravel += results.getOrDefault((Object)Blocks.f_49994_.m_49966_(), (ScanResult)dummy).count;
                countCoal += results.getOrDefault((Object)Blocks.f_49997_.m_49966_(), (ScanResult)dummy).count;
                countIron += results.getOrDefault((Object)Blocks.f_49996_.m_49966_(), (ScanResult)dummy).count;
                countGold += results.getOrDefault((Object)Blocks.f_49995_.m_49966_(), (ScanResult)dummy).count;
                countDiamond += results.getOrDefault((Object)Blocks.f_50089_.m_49966_(), (ScanResult)dummy).count;
                countLapis += results.getOrDefault((Object)Blocks.f_50059_.m_49966_(), (ScanResult)dummy).count;
                countRedstone += results.getOrDefault((Object)Blocks.f_50173_.m_49966_(), (ScanResult)dummy).count;
                countExposedDiamond += results.getOrDefault((Object)Blocks.f_50089_.m_49966_(), (ScanResult)dummy).exposedCount;
                countRoots += results.getOrDefault((Object)((Block)TFBlocks.ROOT_BLOCK.get()).m_49966_(), (ScanResult)dummy).count;
                countOreRoots += results.getOrDefault((Object)((Block)TFBlocks.LIVEROOT_BLOCK.get()).m_49966_(), (ScanResult)dummy).count;
            }
        }
        int total = countStone + countDirt + countGravel + countCoal + countIron + countGold + countDiamond + countLapis + countRedstone + countRoots + countOreRoots;
        player.m_6352_((Component)new TranslatableComponent(this.m_5524_()).m_130946_("!"), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent("twilightforest.ore_meter.range", new Object[]{radius, chunkX, chunkZ}), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(Blocks.f_49997_.m_7705_()).m_130946_(" - " + countCoal + " " + this.percent(countCoal, total)), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(Blocks.f_49996_.m_7705_()).m_130946_(" - " + countIron + " " + this.percent(countIron, total)), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(Blocks.f_49995_.m_7705_()).m_130946_(" - " + countGold + " " + this.percent(countGold, total)), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(Blocks.f_50089_.m_7705_()).m_130946_(" - " + countDiamond + " " + this.percent(countDiamond, total) + ", ").m_7220_((Component)new TranslatableComponent("twilightforest.ore_meter.exposed", new Object[]{countExposedDiamond})), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(Blocks.f_50059_.m_7705_()).m_130946_(" - " + countLapis + " " + this.percent(countLapis, total)), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(Blocks.f_50173_.m_7705_()).m_130946_(" - " + countRedstone + " " + this.percent(countRedstone, total)), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(((Block)TFBlocks.ROOT_BLOCK.get()).m_7705_()).m_130946_(" - " + countRoots + " " + this.percent(countRoots, total)), Util.f_137441_);
        player.m_6352_((Component)new TranslatableComponent(((Block)TFBlocks.LIVEROOT_BLOCK.get()).m_7705_()).m_130946_(" - " + countOreRoots + " " + this.percent(countOreRoots, total)), Util.f_137441_);
    }

    private String percent(int count, int total) {
        return (float)count / (float)total * 100.0f + "%";
    }

    private Map<BlockState, ScanResult> countBlocksInChunk(Level world, int cx, int cz) {
        IdentityHashMap<BlockState, ScanResult> ret = new IdentityHashMap<BlockState, ScanResult>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = cx << 4; x < (cx << 4) + 16; ++x) {
            for (int z = cz << 4; z < (cz << 4) + 16; ++z) {
                block2: for (int y = 0; y < 256; ++y) {
                    BlockState state = world.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                    ScanResult res = ret.computeIfAbsent(state, s -> new ScanResult());
                    ++res.count;
                    for (Direction e : Direction.values()) {
                        if (!world.m_46859_((BlockPos)pos.m_122178_(x, y, z).m_122173_(e))) continue;
                        ++res.exposedCount;
                        continue block2;
                    }
                }
            }
        }
        return ret;
    }

    private static class ScanResult {
        int count;
        int exposedCount;

        private ScanResult() {
        }
    }
}

