/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import twilightforest.TwilightForestMod;
import twilightforest.loot.conditions.IsMinion;
import twilightforest.loot.conditions.ModExists;
import twilightforest.loot.functions.Enchant;
import twilightforest.loot.functions.ModItemSwap;

public class TFTreasure {
    private static final Set<ResourceLocation> TF_LOOT_TABLES = Sets.newHashSet();
    private static final int DEFAULT_PLACE_FLAG = 2;
    public static final TFTreasure SMALL_HOLLOW_HILL = new TFTreasure("hill_1");
    public static final TFTreasure MEDIUM_HOLLOW_HILL = new TFTreasure("hill_2");
    public static final TFTreasure LARGE_HOLLOW_HILL = new TFTreasure("hill_3");
    public static final TFTreasure HEDGE_MAZE = new TFTreasure("hedge_maze");
    public static final TFTreasure FANCY_WELL = new TFTreasure("fancy_well");
    public static final TFTreasure WELL = new TFTreasure("well");
    public static final TFTreasure LABYRINTH_ROOM = new TFTreasure("labyrinth_room");
    public static final TFTreasure LABYRINTH_DEAD_END = new TFTreasure("labyrinth_dead_end");
    public static final TFTreasure TOWER_ROOM = new TFTreasure("tower_room");
    public static final TFTreasure TOWER_LIBRARY = new TFTreasure("tower_library");
    public static final TFTreasure BASEMENT = new TFTreasure("basement");
    public static final TFTreasure FOUNDATION_BASEMENT = new TFTreasure("foundation_basement");
    public static final TFTreasure LABYRINTH_VAULT = new TFTreasure("labyrinth_vault");
    public static final TFTreasure DARKTOWER_CACHE = new TFTreasure("darktower_cache");
    public static final TFTreasure DARKTOWER_KEY = new TFTreasure("darktower_key");
    public static final TFTreasure DARKTOWER_BOSS = new TFTreasure("darktower_boss");
    public static final TFTreasure TREE_CACHE = new TFTreasure("tree_cache");
    public static final TFTreasure STRONGHOLD_CACHE = new TFTreasure("stronghold_cache");
    public static final TFTreasure STRONGHOLD_ROOM = new TFTreasure("stronghold_room");
    public static final TFTreasure STRONGHOLD_BOSS = new TFTreasure("stronghold_boss");
    public static final TFTreasure AURORA_CACHE = new TFTreasure("aurora_cache");
    public static final TFTreasure AURORA_ROOM = new TFTreasure("aurora_room");
    public static final TFTreasure TROLL_GARDEN = new TFTreasure("troll_garden");
    public static final TFTreasure TROLL_VAULT = new TFTreasure("troll_vault");
    public static final TFTreasure GRAVEYARD = new TFTreasure("graveyard");
    public static final TFTreasure QUEST_GROVE = new TFTreasure("quest_grove_dropper");
    public static final TFTreasure USELESS_LOOT = new TFTreasure("useless");
    public static final ResourceLocation BIGHORN_SHEEP_WHITE = TFTreasure.register("entities/bighorn_sheep/white");
    public static final ResourceLocation BIGHORN_SHEEP_ORANGE = TFTreasure.register("entities/bighorn_sheep/orange");
    public static final ResourceLocation BIGHORN_SHEEP_MAGENTA = TFTreasure.register("entities/bighorn_sheep/magenta");
    public static final ResourceLocation BIGHORN_SHEEP_LIGHT_BLUE = TFTreasure.register("entities/bighorn_sheep/light_blue");
    public static final ResourceLocation BIGHORN_SHEEP_YELLOW = TFTreasure.register("entities/bighorn_sheep/yellow");
    public static final ResourceLocation BIGHORN_SHEEP_LIME = TFTreasure.register("entities/bighorn_sheep/lime");
    public static final ResourceLocation BIGHORN_SHEEP_PINK = TFTreasure.register("entities/bighorn_sheep/pink");
    public static final ResourceLocation BIGHORN_SHEEP_GRAY = TFTreasure.register("entities/bighorn_sheep/gray");
    public static final ResourceLocation BIGHORN_SHEEP_LIGHT_GRAY = TFTreasure.register("entities/bighorn_sheep/light_gray");
    public static final ResourceLocation BIGHORN_SHEEP_CYAN = TFTreasure.register("entities/bighorn_sheep/cyan");
    public static final ResourceLocation BIGHORN_SHEEP_PURPLE = TFTreasure.register("entities/bighorn_sheep/purple");
    public static final ResourceLocation BIGHORN_SHEEP_BLUE = TFTreasure.register("entities/bighorn_sheep/blue");
    public static final ResourceLocation BIGHORN_SHEEP_BROWN = TFTreasure.register("entities/bighorn_sheep/brown");
    public static final ResourceLocation BIGHORN_SHEEP_GREEN = TFTreasure.register("entities/bighorn_sheep/green");
    public static final ResourceLocation BIGHORN_SHEEP_RED = TFTreasure.register("entities/bighorn_sheep/red");
    public static final ResourceLocation BIGHORN_SHEEP_BLACK = TFTreasure.register("entities/bighorn_sheep/black");
    public static final ResourceLocation QUESTING_RAM_REWARDS = TFTreasure.register("entities/questing_ram_rewards");
    public static final ResourceLocation DEATH_TOME_HURT = TFTreasure.register("entities/death_tome_hurt");
    public static final ResourceLocation DEATH_TOME_BOOKS = TFTreasure.register("entities/death_tome_books");
    public static final ResourceLocation ALL_BOSSES = TFTreasure.register("entities/all_bosses");
    public static LootItemFunctionType ENCHANT;
    public static LootItemFunctionType ITEM_OR_DEFAULT;
    public static LootItemConditionType IS_MINION;
    public static LootItemConditionType MOD_EXISTS;
    public final ResourceLocation lootTable;

    private TFTreasure(String path) {
        this.lootTable = TwilightForestMod.prefix(String.format("structures/%s", path));
    }

    public static void init() {
        ENCHANT = TFTreasure.registerFunction("enchant", new LootItemFunctionType((Serializer)new Enchant.Serializer()));
        ITEM_OR_DEFAULT = TFTreasure.registerFunction("item_or_default", new LootItemFunctionType((Serializer)new ModItemSwap.Serializer()));
        IS_MINION = TFTreasure.registerCondition("is_minion", new LootItemConditionType((Serializer)new IsMinion.ConditionSerializer()));
        MOD_EXISTS = TFTreasure.registerCondition("mod_exists", new LootItemConditionType((Serializer)new ModExists.ConditionSerializer()));
    }

    public void generateChest(WorldGenLevel world, BlockPos pos, Direction dir, boolean trapped) {
        this.generateLootContainer(world, pos, (BlockState)(trapped ? Blocks.f_50325_ : Blocks.f_50087_).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)dir), 2);
    }

    public void generateLootContainer(WorldGenLevel world, BlockPos pos, BlockState state, int flags) {
        world.m_7731_(pos, state, flags);
        this.generateChestContents(world, pos);
    }

    public void generateLootContainer(LevelAccessor world, BlockPos pos, BlockState state, int flags, long seed) {
        world.m_7731_(pos, state, flags);
        this.generateChestContents(world, pos, seed);
    }

    public void generateChestContents(WorldGenLevel world, BlockPos pos) {
        this.generateChestContents((LevelAccessor)world, pos, world.m_7328_() * (long)pos.m_123341_() + (long)pos.m_123342_() ^ (long)pos.m_123343_());
    }

    public void generateChestContents(LevelAccessor world, BlockPos pos, long seed) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootContainer = (RandomizableContainerBlockEntity)blockEntity;
            lootContainer.m_59626_(this.lootTable, seed);
        }
    }

    private static LootItemFunctionType registerFunction(String name, LootItemFunctionType function) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)TwilightForestMod.prefix(name), (Object)function);
    }

    private static LootItemConditionType registerCondition(String name, LootItemConditionType condition) {
        return (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)TwilightForestMod.prefix(name), (Object)condition);
    }

    private static ResourceLocation register(String id) {
        return TFTreasure.register(TwilightForestMod.prefix(id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (TF_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " is already a registered built-in loot table");
    }

    public static void entityDropsIntoContainer(LivingEntity entity, LootContext lootContext, BlockState blockContaining, BlockPos placement) {
        ServerLevel serverLevel;
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_7731_(placement, blockContaining, 2) && (level = serverLevel.m_7702_(placement)) instanceof Container) {
            Container container = (Container)level;
            serverLevel.m_142572_().m_129898_().m_79217_(entity.m_5743_()).m_79123_(container, lootContext);
        }
    }
}

