/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.ProtectionBox;

public class AreaProtectionPacket {
    private final List<BoundingBox> sbb;
    private final BlockPos pos;

    public AreaProtectionPacket(List<BoundingBox> sbb, BlockPos pos) {
        this.sbb = sbb;
        this.pos = pos;
    }

    public AreaProtectionPacket(FriendlyByteBuf buf) {
        this.sbb = new ArrayList<BoundingBox>();
        int len = buf.readInt();
        for (int i = 0; i < len; ++i) {
            this.sbb.add(new BoundingBox(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));
        }
        this.pos = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.sbb.size());
        this.sbb.forEach(box -> {
            buf.writeInt(box.m_162395_());
            buf.writeInt(box.m_162396_());
            buf.writeInt(box.m_162398_());
            buf.writeInt(box.m_162399_());
            buf.writeInt(box.m_162400_());
            buf.writeInt(box.m_162401_());
        });
        buf.m_130064_(this.pos);
    }

    public static class Handler {
        public static boolean onMessage(final AreaProtectionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ClientLevel world = Minecraft.m_91087_().f_91073_;
                    message.sbb.forEach(box -> Handler.addProtectionBox(world, box));
                    for (int i = 0; i < 20; ++i) {
                        double vx = world.f_46441_.nextGaussian() * 0.02;
                        double vy = world.f_46441_.nextGaussian() * 0.02;
                        double vz = world.f_46441_.nextGaussian() * 0.02;
                        double x = (double)message.pos.m_123341_() + 0.5 + (double)world.f_46441_.nextFloat() - (double)world.f_46441_.nextFloat();
                        double y = (double)message.pos.m_123342_() + 0.5 + (double)world.f_46441_.nextFloat() - (double)world.f_46441_.nextFloat();
                        double z = (double)message.pos.m_123343_() + 0.5 + (double)world.f_46441_.nextFloat() - (double)world.f_46441_.nextFloat();
                        world.m_7106_((ParticleOptions)TFParticleType.PROTECTION.get(), x, y, z, vx, vy, vz);
                    }
                }
            });
            return true;
        }

        static void addProtectionBox(ClientLevel world, BoundingBox sbb) {
            for (Entity entity : world.m_104735_()) {
                if (!(entity instanceof ProtectionBox)) continue;
                ProtectionBox protectionBox = (ProtectionBox)entity;
                if (protectionBox.lifeTime <= 0 || !protectionBox.matches(sbb)) continue;
                protectionBox.resetLifetime();
                return;
            }
            world.m_104627_(0, (Entity)new ProtectionBox((Level)world, sbb));
        }
    }
}

