/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.TFMagicMapData;
import twilightforest.item.MagicMapItem;

public class MagicMapPacket {
    private final byte[] featureData;
    private final ClientboundMapItemDataPacket inner;

    public MagicMapPacket(TFMagicMapData mapData, ClientboundMapItemDataPacket inner) {
        this.featureData = mapData.serializeFeatures();
        this.inner = inner;
    }

    public MagicMapPacket(FriendlyByteBuf buf) {
        this.featureData = buf.m_130052_();
        this.inner = new ClientboundMapItemDataPacket(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130087_(this.featureData);
        this.inner.m_5779_(buf);
    }

    public static class Handler {
        public static boolean onMessage(final MagicMapPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    MapRenderer mapitemrenderer = Minecraft.m_91087_().f_91063_.m_109151_();
                    String s = MagicMapItem.getMapName(message.inner.m_132445_());
                    TFMagicMapData mapdata = TFMagicMapData.getMagicMapData((Level)Minecraft.m_91087_().f_91073_, s);
                    if (mapdata == null) {
                        mapdata = new TFMagicMapData(0, 0, message.inner.m_178982_(), false, false, message.inner.m_178983_(), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
                        TFMagicMapData.registerMagicMapData((Level)Minecraft.m_91087_().f_91073_, mapdata, s);
                    }
                    message.inner.m_132437_((MapItemSavedData)mapdata);
                    mapdata.deserializeFeatures(message.featureData);
                    LinkedHashMap saveVanilla = new LinkedHashMap(mapdata.f_77894_);
                    mapdata.f_77894_.clear();
                    for (TFMagicMapData.TFMapDecoration tfDecor : mapdata.tfDecorations) {
                        mapdata.f_77894_.put(((Object)((Object)tfDecor)).toString(), tfDecor);
                    }
                    mapdata.f_77894_.putAll(saveVanilla);
                    mapitemrenderer.m_168765_(message.inner.m_132445_(), (MapItemSavedData)mapdata);
                }
            });
            return true;
        }
    }
}

