/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public final class Codecs {
    public static final Codec<BlockPos> STRING_POS = Codec.STRING.comapFlatMap(Codecs::parseString2BlockPos, Vec3i::m_123344_);
    public static final Codec<Direction> ONLY_HORIZONTAL = Direction.f_175356_.comapFlatMap(direction -> direction.m_122434_() != Direction.Axis.Y ? DataResult.success((Object)direction) : DataResult.error((String)"Horizontal direction only!", (Object)direction), Function.identity());
    public static final Codec<Climate.ParameterList<Holder<Biome>>> CLIMATE_SYSTEM = ExtraCodecs.m_144637_((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Climate.ParameterPoint.f_186862_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.f_47431_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(Climate.ParameterList::new, Climate.ParameterList::m_186850_);

    public static <T> Codec<Float2ObjectAVLTreeMap<T>> floatTreeCodec(Codec<T> elementCodec) {
        return Codec.compoundList((Codec)Codec.FLOAT, elementCodec).xmap(floatEList -> floatEList.stream().collect(Float2ObjectAVLTreeMap::new, (map, pair) -> map.put((Float)pair.getFirst(), pair.getSecond()), AbstractFloat2ObjectMap::putAll), map -> map.entrySet().stream().map(entry -> new Pair((Object)((Float)entry.getKey()), entry.getValue())).toList());
    }

    private static DataResult<BlockPos> parseString2BlockPos(String string) {
        try {
            return Util.m_137539_((IntStream)Arrays.stream(string.split(" *, *")).mapToInt(Integer::parseInt), (int)3).map(arr -> new BlockPos(arr[0], arr[1], arr[2]));
        }
        catch (Throwable e) {
            return DataResult.error((String)e.getMessage());
        }
    }

    private Codecs() {
    }
}

