/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.world.components.feature.trees.TFGenCanopyMushroom;

@ParametersAreNonnullByDefault
public class TFGenCanopyMushroomRed
extends TFGenCanopyMushroom {
    private int altHeads = 0;

    public TFGenCanopyMushroomRed(Codec<HugeMushroomFeatureConfiguration> featureConfigurationCodec) {
        super(featureConfigurationCodec);
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        this.altHeads = context.m_159776_().nextInt(100) + 1;
        return super.m_142674_(context);
    }

    @Override
    protected int m_65129_(Random random) {
        return super.m_65129_(random) + 3;
    }

    @Override
    protected int getBranches(Random random) {
        return 3;
    }

    @Override
    protected double getLength(Random random) {
        return 10 + random.nextInt(2);
    }

    @Override
    protected void m_6152_(LevelAccessor levelAccessor, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        if (this.altHeads <= 33) {
            this.makeVanillaCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else if (this.altHeads <= 66) {
            this.makeSmoothCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else if (this.altHeads <= 99) {
            this.makeSpheroidCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else {
            super.m_6152_(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        }
    }

    protected void makeVanillaCap(LevelAccessor levelAccessor, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 3; y <= height; ++y) {
            int j = y < height ? featureConfiguration.f_67742_ : featureConfiguration.f_67742_ - 1;
            int k = featureConfiguration.f_67742_ - 2;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    boolean zMinMax;
                    boolean xIsMin = x == -j;
                    boolean xIsMax = x == j;
                    boolean zIsMin = z == -j;
                    boolean zIsMax = z == j;
                    boolean xMinMax = xIsMin || xIsMax;
                    boolean bl = zMinMax = zIsMin || zIsMax;
                    if (y < height && xMinMax == zMinMax) continue;
                    mutableBlockPos.m_122154_((Vec3i)pos, x, y, z);
                    if (levelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60804_((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.f_67740_.m_7112_(random, pos);
                    if (blockstate.m_61138_((Property)HugeMushroomBlock.f_54130_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54128_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54127_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54129_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54131_)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(y >= height - 1))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(x < -k))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(x > k))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(z < -k))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(z > k));
                    }
                    this.m_5974_((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }

    protected void makeSmoothCap(LevelAccessor levelAccessor, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 2; y <= height + 1; ++y) {
            int j = featureConfiguration.f_67742_ - Math.max(0, y - (height - 1)) + 1;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    if (!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x, y, z)) continue;
                    mutableBlockPos.m_122154_((Vec3i)pos, x, y, z);
                    if (levelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60804_((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.f_67740_.m_7112_(random, pos);
                    if (blockstate.m_61138_((Property)HugeMushroomBlock.f_54130_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54128_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54127_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54129_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54131_)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j - (y > height - 2 ? 1 : 0), x, y + 1, z)))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x - 1, y, z) && x < 0))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x + 1, y, z) && x > 0))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x, y, z - 1) && z < 0))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x, y, z + 1) && z > 0));
                    }
                    this.m_5974_((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }

    private static boolean isInsideSmoothShape(int height, int j, int x, int y, int z) {
        boolean zMinMax;
        int i = y - (height - 2);
        if (i == 4 || Math.abs(x) > j || Math.abs(z) > j) {
            return false;
        }
        if (i >= 2) {
            return true;
        }
        boolean xIsMin = x == -j;
        boolean xIsMax = x == j;
        boolean zIsMin = z == -j;
        boolean zIsMax = z == j;
        boolean xMinMax = xIsMin || xIsMax;
        boolean bl = zMinMax = zIsMin || zIsMax;
        if (i == 1 && (xMinMax && Math.abs(z) == j - 1 || zMinMax && Math.abs(x) == j - 1)) {
            return false;
        }
        return xMinMax != zMinMax || Math.abs(x) == Math.abs(z) && Math.abs(x) == j - 1;
    }

    protected void makeSpheroidCap(LevelAccessor levelAccessor, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 2; y <= height; ++y) {
            int j = y == height - 1 ? featureConfiguration.f_67742_ + 2 : featureConfiguration.f_67742_ + 1;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    double maxDistance;
                    double distance = Math.sqrt(x * x + z * z);
                    if (!(distance <= (maxDistance = (double)j + 0.1))) continue;
                    mutableBlockPos.m_122154_((Vec3i)pos, x, y, z);
                    if (levelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60804_((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                    BlockState blockstate = featureConfiguration.f_67740_.m_7112_(random, pos);
                    if (blockstate.m_61138_((Property)HugeMushroomBlock.f_54130_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54128_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54127_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54129_) && blockstate.m_61138_((Property)HugeMushroomBlock.f_54131_)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(y > height - 2 && (y == height || distance > maxDistance - 1.0)))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(Math.sqrt((x - 1) * (x - 1) + z * z) > maxDistance))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(Math.sqrt((x + 1) * (x + 1) + z * z) > maxDistance))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(Math.sqrt(x * x + (z - 1) * (z - 1)) > maxDistance))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(Math.sqrt(x * x + (z + 1) * (z + 1)) > maxDistance));
                    }
                    this.m_5974_((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockstate);
                }
            }
        }
    }
}

