/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerRevampPieces;
import twilightforest.world.components.structures.lichtowerrevamp.SideTowerRoom;

public final class CentralTowerAttachment
extends TwilightTemplateStructurePiece {
    private final int width;
    private final int length = 2;

    public CentralTowerAttachment(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super(LichTowerRevampPieces.CENTRAL_TO_SIDE_TOWER, compoundTag, ctx, TwilightTemplateStructurePiece.readSettings(compoundTag));
        this.width = compoundTag.m_128451_("width");
    }

    private CentralTowerAttachment(StructureManager structureManager, Rotation rotation, String name, BlockPos startPosition, int width) {
        this(structureManager, TwilightForestMod.prefix("lich_tower/attachments/central/" + name), CentralTowerAttachment.makeSettings(rotation), startPosition.m_5484_(rotation.m_55954_(Direction.EAST), -(width - 5 >> 1)), width);
    }

    private CentralTowerAttachment(StructureManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings, BlockPos startPosition, int width) {
        super(LichTowerRevampPieces.CENTRAL_TO_SIDE_TOWER, 0, structureManager, templateLocation, placeSettings, startPosition);
        this.width = width;
    }

    public static CentralTowerAttachment startRandomAttachment(StructureManager structureManager, Rotation rotation, BlockPos startPosition, Random random) {
        float weight = random.nextFloat() * random.nextFloat();
        if (weight < 0.33333334f) {
            return CentralTowerAttachment.smallAttachment(structureManager, rotation, startPosition);
        }
        if (weight < 0.6666667f) {
            return CentralTowerAttachment.mediumAttachment(structureManager, rotation, startPosition);
        }
        return CentralTowerAttachment.largeAttachment(structureManager, rotation, startPosition);
    }

    public static CentralTowerAttachment smallAttachment(StructureManager structureManager, Rotation rotation, BlockPos startPosition) {
        return new CentralTowerAttachment(structureManager, rotation, "central_to_small", startPosition, 5);
    }

    public static CentralTowerAttachment mediumAttachment(StructureManager structureManager, Rotation rotation, BlockPos startPosition) {
        return new CentralTowerAttachment(structureManager, rotation, "central_to_medium", startPosition, 7);
    }

    public static CentralTowerAttachment largeAttachment(StructureManager structureManager, Rotation rotation, BlockPos startPosition) {
        return new CentralTowerAttachment(structureManager, rotation, "central_to_large", startPosition, 9);
    }

    public void m_142537_(StructurePiece parent, StructurePieceAccessor structureStart, Random random) {
        super.m_142537_(parent, structureStart, random);
        Direction dir = this.f_73379_.m_55954_(Direction.SOUTH);
        BlockPos placement = this.f_73658_.m_142082_(dir.m_122429_() * this.length, 1, dir.m_122431_() * this.length);
        switch (this.width) {
            case 9: {
                SideTowerRoom largeRoom = SideTowerRoom.largeRoom(this.structureManager, this.f_73379_, placement, random);
                largeRoom.m_142537_((StructurePiece)this, structureStart, random);
                structureStart.m_142679_((StructurePiece)largeRoom);
                break;
            }
            case 7: {
                SideTowerRoom mediumRoom = SideTowerRoom.mediumRoom(this.structureManager, this.f_73379_, placement, random);
                mediumRoom.m_142537_((StructurePiece)this, structureStart, random);
                structureStart.m_142679_((StructurePiece)mediumRoom);
                break;
            }
            case 5: {
                SideTowerRoom smallRoom = SideTowerRoom.smallRoom(this.structureManager, this.f_73379_, placement, random);
                smallRoom.m_142537_((StructurePiece)this, structureStart, random);
                structureStart.m_142679_((StructurePiece)smallRoom);
            }
        }
    }

    protected void m_7756_(String label, BlockPos pos, ServerLevelAccessor levelAccessor, Random random, BoundingBox boundingBox) {
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.m_183620_(ctx, structureTag);
        structureTag.m_128405_("width", this.width);
    }
}

