/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.start;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.start.LegacyStructureFeature;

public class TFStructureStart<C extends FeatureConfiguration>
extends StructureStart {
    private boolean conquered = false;

    public TFStructureStart(ConfiguredStructureFeature<C, ?> structureFeature, ChunkPos chunkPos, int references, PiecesContainer pieces) {
        super(structureFeature, chunkPos, references, pieces);
    }

    public CompoundTag m_192660_(StructurePieceSerializationContext level, ChunkPos chunkPos) {
        CompoundTag tag = super.m_192660_(level, chunkPos);
        if (this.m_73603_()) {
            tag.m_128379_("conquered", this.conquered);
        }
        return tag;
    }

    public void load(CompoundTag nbt) {
        this.conquered = nbt.m_128471_("conquered");
    }

    public final void setConquered(boolean flag) {
        this.conquered = flag;
    }

    public final boolean isConquered() {
        return this.conquered;
    }

    private static int getSpawnListIndexAt(StructureStart start, BlockPos pos) {
        int highestFoundIndex = -1;
        for (StructurePiece component : start.m_73602_()) {
            if (!component.m_73547_().m_71051_((Vec3i)pos)) continue;
            if (component instanceof TFStructureComponent) {
                TFStructureComponent tfComponent = (TFStructureComponent)component;
                if (tfComponent.spawnListIndex <= highestFoundIndex) continue;
                highestFoundIndex = tfComponent.spawnListIndex;
                continue;
            }
            return 0;
        }
        return highestFoundIndex;
    }

    public static List<MobSpawnSettings.SpawnerData> gatherPotentialSpawns(StructureFeatureManager structureManager, MobCategory classification, BlockPos pos) {
        for (ConfiguredStructureFeature structure : structureManager.m_207814_().m_206191_(Registry.f_122882_).m_123024_().filter(feature -> {
            ResourceLocation location = feature.f_65403_.getRegistryName();
            return location != null && "twilightforest".equals(location.m_135827_());
        }).toList()) {
            int index;
            StructureFeature structureFeature;
            StructureStart start = structureManager.m_207785_(pos, structure);
            if (!start.m_73603_() || !((structureFeature = structure.f_65403_) instanceof LegacyStructureFeature)) continue;
            LegacyStructureFeature legacyData = (LegacyStructureFeature)structureFeature;
            if (classification != MobCategory.MONSTER) {
                return legacyData.feature.getSpawnableList(classification);
            }
            if (start instanceof TFStructureStart) {
                TFStructureStart s = (TFStructureStart)start;
                if (s.conquered) {
                    return null;
                }
            }
            if ((index = TFStructureStart.getSpawnListIndexAt(start, pos)) < 0) {
                return null;
            }
            return legacyData.feature.getSpawnableMonsterList(index);
        }
        return null;
    }
}

